/*
 * Decompiled with CFR 0.152.
 */
package com4j;

import com4j.Com4jObject;
import com4j.ComObjectListener;
import com4j.ExecutionException;
import com4j.Native;
import com4j.Task;
import com4j.Win32Lock;
import com4j.Wrapper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ComThread
extends Thread {
    private static final ThreadLocal<ComThread> map = new ThreadLocal<ComThread>(){

        @Override
        public ComThread initialValue() {
            if (ComThread.isComThread()) {
                return (ComThread)Thread.currentThread();
            }
            return new ComThread(Thread.currentThread());
        }
    };
    private final Thread peer;
    private Wrapper freeList;
    private Task<?> taskList;
    private int liveObjects = 0;
    private final List<ComObjectListener> listeners = new ArrayList<ComObjectListener>();
    private boolean die = false;
    private final Win32Lock lock = new Win32Lock();
    static final Set<ComThread> threads = Collections.synchronizedSet(new HashSet());

    static ComThread get() {
        return map.get();
    }

    static void detach() {
        map.get().kill();
        map.remove();
    }

    private ComThread(Thread peer) {
        super("ComThread for " + peer.getName());
        this.peer = peer;
        this.setDaemon(true);
        this.start();
    }

    private boolean canExit() {
        return this.die || !this.peer.isAlive() && this.liveObjects == 0;
    }

    public void kill() {
        new Task<Void>(){

            @Override
            public Void call() {
                ComThread.this.die = true;
                return null;
            }
        }.execute(this);
        try {
            this.join();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        threads.add(this);
        try {
            this.run0();
        }
        finally {
            threads.remove(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void run0() {
        Native.coInitialize();
        while (!this.canExit()) {
            this.lock.suspend();
            ComThread comThread = this;
            synchronized (comThread) {
                while (this.freeList != null) {
                    if (this.freeList.dispose0()) {
                        --this.liveObjects;
                    }
                    this.freeList = this.freeList.next;
                }
                while (this.taskList != null) {
                    Task<?> task = this.taskList;
                    this.taskList = task.next;
                    task.invoke();
                }
            }
        }
        Native.coUninitialize();
    }

    synchronized void addToFreeList(Wrapper wrapper) {
        assert (wrapper.next == null);
        wrapper.next = this.freeList;
        this.freeList = wrapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T execute(Task<T> task) {
        Task<T> task2 = task;
        synchronized (task2) {
            ComThread comThread = this;
            synchronized (comThread) {
                task.next = this.taskList;
                this.taskList = task;
            }
            this.lock.activate();
            try {
                task.wait();
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            if (task.exception != null) {
                Throwable e = task.exception;
                task.exception = null;
                throw new ExecutionException(e);
            }
            Object r = task.result;
            task.result = null;
            return r;
        }
    }

    public synchronized void addLiveObject(Com4jObject r) {
        ++this.liveObjects;
        if (!this.listeners.isEmpty()) {
            for (int i = this.listeners.size() - 1; i >= 0; --i) {
                this.listeners.get(i).onNewObject(r);
            }
        }
    }

    static boolean isComThread() {
        return Thread.currentThread() instanceof ComThread;
    }

    public void addListener(ComObjectListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener is null");
        }
        if (this.listeners.contains(listener)) {
            throw new IllegalArgumentException("can't register the same listener twice");
        }
        this.listeners.add(listener);
    }

    public void removeListener(ComObjectListener listener) {
        if (!this.listeners.remove(listener)) {
            throw new IllegalArgumentException("listener isn't registered");
        }
    }

    static {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            public void run() {
                for (ComThread thread : threads.toArray(new ComThread[threads.size()])) {
                    thread.kill();
                }
            }
        });
    }
}

