/*
 * Decompiled with CFR 0.152.
 */
package com4j;

import com4j.ComMethod;
import com4j.DISPID;
import com4j.IllegalAnnotationException;
import com4j.Native;
import com4j.PropGet;
import com4j.PropPut;
import com4j.VTID;
import com4j.Variant;
import java.lang.reflect.Method;

final class DispatchComMethod
extends ComMethod {
    final Method method;
    final int dispId;
    final int flag;
    final Class<?> retType;
    private static final int DISPATCH_METHOD = 1;
    private static final int DISPATCH_PROPERTYGET = 2;
    private static final int DISPATCH_PROPERTYPUT = 4;
    private static final int DISPATCH_PROPERTYPUTREF = 8;

    DispatchComMethod(Method m) {
        this.method = m;
        VTID vtid = m.getAnnotation(VTID.class);
        if (vtid != null) {
            throw new IllegalAnnotationException("@VTID and @DISPID are mutually exclusive: " + m.toGenericString());
        }
        DISPID id = m.getAnnotation(DISPID.class);
        if (id == null) {
            throw new IllegalAnnotationException("@DISPID is missing: " + m.toGenericString());
        }
        this.dispId = id.value();
        this.flag = this.getFlag();
        this.retType = m.getReturnType();
    }

    private int getFlag() {
        PropGet get = this.method.getAnnotation(PropGet.class);
        PropPut put = this.method.getAnnotation(PropPut.class);
        if (get != null && put != null) {
            throw new IllegalAnnotationException("@PropPut and @PropGet are mutually exclusive: " + this.method.toGenericString());
        }
        if (get != null) {
            return 2;
        }
        if (put != null) {
            return 4;
        }
        return 1;
    }

    Object invoke(int ptr, Object[] args) {
        Variant v = Native.invokeDispatch(ptr, this.dispId, this.flag, args);
        if (v == null) {
            return null;
        }
        if (this.retType == Void.TYPE) {
            return null;
        }
        return v.convertTo(this.retType);
    }
}

