/*
 * Decompiled with CFR 0.152.
 */
package com.sun.perseus.model;

import com.sun.perseus.j2d.PaintServer;
import com.sun.perseus.j2d.PaintTarget;
import com.sun.perseus.j2d.RGB;
import com.sun.perseus.j2d.Transform;
import com.sun.perseus.j2d.ViewportProperties;
import com.sun.perseus.model.DocumentNode;
import com.sun.perseus.model.ElementNode;
import com.sun.perseus.model.FloatTraitAnim;
import com.sun.perseus.model.ModelNode;
import com.sun.perseus.model.MotionTraitAnim;
import com.sun.perseus.model.StructureNode;
import com.sun.perseus.model.TraitAnim;
import com.sun.perseus.model.TransformTraitAnim;
import com.sun.perseus.model.Transformable;
import com.sun.perseus.model.ViewportNode;
import org.w3c.dom.DOMException;
import org.w3c.dom.svg.SVGMatrix;
import org.w3c.dom.svg.SVGRGBColor;

public class Group
extends StructureNode
implements Transformable,
ViewportNode,
PaintTarget {
    protected Transform transform;
    protected Transform motion;
    protected Transform inverseTransform;
    protected PaintServer viewportFill = INITIAL_VIEWPORT_FILL;
    protected float viewportFillOpacity = 1.0f;

    public Group(DocumentNode ownerDocument) {
        super(ownerDocument);
    }

    public String getLocalName() {
        return "g";
    }

    public ElementNode newInstance(DocumentNode doc) {
        return new Group(doc);
    }

    public void setTransform(Transform newTransform) {
        if (Group.equal(newTransform, this.transform)) {
            return;
        }
        this.modifyingNode();
        this.transform = newTransform;
        this.recomputeTransformState();
        this.recomputeProxyTransformState();
        this.modifiedNode();
    }

    public void setMotion(Transform newMotion) {
        if (Group.equal(newMotion, this.motion)) {
            return;
        }
        this.modifyingNode();
        this.motion = newMotion;
        this.recomputeTransformState();
        this.recomputeProxyTransformState();
        this.modifiedNode();
    }

    public Transform getTransform() {
        return this.transform;
    }

    public Transform getMotion() {
        return this.motion;
    }

    protected Object getPropertyState(int propertyIndex) {
        switch (propertyIndex) {
            case 0x200000: {
                return this.viewportFill;
            }
        }
        return super.getPropertyState(propertyIndex);
    }

    protected float getFloatPropertyState(int propertyIndex) {
        switch (propertyIndex) {
            case 0x400000: {
                return this.viewportFillOpacity;
            }
        }
        return super.getFloatPropertyState(propertyIndex);
    }

    protected void setPropertyState(int propertyIndex, Object propertyValue) {
        switch (propertyIndex) {
            case 0x200000: {
                this.viewportFill = (PaintServer)propertyValue;
                break;
            }
            default: {
                super.setPropertyState(propertyIndex, propertyValue);
            }
        }
    }

    protected void setFloatPropertyState(int propertyIndex, float propertyValue) {
        switch (propertyIndex) {
            case 0x400000: {
                this.viewportFillOpacity = propertyValue;
                break;
            }
            default: {
                super.setFloatPropertyState(propertyIndex, propertyValue);
            }
        }
    }

    protected boolean isPropertyState(int propertyIndex, Object propertyValue) {
        switch (propertyIndex) {
            case 0x200000: {
                return this.viewportFill == propertyValue;
            }
        }
        return super.isPropertyState(propertyIndex, propertyValue);
    }

    protected boolean isFloatPropertyState(int propertyIndex, float propertyValue) {
        switch (propertyIndex) {
            case 0x400000: {
                return this.viewportFillOpacity == propertyValue;
            }
        }
        return super.isFloatPropertyState(propertyIndex, propertyValue);
    }

    void recomputeInheritedProperties() {
        ModelNode p = this.ownerDocument;
        if (this.parent != null) {
            p = this.parent;
        }
        this.recomputePropertyState(0x200000, p.getPropertyState(0x200000));
        this.recomputeFloatPropertyState(0x400000, p.getFloatPropertyState(0x400000));
        super.recomputeInheritedProperties();
    }

    public void setViewportFill(PaintServer newViewportFill) {
        if (!this.isInherited(0x200000) && Group.equal(newViewportFill, this.viewportFill)) {
            return;
        }
        this.modifyingNode();
        if (this.viewportFill != null) {
            this.viewportFill.dispose();
        }
        this.viewportFill = newViewportFill;
        this.setInheritedQuiet(0x200000, false);
        this.propagatePropertyState(0x200000, this.viewportFill);
        this.modifiedNode();
    }

    public PaintServer getViewportFill() {
        return this.viewportFill;
    }

    public float getViewportFillOpacity() {
        return this.viewportFillOpacity;
    }

    public void setViewportFillOpacity(float newViewportFillOpacity) {
        if (!this.isInherited(0x400000) && newViewportFillOpacity == this.getViewportFillOpacity()) {
            return;
        }
        this.modifyingNode();
        if (newViewportFillOpacity > 1.0f) {
            newViewportFillOpacity = 1.0f;
        } else if (newViewportFillOpacity < 0.0f) {
            newViewportFillOpacity = 0.0f;
        }
        this.setInheritedQuiet(0x400000, false);
        this.viewportFillOpacity = newViewportFillOpacity;
        this.propagateFloatPropertyState(0x400000, this.viewportFillOpacity);
        this.modifiedNode();
    }

    protected Transform appendTransform(Transform tx, Transform workTx) {
        if (this.transform == null && this.motion == null) {
            return tx;
        }
        tx = this.recycleTransform(tx, workTx);
        if (this.motion != null) {
            tx.mMultiply(this.motion);
        }
        if (this.transform != null) {
            tx.mMultiply(this.transform);
        }
        return tx;
    }

    boolean supportsTrait(String traitName) {
        if ("transform" == traitName || "viewport-fill" == traitName || "viewport-fill-opacity" == traitName || "#motion" == traitName) {
            return true;
        }
        return super.supportsTrait(traitName);
    }

    String getSpecifiedTraitImpl(String name) throws DOMException {
        if ("viewport-fill" == name && this.isInherited(0x200000) || "viewport-fill-opacity" == name && this.isInherited(0x400000)) {
            return "inherit";
        }
        return super.getSpecifiedTraitImpl(name);
    }

    public String getTraitImpl(String name) throws DOMException {
        if ("transform" == name) {
            return Group.toStringTrait(this.transform);
        }
        if ("#motion" == name) {
            return Group.toStringTrait(this.motion);
        }
        if ("viewport-fill" == name) {
            return this.toString(this.getViewportFill());
        }
        if ("viewport-fill-opacity" == name) {
            return Float.toString(this.getViewportFillOpacity());
        }
        return super.getTraitImpl(name);
    }

    float getFloatTraitImpl(String name) throws DOMException {
        if ("viewport-fill-opacity" == name) {
            return this.getViewportFillOpacity();
        }
        return super.getFloatTraitImpl(name);
    }

    SVGRGBColor getRGBColorTraitImpl(String name) throws DOMException {
        if ("viewport-fill".equals(name)) {
            return this.toSVGRGBColor("viewport-fill", this.getViewportFill());
        }
        return super.getRGBColorTraitImpl(name);
    }

    public void setTraitImpl(String name, String value) throws DOMException {
        if ("transform" == name) {
            this.setTransform(this.parseTransformTrait(name, value));
        } else if ("#motion" == name) {
            this.setMotion(this.parseTransformTrait(name, value));
        } else if ("viewport-fill" == name) {
            if ("inherit".equals(value)) {
                this.setInherited(0x200000, true);
            } else if ("none".equals(value)) {
                this.setViewportFill(null);
            } else {
                PaintServer viewportFill = this.parsePaintTrait("viewport-fill", this, value);
                if (viewportFill != null) {
                    this.setViewportFill(viewportFill);
                }
            }
        } else if ("viewport-fill-opacity" == name) {
            if ("inherit".equals(value)) {
                this.setFloatInherited(0x400000, true);
            } else {
                this.setViewportFillOpacity(this.parseFloatTrait(name, value));
            }
        } else {
            super.setTraitImpl(name, value);
        }
    }

    SVGMatrix getMatrixTraitImpl(String name) throws DOMException {
        if ("transform".equals(name)) {
            return this.toSVGMatrixTrait(this.transform);
        }
        if ("#motion".equals(name)) {
            return this.toSVGMatrixTrait(this.motion);
        }
        return super.getMatrixTraitImpl(name);
    }

    void setMatrixTraitImpl(String name, Transform matrix) throws DOMException {
        if ("transform".equals(name)) {
            this.setTransform(matrix);
        } else if ("#motion".equals(name)) {
            this.setMotion(matrix);
        } else {
            super.setMatrixTraitImpl(name, matrix);
        }
    }

    public void setFloatTraitImpl(String name, float value) throws DOMException {
        try {
            if ("viewport-fill-opacity" == name) {
                this.setViewportFillOpacity(value);
            } else {
                super.setFloatTraitImpl(name, value);
            }
        }
        catch (IllegalArgumentException iae) {
            throw this.illegalTraitValue(name, Float.toString(value));
        }
    }

    TraitAnim createTraitAnimImpl(String traitName) {
        if ("transform" == traitName) {
            return new TransformTraitAnim(this, traitName);
        }
        if ("#motion" == traitName) {
            return new MotionTraitAnim(this, traitName);
        }
        if ("viewport-fill" == traitName) {
            return new FloatTraitAnim(this, traitName, "SVGRGBColor");
        }
        if ("viewport-fill-opacity" == traitName) {
            return new FloatTraitAnim(this, traitName, "float");
        }
        return super.createTraitAnimImpl(traitName);
    }

    void setFloatArrayTrait(String name, float[][] value) throws DOMException {
        if ("transform".equals(name)) {
            if (this.transform == null) {
                this.modifyingNode();
                this.transform = new Transform(value[0][0], value[1][0], value[2][0], value[3][0], value[4][0], value[5][0]);
            } else if (!this.transform.equals(value)) {
                this.modifyingNode();
                this.transform.setTransform(value[0][0], value[1][0], value[2][0], value[3][0], value[4][0], value[5][0]);
            } else {
                return;
            }
            this.recomputeTransformState();
            this.recomputeProxyTransformState();
            this.modifiedNode();
        } else if ("#motion" == name) {
            if (this.motion == null) {
                this.modifyingNode();
                this.motion = new Transform(value[0][0], value[1][0], value[2][0], value[3][0], value[4][0], value[5][0]);
            } else if (!this.motion.equals(value)) {
                this.modifyingNode();
                this.motion.setTransform(value[0][0], value[1][0], value[2][0], value[3][0], value[4][0], value[5][0]);
            } else {
                return;
            }
            this.recomputeTransformState();
            this.recomputeProxyTransformState();
            this.modifiedNode();
        } else if ("viewport-fill" == name) {
            this.setViewportFill(this.toRGB(name, value));
        } else if ("viewport-fill-opacity" == name) {
            this.setViewportFillOpacity(value[0][0]);
        } else {
            super.setFloatArrayTrait(name, value);
        }
    }

    String validateTraitNS(String namespaceURI, String traitName, String value, String reqNamespaceURI, String reqLocalName, String reqTraitNamespace, String reqTraitName) throws DOMException {
        if (namespaceURI != null && namespaceURI != "#!null/ns@!") {
            return super.validateTraitNS(namespaceURI, traitName, value, reqNamespaceURI, reqLocalName, reqTraitNamespace, reqTraitName);
        }
        if ("viewport-fill" == traitName || "viewport-fill-opacity" == traitName) {
            throw this.unsupportedTraitType(traitName, "float");
        }
        return super.validateTraitNS(namespaceURI, traitName, value, reqNamespaceURI, reqLocalName, reqTraitNamespace, reqTraitName);
    }

    public float[][] validateFloatArrayTrait(String traitName, String value, String reqNamespaceURI, String reqLocalName, String reqTraitNamespace, String reqTraitName) throws DOMException {
        if ("transform" == traitName || "#motion" == traitName) {
            Transform txf = this.parseTransformTrait(traitName, value);
            return new float[][]{{txf.getComponent(0)}, {txf.getComponent(1)}, {txf.getComponent(2)}, {txf.getComponent(3)}, {txf.getComponent(4)}, {txf.getComponent(5)}};
        }
        if ("viewport-fill" == traitName) {
            RGB color = ViewportProperties.INITIAL_VIEWPORT_FILL;
            if ("inherit".equals(value)) {
                color = (RGB)this.getInheritedPropertyState(0x200000);
            } else {
                if ("none".equals(value)) {
                    return new float[0][0];
                }
                color = this.parseColorTrait("viewport-fill", value);
            }
            if (color == null) {
                return new float[0][0];
            }
            return new float[][]{{color.getRed(), color.getGreen(), color.getBlue()}};
        }
        if ("viewport-fill-opacity" == traitName) {
            float v = 1.0f;
            if ("inherit".equals(value)) {
                if (this.parent != null) {
                    v = this.getInheritedFloatPropertyState(0x400000);
                }
            } else {
                v = this.parseFloatTrait(traitName, value);
                if (v < 0.0f) {
                    v = 0.0f;
                } else if (v > 1.0f) {
                    v = 1.0f;
                }
            }
            return new float[][]{{v}};
        }
        return super.validateFloatArrayTrait(traitName, value, reqNamespaceURI, reqLocalName, reqTraitNamespace, reqTraitName);
    }

    String toStringTrait(String name, float[][] value) {
        if ("transform" == name) {
            Transform transform = new Transform(value[0][0], value[1][0], value[2][0], value[3][0], value[4][0], value[5][0]);
            return Group.toStringTrait(transform);
        }
        if ("viewport-fill" == name) {
            if (value == null || value.length == 0) {
                return "none";
            }
            return this.toRGBString(name, value);
        }
        if ("viewport-fill-opacity" == name) {
            return Float.toString(value[0][0]);
        }
        return super.toStringTrait(name, value);
    }

    void setRGBColorTraitImpl(String name, SVGRGBColor color) throws DOMException {
        try {
            if ("viewport-fill".equals(name)) {
                this.setViewportFill((RGB)color);
            } else {
                super.setRGBColorTraitImpl(name, color);
            }
        }
        catch (IllegalArgumentException iae) {
            throw new DOMException(15, iae.getMessage());
        }
    }

    public void onPaintServerUpdate(String paintType, PaintServer paintServer) {
        if (paintType == "viewport-fill") {
            this.setViewportFill(paintServer);
        } else {
            super.onPaintServerUpdate(paintType, paintServer);
        }
    }
}

