/*
 * Decompiled with CFR 0.152.
 */
package org.rubyforge.debugcommons;

import org.rubyforge.debugcommons.model.RubyThread;
import org.rubyforge.debugcommons.model.SuspensionPoint;

public final class RubyDebugEvent {
    private final Type type;
    private final RubyThread rubyThread;
    private final String filePath;
    private final int line;
    private final boolean stepping;

    public RubyDebugEvent(Type type) {
        this(null, type, null, -1, false);
    }

    public RubyDebugEvent(RubyThread rubyThread, SuspensionPoint sp) {
        this(rubyThread, Type.SUSPEND, sp.getFile(), sp.getLine(), sp.isStep());
    }

    public RubyDebugEvent(RubyThread rubyThread, Type type, String filePath, int line, boolean stepping) {
        if (type == Type.SUSPEND) assert (rubyThread != null);
        this.rubyThread = rubyThread;
        this.type = type;
        this.filePath = filePath;
        this.line = line;
        this.stepping = stepping;
    }

    public boolean isSuspensionType() {
        return this.type == Type.SUSPEND;
    }

    public boolean isTerminateType() {
        return this.type == Type.TERMINATE;
    }

    public RubyThread getRubyThread() {
        return this.rubyThread;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public int getLine() {
        return this.line;
    }

    public boolean isStepping() {
        return this.stepping;
    }

    public String toString() {
        return "[RubyDebugEvent@" + System.identityHashCode(this) + "> type: " + (Object)((Object)this.type) + ", rubyThread: " + this.rubyThread + ", line: " + this.line + ", filePath: " + this.filePath + ']';
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        SUSPEND,
        TERMINATE;

    }
}

