/*
 * Decompiled with CFR 0.152.
 */
package it.imolinfo.jbi4corba.jbi.endpoint;

import com.ibm.wsdl.extensions.soap.SOAPAddressImpl;
import com.ibm.wsdl.extensions.soap.SOAPBindingImpl;
import com.ibm.wsdl.extensions.soap.SOAPBodyImpl;
import it.imolinfo.jbi4corba.Logger;
import it.imolinfo.jbi4corba.LoggerFactory;
import it.imolinfo.jbi4corba.exception.ClassGenerationException;
import it.imolinfo.jbi4corba.exception.Jbi4CorbaDeployException;
import it.imolinfo.jbi4corba.exception.Jbi4CorbaException;
import it.imolinfo.jbi4corba.exception.ServiceActivationException;
import it.imolinfo.jbi4corba.exception.ServiceCreationException;
import it.imolinfo.jbi4corba.jbi.Messages;
import it.imolinfo.jbi4corba.jbi.component.runtime.RuntimeContext;
import it.imolinfo.jbi4corba.jbi.endpoint.Jbi4CorbaEndpoint;
import it.imolinfo.jbi4corba.jbi.processor.ConsumerExchangeProcessor;
import it.imolinfo.jbi4corba.jbi.processor.ExchangeProcessor;
import it.imolinfo.jbi4corba.jbi.wsdl.Jbi4CorbaExtensionUtils;
import it.imolinfo.jbi4corba.webservice.descriptor.ConsumerServiceDescriptor;
import it.imolinfo.jbi4corba.webservice.generator.ConsumerServiceClassesGenerator;
import it.imolinfo.jbi4corba.webservice.generator.ServerCorbaClassesHolder;
import it.imolinfo.jbi4corba.webservice.runtime.ConsumerServiceCreator;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.jbi.component.ComponentContext;
import javax.jbi.messaging.DeliveryChannel;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessagingException;
import javax.jbi.servicedesc.ServiceEndpoint;
import javax.wsdl.Binding;
import javax.wsdl.BindingFault;
import javax.wsdl.BindingInput;
import javax.wsdl.BindingOperation;
import javax.wsdl.BindingOutput;
import javax.wsdl.Definition;
import javax.wsdl.Fault;
import javax.wsdl.Input;
import javax.wsdl.Operation;
import javax.wsdl.Output;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.wsdl.Service;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.ExtensionRegistry;
import javax.wsdl.extensions.soap.SOAPAddress;
import javax.wsdl.extensions.soap.SOAPBinding;
import javax.wsdl.extensions.soap.SOAPBody;
import javax.wsdl.extensions.soap.SOAPOperation;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLWriter;
import javax.xml.namespace.QName;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.codehaus.xfire.XFire;
import org.codehaus.xfire.XFireFactory;
import org.omg.CORBA.ORB;
import org.w3c.dom.Document;

public class ConsumerEndpoint
extends Jbi4CorbaEndpoint {
    private static final String SOAP_NAMESPACE_URI = "http://schemas.xmlsoap.org/wsdl/soap/";
    private static final QName SOAP_ADDRESS_QNAME = new QName("http://schemas.xmlsoap.org/wsdl/soap/", "address");
    private static final QName SOAP_BINDING_QNAME = new QName("http://schemas.xmlsoap.org/wsdl/soap/", "binding");
    private static final QName SOAP_BODY_QNAME = new QName("http://schemas.xmlsoap.org/wsdl/soap/", "body");
    private static final QName SOAP_OPERATION_QNAME = new QName("http://schemas.xmlsoap.org/wsdl/soap/", "operation");
    private static final Logger LOG = LoggerFactory.getLogger(ConsumerEndpoint.class);
    private static final Messages MESSAGES = Messages.getMessages(ConsumerEndpoint.class);
    private ConsumerExchangeProcessor consumerExchangeProcessor;
    private ConsumerServiceDescriptor consumerServiceDescriptor;

    public ConsumerEndpoint(QName serviceName, String endpointName, ConsumerServiceDescriptor consumerServiceDescriptor) {
        super(serviceName, endpointName);
        this.consumerServiceDescriptor = consumerServiceDescriptor;
        consumerServiceDescriptor.setEndpoint(this);
        this.consumerExchangeProcessor = new ConsumerExchangeProcessor(this);
    }

    public void activate() throws Jbi4CorbaException {
        this.registerService2();
        this.startServiceAndOrb();
        LOG.debug("consumer endpoint: " + this + " activated.");
    }

    public void sendAsynch(MessageExchange me, DeliveryChannel channel) throws MessagingException {
        LOG.debug("Sending directly (JBI API)");
        channel.send(me);
    }

    private void startServiceAndOrb() throws ServiceActivationException {
        ConsumerServiceCreator consumerServiceCreator = new ConsumerServiceCreator();
        consumerServiceCreator.registerAndActivateService(this.consumerServiceDescriptor);
        final ORB orb = this.consumerServiceDescriptor.getOrb();
        Thread thread = new Thread(new Runnable(){

            public void run() {
                LOG.debug("Activating orb.Thread: " + Thread.currentThread().getName());
                orb.run();
                LOG.debug("Exiting orb.Thread: " + Thread.currentThread().getName());
            }
        }, "ORB Runner for service: " + this);
        thread.setContextClassLoader(this.consumerServiceDescriptor.getServerCorbaClassesHolder().getUrlClassLoader());
        thread.start();
    }

    public void deactivate() throws Exception {
        this.stopServiceAndOrb();
    }

    private void stopServiceAndOrb() {
        this.consumerServiceDescriptor.getOrb().shutdown(false);
    }

    public ExchangeProcessor getProcessor() {
        return this.consumerExchangeProcessor;
    }

    public void registerService() throws Jbi4CorbaDeployException {
    }

    public void registerService2() throws Jbi4CorbaDeployException {
        ServerCorbaClassesHolder serverCorbaClassesHolder;
        Document wsdl;
        this.consumerServiceDescriptor.setComponentRootPath(RuntimeContext.getInstance().getComponentContext().getInstallRoot());
        ServiceEndpoint proxiedService = this.retrieveProxiedEndpointDefinition();
        this.consumerServiceDescriptor.setProxiedService(proxiedService);
        LOG.debug("Component root:" + this.consumerServiceDescriptor.getComponentRootPath());
        try {
            Jbi4CorbaExtensionUtils.removeCorbaElements(this.getDefinition());
        }
        catch (WSDLException e) {
            String msg = MESSAGES.getString("CRB000139_Error_removing_JBI4CORBA_elements", e.getMessage());
            LOG.error(msg, e);
            throw new Jbi4CorbaDeployException(msg, e);
        }
        try {
            wsdl = ConsumerEndpoint.addSoapElements(this.consumerServiceDescriptor);
        }
        catch (WSDLException e) {
            String msg = MESSAGES.getString("CRB000138_Error_adding_SOAP_elements", e.getMessage());
            LOG.error(msg, e);
            throw new Jbi4CorbaDeployException(msg, e);
        }
        this.writeWSDLDocument(wsdl);
        ConsumerServiceClassesGenerator consumerServiceClassesGenerator = new ConsumerServiceClassesGenerator();
        String wsdlFileName = "file://" + this.consumerServiceDescriptor.getWsdlFileName();
        LOG.debug("consumerServiceDescriptor.getRootPath():" + this.consumerServiceDescriptor.getRootPath() + "; consumerServiceDescriptor.getComponentRootPath():" + this.consumerServiceDescriptor.getComponentRootPath());
        try {
            serverCorbaClassesHolder = consumerServiceClassesGenerator.generateConsumerServiceClasses(wsdlFileName, this.consumerServiceDescriptor.getRootPath(), this.consumerServiceDescriptor.getComponentRootPath());
        }
        catch (ClassGenerationException e) {
            String msg = MESSAGES.getString("CRB000103_Unable_to_create_service_classes", wsdlFileName, e.getMessage());
            LOG.error(msg, e);
            throw new Jbi4CorbaDeployException(msg, e);
        }
        XFire xfire = XFireFactory.newInstance().getXFire();
        this.consumerServiceDescriptor.setXfire(xfire);
        this.consumerServiceDescriptor.setServerCorbaClassesHolder(serverCorbaClassesHolder);
        ConsumerServiceCreator consumerServiceCreator = new ConsumerServiceCreator();
        try {
            consumerServiceCreator.createJbiService(this.consumerServiceDescriptor);
        }
        catch (ServiceCreationException e) {
            String msg = MESSAGES.getString("CRB000104_Unable_to_create_jbi_service_consumer", this.consumerServiceDescriptor, e.getMessage());
            LOG.error(msg, e);
            throw new Jbi4CorbaDeployException(msg, e);
        }
    }

    private static Document addSoapElements(ConsumerServiceDescriptor consumerServiceDescriptor) throws WSDLException {
        Definition def = consumerServiceDescriptor.getServiceWSDLDefinition();
        LOG.debug("Definition=" + def);
        boolean soapFound = false;
        LOG.debug("finding soap address ...");
        Port port = null;
        WSDLFactory factory = WSDLFactory.newInstance();
        WSDLWriter writer = factory.newWSDLWriter();
        LOG.debug("addSoapElements[PRE]. soapFound=" + soapFound + "; Port=" + port + "; factory=" + factory + "; writer=" + writer);
        if (def.getBindings() == null || def.getBindings().size() == 0) {
            LOG.debug("The CONCRETE part of the wsdl is missing.");
            Definition newDef = ConsumerEndpoint.addSOAPExtensionsToWSDL(def);
            consumerServiceDescriptor.setServiceWSDLDefinition(newDef);
            return writer.getDocument(newDef);
        }
        LOG.debug("The CONCRETE part of the wsdl is present.");
        for (Object serviceAsObject : def.getServices().values()) {
            Service service = (Service)serviceAsObject;
            LOG.debug("Service=" + service + "; Service.QName=" + service.getQName());
            block1: for (Object obj : service.getPorts().values()) {
                port = (Port)obj;
                for (Object element : port.getExtensibilityElements()) {
                    if (element instanceof SOAPAddress) {
                        soapFound = true;
                        continue block1;
                    }
                    LOG.debug("The elemente is NOT a SOAPAddress");
                }
            }
        }
        LOG.debug("addSoapElements[POST]. soapFound=" + soapFound + "; Port=" + port + "; factory=" + factory + "; writer=" + writer);
        if (!soapFound) {
            LOG.debug("SORRY. soap NOT found.");
            ExtensionRegistry registry = factory.newPopulatedExtensionRegistry();
            LOG.debug("creating ExtensionRegistry=" + registry);
            SOAPAddress soapAddress = (SOAPAddress)registry.createExtension(Port.class, SOAP_ADDRESS_QNAME);
            LOG.debug("creating soapAddress=" + soapAddress);
            SOAPBinding soapBinding = (SOAPBinding)registry.createExtension(Binding.class, SOAP_BINDING_QNAME);
            LOG.debug("creating binding=" + soapBinding);
            SOAPBody inputBody = (SOAPBody)registry.createExtension(BindingInput.class, SOAP_BODY_QNAME);
            LOG.debug("creating body=" + inputBody);
            SOAPOperation soapOperation = (SOAPOperation)registry.createExtension(BindingOperation.class, SOAP_OPERATION_QNAME);
            LOG.debug("creating SoapOperation=" + soapOperation);
            BindingOperation bo = (BindingOperation)port.getBinding().getBindingOperations().get(0);
            soapAddress.setLocationURI("http://localhost/fake_location");
            port.addExtensibilityElement((ExtensibilityElement)soapAddress);
            soapBinding.setTransportURI("http://schemas.xmlsoap.org/soap/http");
            soapBinding.setStyle("document");
            port.getBinding().addExtensibilityElement((ExtensibilityElement)soapBinding);
            soapOperation.setSoapActionURI("");
            bo.addExtensibilityElement((ExtensibilityElement)soapOperation);
            inputBody.setUse("literal");
            ConsumerEndpoint.addSoapBodyIfNotPresent(bo.getBindingInput(), inputBody);
            ConsumerEndpoint.addSoapBodyIfNotPresent(bo.getBindingOutput(), inputBody);
        }
        return writer.getDocument(def);
    }

    private static void addSoapBodyIfNotPresent(BindingInput bindingInput, SOAPBody soapBody) {
        for (Object obj : bindingInput.getExtensibilityElements()) {
            if (!(obj instanceof SOAPBody)) continue;
            return;
        }
        bindingInput.addExtensibilityElement((ExtensibilityElement)soapBody);
    }

    private static void addSoapBodyIfNotPresent(BindingOutput bindingOutput, SOAPBody soapBody) {
        for (Object obj : bindingOutput.getExtensibilityElements()) {
            if (!(obj instanceof SOAPBody)) continue;
            return;
        }
        bindingOutput.addExtensibilityElement((ExtensibilityElement)soapBody);
    }

    protected static PortType findFirstPortType(Definition def) {
        PortType portType = null;
        for (Object portTypeAsObject : def.getPortTypes().keySet()) {
            LOG.debug("PortTypeKEY=" + portTypeAsObject + "; CLASS=" + portTypeAsObject.getClass());
            if (portType != null) continue;
            portType = def.getPortType((QName)portTypeAsObject);
        }
        return portType;
    }

    protected static void addOperationToWsdlBinding(Definition wsdl, PortType portType, Binding wsdlBinding) {
        List operations = portType.getOperations();
        for (Operation operation : operations) {
            Output output;
            BindingOperation bop = wsdl.createBindingOperation();
            bop.setOperation(operation);
            bop.setName(operation.getName());
            Input input = operation.getInput();
            if (input != null) {
                SOAPBodyImpl soapBody = new SOAPBodyImpl();
                soapBody.setUse("literal");
                BindingInput bindingInput = wsdl.createBindingInput();
                bindingInput.setName(input.getName());
                bindingInput.addExtensibilityElement((ExtensibilityElement)soapBody);
                bop.setBindingInput(bindingInput);
            }
            if ((output = operation.getOutput()) != null) {
                SOAPBodyImpl soapBody = new SOAPBodyImpl();
                soapBody.setUse("literal");
                BindingOutput bindingOutput = wsdl.createBindingOutput();
                bindingOutput.setName(output.getName());
                bindingOutput.addExtensibilityElement((ExtensibilityElement)soapBody);
                bop.setBindingOutput(bindingOutput);
            }
            Map faults = operation.getFaults();
            Iterator faultIt = faults.entrySet().iterator();
            while (faultIt.hasNext()) {
                Fault fault = (Fault)faultIt.next().getValue();
                BindingFault bindingFault = wsdl.createBindingFault();
                bindingFault.setName(fault.getName());
                bop.addBindingFault(bindingFault);
            }
            wsdlBinding.addBindingOperation(bop);
        }
    }

    protected static Definition addSOAPExtensionsToWSDL(Definition def) throws WSDLException {
        String defaultLocationURI = "http://localhost/services/defaultSoapAddress";
        PortType portType = ConsumerEndpoint.findFirstPortType(def);
        String portTypeLocalPart = portType.getQName().getLocalPart();
        String portTypeNamespace = portType.getQName().getNamespaceURI();
        String portTypeNameCut = null;
        if (portTypeLocalPart.endsWith("PortType")) {
            int totLen = portTypeLocalPart.length();
            int suffixLen = "PortType".length();
            portTypeNameCut = portTypeLocalPart.substring(0, totLen - suffixLen);
        } else {
            portTypeNameCut = portTypeLocalPart;
        }
        String serviceName = portTypeNameCut + "Service";
        String bindingName = portTypeNameCut + "HttpBinding";
        String portName = portTypeNameCut + "HttpPort";
        LOG.debug("servicename=" + serviceName + "; bindingName=" + bindingName + "; portName=" + portName);
        Binding wsdlBinding = def.createBinding();
        def.addBinding(wsdlBinding);
        wsdlBinding.setQName(new QName(portTypeNamespace, bindingName));
        wsdlBinding.setPortType(portType);
        wsdlBinding.setUndefined(false);
        SOAPAddressImpl soapAddress = new SOAPAddressImpl();
        soapAddress.setLocationURI(defaultLocationURI);
        Port wsdlPort = def.createPort();
        wsdlPort.setName(portName);
        wsdlPort.setBinding(wsdlBinding);
        wsdlPort.addExtensibilityElement((ExtensibilityElement)soapAddress);
        ConsumerEndpoint.addOperationToWsdlBinding(def, portType, wsdlBinding);
        SOAPBindingImpl soapBinding = new SOAPBindingImpl();
        soapBinding.setStyle("document");
        soapBinding.setTransportURI("http://schemas.xmlsoap.org/soap/http");
        wsdlBinding.addExtensibilityElement((ExtensibilityElement)soapBinding);
        Service service = def.createService();
        service.setQName(new QName(portTypeNamespace, serviceName));
        service.addPort(wsdlPort);
        def.addService(service);
        LOG.debug("NEW DEFINITION=" + def);
        return def;
    }

    private void writeWSDLDocument(Document wsdl) throws Jbi4CorbaDeployException {
        Transformer transformer;
        FileWriter fr;
        DOMSource domSource = new DOMSource(wsdl);
        try {
            if (this.consumerServiceDescriptor.getWsdlFileName() == null) {
                this.consumerServiceDescriptor.setWsdlFileName(this.consumerServiceDescriptor.getRootPath() + File.separator + this.consumerServiceDescriptor.getServiceName() + ".wsdl");
            }
            fr = new FileWriter(this.consumerServiceDescriptor.getWsdlFileName());
        }
        catch (IOException e) {
            String msg = MESSAGES.getString("CRB000105_Unable_to_open_filename", this.consumerServiceDescriptor.getWsdlFileName(), e.getMessage());
            LOG.error(msg, e);
            throw new Jbi4CorbaDeployException(msg, e);
        }
        StreamResult streamResult = new StreamResult(fr);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        try {
            transformer = transformerFactory.newTransformer();
        }
        catch (TransformerConfigurationException e) {
            String msg = MESSAGES.getString("CRB000106_Unable_to_create_default_transformer", transformerFactory, e.getMessage());
            LOG.error(msg, e);
            throw new Jbi4CorbaDeployException(msg, e);
        }
        try {
            transformer.transform(domSource, streamResult);
        }
        catch (TransformerException e) {
            String msg = MESSAGES.getString("CRB000107_Unable_to_create_transform", domSource, streamResult, transformer, e.getMessage());
            LOG.error(msg, e);
            throw new Jbi4CorbaDeployException(msg, e);
        }
        try {
            fr.close();
        }
        catch (IOException e) {
            String msg = MESSAGES.getString("CRB000108_Unable_to_close_fileWriter", fr, e.getMessage());
            LOG.error(msg, e);
            throw new Jbi4CorbaDeployException(msg, e);
        }
    }

    public ConsumerServiceDescriptor getConsumerServiceDescriptor() {
        return this.consumerServiceDescriptor;
    }

    public void setConsumerServiceDescriptor(ConsumerServiceDescriptor consumerServiceDescriptor) {
        this.consumerServiceDescriptor = consumerServiceDescriptor;
    }

    protected ServiceEndpoint retrieveProxiedEndpointDefinition() throws Jbi4CorbaDeployException {
        String targetEndpoint = this.consumerServiceDescriptor.getTargetEndpoint();
        QName targetService = this.consumerServiceDescriptor.getTargetService();
        QName targetInterfaceName = this.consumerServiceDescriptor.getTargetInterfaceName();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Retrieving proxied endpoint definition");
            LOG.debug("Target service: " + targetService);
            LOG.debug("Target endpoint: " + targetEndpoint);
            LOG.debug("Target Interface Name: " + targetInterfaceName);
        }
        ComponentContext ctx = RuntimeContext.getInstance().getComponentContext();
        ServiceEndpoint ep = null;
        if (targetService != null || targetEndpoint != null || targetInterfaceName != null) {
            ServiceEndpoint[] eps;
            if (targetService != null && targetEndpoint != null) {
                ep = ctx.getEndpoint(targetService, targetEndpoint);
                if (ep == null) {
                    String msg = MESSAGES.getString("CRB000109_Could_not_retrieve_endpoint", targetService, targetEndpoint, ctx);
                    LOG.error(msg);
                    throw new Jbi4CorbaDeployException(msg);
                }
                LOG.debug("Endpoint retrived using targetService/targetEndpoint:" + targetService + "/" + targetEndpoint);
            }
            if (ep == null && targetService != null) {
                LOG.debug("Returns EP from service");
                eps = ctx.getEndpointsForService(targetService);
                if (eps != null && eps.length > 0) {
                    ep = eps[0];
                }
                if (ep == null) {
                    LOG.error("CRB000110_Could_not_retrieve_endpoint", targetService, ctx);
                    throw new Jbi4CorbaDeployException(MESSAGES.getString("CRB000110_Could_not_retrieve_endpoint", targetService, ctx));
                }
                LOG.debug("Endpoint retrived using targetService:" + targetService);
            }
            if (ep == null && targetInterfaceName != null) {
                LOG.debug("Returns EP from targetInterfaceName");
                eps = ctx.getEndpoints(targetInterfaceName);
                if (eps != null && eps.length > 0) {
                    ep = eps[0];
                }
                if (ep == null) {
                    LOG.error("CRB000111_Could_not_retrieve_endpoint", targetInterfaceName, ctx);
                    throw new Jbi4CorbaDeployException(MESSAGES.getString("CRB000111_Could_not_retrieve_endpoint", targetInterfaceName, ctx));
                }
                LOG.debug("Endpoint retrived using targetInterfaceName:" + targetInterfaceName);
            }
        }
        if (ep != null) {
            LOG.debug("Enpoind retrived");
            LOG.debug("     Service Name:" + ep.getServiceName());
            LOG.debug("     Endpoint Name:" + ep.getEndpointName());
        } else {
            LOG.info("CRB000112_No_endpoint_retrived");
        }
        if (ep == null) {
            LOG.debug("Endpoint is null: pointing to myself");
            ep = ctx.getEndpoint(this.getServiceName(), this.getEndpointName());
        }
        return ep;
    }

    public void validate() throws Jbi4CorbaException {
    }

    public void unregisterService() throws Jbi4CorbaException {
        LOG.info("Service: " + this.getServiceName() + "/" + this.getEndpointName() + " unregistered");
    }

    public MessageExchange.Role getRole() {
        return MessageExchange.Role.CONSUMER;
    }
}

