/*
 * Decompiled with CFR 0.152.
 */
package it.imolinfo.jbi4corba.jbi.wsdl;

import com.ibm.wsdl.util.xml.DOMUtils;
import it.imolinfo.jbi4corba.Logger;
import it.imolinfo.jbi4corba.LoggerFactory;
import it.imolinfo.jbi4corba.jbi.wsdl.Jbi4CorbaAddress;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Properties;
import javax.wsdl.Definition;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.ExtensionRegistry;
import javax.wsdl.extensions.ExtensionSerializer;
import javax.xml.namespace.QName;

public class Jbi4CorbaAddressSerializer
implements ExtensionSerializer {
    private static final Logger LOG = LoggerFactory.getLogger(Jbi4CorbaAddressSerializer.class);

    public void marshall(Class parentType, QName elementType, ExtensibilityElement extension, PrintWriter pw, Definition def, ExtensionRegistry extReg) throws WSDLException {
        String prefix = DOMUtils.getPrefix((String)"uri://schemas.imola.it/jbi/wsdl-extensions/corba/", (Definition)def);
        prefix = prefix + ":";
        LOG.debug("prefix found: " + prefix);
        if (prefix == null) {
            prefix = "imolacorba";
            def.addNamespace("imolacorba", "uri://schemas.imola.it/jbi/wsdl-extensions/corba/");
        }
        if (extension instanceof Jbi4CorbaAddress) {
            Jbi4CorbaAddress jbi4CorbaAddress = (Jbi4CorbaAddress)extension;
            pw.print("<" + prefix + "address");
            DOMUtils.printAttribute((String)"name", (String)jbi4CorbaAddress.getName(), (PrintWriter)pw);
            DOMUtils.printAttribute((String)"localizationType", (String)jbi4CorbaAddress.getLocalizationType(), (PrintWriter)pw);
            if (jbi4CorbaAddress.getCorbaUrl() == null || "".equals(jbi4CorbaAddress.getCorbaUrl())) {
                LOG.debug("No corbaUrl to set.");
            } else {
                DOMUtils.printAttribute((String)"corbaUrl", (String)jbi4CorbaAddress.getCorbaUrl(), (PrintWriter)pw);
            }
            pw.print(">\n");
            this.printORBElement(jbi4CorbaAddress, pw, prefix);
            pw.print("</" + prefix + "address" + ">\n");
        } else {
            LOG.warn("CRB000300_The_extension_element_is_not_a", "address");
        }
    }

    private void printORBElement(Jbi4CorbaAddress jbi4CorbaAddress, PrintWriter pw, String prefix) {
        if (jbi4CorbaAddress.getOrbProperties() != null) {
            pw.print("<" + prefix + "orb" + ">\n");
            Properties orbProperties = jbi4CorbaAddress.getOrbProperties();
            Enumeration<Object> enKeys = orbProperties.keys();
            while (enKeys.hasMoreElements()) {
                String key = (String)enKeys.nextElement();
                String prop = (String)orbProperties.get(key);
                pw.print("<" + prefix + "property");
                DOMUtils.printAttribute((String)"name", (String)key, (PrintWriter)pw);
                DOMUtils.printAttribute((String)"value", (String)prop, (PrintWriter)pw);
                pw.print("/>\n");
            }
            pw.print("</" + prefix + "orb" + ">\n");
        }
    }
}

