/*
 * Decompiled with CFR 0.152.
 */
package it.imolinfo.jbi4corba.webservice.generator.bcm;

import it.imolinfo.jbi4corba.Logger;
import it.imolinfo.jbi4corba.LoggerFactory;
import it.imolinfo.jbi4corba.webservice.generator.bcm.AppenderMethodVisitor;
import it.imolinfo.jbi4corba.webservice.generator.bcm.ByteCodeManipulationUtil;
import java.util.HashMap;
import java.util.Map;
import org.objectweb.asm.ClassAdapter;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;

public class IdlToWsdlAdapter
extends ClassAdapter {
    private static final Logger LOG = LoggerFactory.getLogger(IdlToWsdlAdapter.class);
    protected String className = null;
    protected ClassWriter classWriter = null;
    protected Map<String, String> mapOfFields = new HashMap<String, String>();
    private ByteCodeManipulationUtil bcmUtil = new ByteCodeManipulationUtil();

    public IdlToWsdlAdapter(ClassVisitor cv, ClassWriter cw, String cn) {
        super(cv);
        this.classWriter = cw;
        this.className = cn;
        LOG.debug("new GetterSetterAdapter; ClassVisitor=" + cv + "; ClassWriter=" + cw + "; ClassName=" + cn);
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        LOG.debug(">>>>> visit - begin");
        LOG.debug("VISIT.\n version=" + version + ";\n access=" + access + ";\n name=" + name + ";\n signature=" + signature + ";\n superName=" + superName + ";\n interfaces=" + interfaces);
        if (512 == access) {
            LOG.debug("This class (" + name + ") is an interface.");
        }
        if ((0x400 & access) == 1024) {
            access &= 0xFFFFFBFF;
            LOG.debug("This class (" + name + ") was an abstract " + "... now is a concrete class.");
        } else {
            LOG.debug("This class (" + name + ") is a concrete class.");
        }
        LOG.debug("<<<<< visit - end");
        super.visit(version, access, name, signature, superName, interfaces);
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        LOG.debug(">>>>> visitMethod - begin");
        LOG.debug("visitMethod. access=" + access + "; name=" + name + "; desc=" + desc + "; signature=" + signature + "; exceptions=" + exceptions);
        if ("<init>".equals(name)) {
            LOG.debug("default constructor modifications.");
            AppenderMethodVisitor mv = new AppenderMethodVisitor(super.visitMethod(access, name, desc, signature, exceptions), this.mapOfFields, this.className);
            LOG.debug("<<<<< visitMethod - end. AppenderMethodVisitor=" + (Object)((Object)mv));
            return mv;
        }
        LOG.debug("<<<<< visitMethod - end. methodName=" + name + "; methodDescription=" + desc);
        return super.visitMethod(access, name, desc, signature, exceptions);
    }

    public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
        LOG.debug(">>>>> visitField - begin:" + desc);
        LOG.debug("visitField. access=" + access + "; name=" + name + "; desc=" + desc + "; signature=" + signature + "; value=" + value);
        if (1 == access || 4 == access) {
            this.bcmUtil.createSetter(this.classWriter, this.className, name, desc);
            this.bcmUtil.createGetter(this.classWriter, this.className, name, desc);
            this.mapOfFields.put(name, desc);
        }
        LOG.debug("<<<<< visitField - end");
        return super.visitField(access, name, desc, signature, value);
    }

    public void visitEnd() {
        this.bcmUtil.createToString(this.classWriter);
        this.bcmUtil.createEquals(this.classWriter);
        super.visitEnd();
    }
}

