/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.gravy;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.netbeans.jemmy.JemmyException;
import org.netbeans.jemmy.JemmyProperties;
import org.netbeans.jemmy.Timeoutable;
import org.netbeans.jemmy.Timeouts;
import org.netbeans.jemmy.operators.ComponentOperator;

public class Flasher
implements Timeoutable {
    public static final Color DEFAULT_COLOR = new Color(255, 0, 0);
    protected static final int len = 30;
    protected Color color = DEFAULT_COLOR;
    protected static long WAIT_TIME = 1000L;
    protected boolean separateThread = false;
    protected Timeouts timeouts;

    public void setTimeouts(Timeouts timeouts) {
        this.timeouts = timeouts;
    }

    public Timeouts getTimeouts() {
        return this.timeouts;
    }

    public Flasher() {
        this(false);
    }

    public Flasher(boolean separateThread) {
        this.separateThread = separateThread;
        this.setTimeouts(JemmyProperties.getProperties().getTimeouts());
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public void flash(ComponentOperator op, Point p) {
        this.flash(op.getSource(), p);
    }

    public void flash(ComponentOperator op, int x, int y) {
        this.flash(op.getSource(), x, y);
    }

    public void flash(Component comp, int x, int y) {
        this.flash(comp, new Point(x, y));
    }

    public void flash(final Component comp, final Point p) {
        if (this.separateThread) {
            new Thread(new Runnable(){

                public void run() {
                    Flasher.this.doFlash(comp, p);
                }
            }).start();
        } else {
            this.doFlash(comp, p);
        }
    }

    protected void doFlash(Component comp, Point p) {
        JLayeredPane lpane = null;
        if (comp instanceof JDialog) {
            lpane = ((JDialog)comp).getLayeredPane();
        } else if (comp instanceof JFrame) {
            lpane = ((JFrame)comp).getLayeredPane();
        } else {
            JDialog d = (JDialog)SwingUtilities.getAncestorOfClass(JDialog.class, comp);
            if (d != null) {
                lpane = d.getLayeredPane();
            } else {
                JFrame f = (JFrame)SwingUtilities.getAncestorOfClass(JFrame.class, comp);
                if (f != null) {
                    lpane = f.getLayeredPane();
                } else {
                    throw new JemmyException("Containing dialog or frame not found");
                }
            }
        }
        Point p1 = new Point(p.x + comp.getLocationOnScreen().x - lpane.getLocationOnScreen().x, p.y + comp.getLocationOnScreen().y - lpane.getLocationOnScreen().y);
        FlashPane flash = new FlashPane(p1, lpane.getSize());
        lpane.add((Component)flash, JLayeredPane.DRAG_LAYER);
        lpane.repaint();
        try {
            Thread.currentThread();
            Thread.sleep(this.timeouts.getTimeout("Flasher.FlashTimeout"));
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        lpane.remove(flash);
        lpane.repaint();
    }

    static {
        Timeouts.initDefault((String)"Flasher.FlashTimeout", (long)WAIT_TIME);
    }

    protected class FlashPane
    extends JPanel {
        private Point p;

        public FlashPane(Point p, Dimension d) {
            this.p = p;
            this.setSize(d);
            this.setOpaque(false);
        }

        public synchronized void paint(Graphics g) {
            super.paint(g);
            g.setColor(Flasher.this.color);
            g.drawLine(this.p.x - 30, this.p.y, this.p.x + 30, this.p.y);
            g.drawLine(this.p.x, this.p.y - 30, this.p.x, this.p.y + 30);
        }
    }
}

