/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.gravy;

import java.awt.Component;
import java.io.IOException;
import javax.swing.JComponent;
import org.netbeans.jemmy.ComponentChooser;
import org.netbeans.jemmy.JemmyException;
import org.netbeans.jemmy.JemmyProperties;
import org.netbeans.jemmy.Timeouts;
import org.netbeans.jemmy.Waitable;
import org.netbeans.jemmy.Waiter;
import org.netbeans.jemmy.operators.ContainerOperator;
import org.netbeans.jemmy.operators.JComponentOperator;
import org.netbeans.jemmy.operators.Operator;
import org.openide.cookies.SaveCookie;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.windows.TopComponent;

public class TopComponentOperator
extends JComponentOperator {
    public TopComponentOperator(ContainerOperator parent, String ID) {
        super(parent, (ComponentChooser)new TopComponentChooser(ID));
    }

    public TopComponentOperator(ContainerOperator parent, ComponentChooser chooser) {
        super(parent, chooser);
    }

    public TopComponentOperator(JComponent component) {
        super(component);
    }

    protected static JComponent findTopComponent(ContainerOperator cont, String name, int index, ComponentChooser subchooser) {
        TopComponent c;
        int i;
        Object[] tc = TopComponent.getRegistry().getOpened().toArray();
        Operator.StringComparator comparator = cont == null ? Operator.getDefaultStringComparator() : cont.getComparator();
        for (i = 0; i < tc.length; ++i) {
            c = (TopComponent)tc[i];
            if (!c.isShowing() || !comparator.equals(c.getName(), name) || !TopComponentOperator.isUnder(cont, (Component)c) || subchooser != null && !subchooser.checkComponent((Component)c) || --index >= 0) continue;
            return c;
        }
        for (i = 0; i < tc.length; ++i) {
            c = (TopComponent)tc[i];
            if (c.isShowing() || !TopComponentOperator.isParentShowing((Component)c) || !comparator.equals(c.getName(), name) || !TopComponentOperator.isUnder(cont, (Component)c) || subchooser != null && !subchooser.checkComponent((Component)c) || --index >= 0) continue;
            return c;
        }
        return null;
    }

    private static boolean isParentShowing(Component c) {
        while (c != null) {
            if (c.isShowing()) {
                return true;
            }
            c = c.getParent();
        }
        return false;
    }

    private static boolean isUnder(ContainerOperator cont, Component c) {
        if (cont == null) {
            return true;
        }
        Component comp = cont.getSource();
        while (comp != c && c != null) {
            c = c.getParent();
        }
        return comp == c;
    }

    public void close() {
        new Thread(new Runnable(){

            public void run() {
                TopComponentOperator.this.runMapping(new Operator.MapVoidAction("close"){

                    public void map() {
                        ((TopComponent)TopComponentOperator.this.getSource()).close();
                    }
                });
            }
        }, "thread to close TopComponent").start();
        this.waitComponentShowing(false);
    }

    public void waitClosed() {
        this.getOutput().printLine("Wait topcomponent to be closed \n    : " + this.getSource().toString());
        this.getOutput().printGolden("Wait topcomponent to be closed");
        this.waitState(new ComponentChooser(){

            public boolean checkComponent(Component comp) {
                return !comp.isVisible();
            }

            public String getDescription() {
                return "Closed topcomponent";
            }
        });
    }

    public void save() {
        Node[] nodes = ((TopComponent)this.getSource()).getActivatedNodes();
        if (nodes != null) {
            for (int i = 0; i < nodes.length; ++i) {
                SaveCookie sc = (SaveCookie)nodes[i].getCookie(SaveCookie.class);
                if (sc == null) continue;
                try {
                    sc.save();
                    continue;
                }
                catch (IOException e) {
                    throw new JemmyException("Exception while saving this TopComponent.", (Throwable)e);
                }
            }
        }
    }

    public void closeDiscard() {
        this.setUnmodified();
        this.close();
    }

    private void setUnmodified() {
        Node[] nodes = ((TopComponent)this.getSource()).getActivatedNodes();
        if (nodes != null) {
            for (int i = 0; i < nodes.length; ++i) {
                DataObject dob = (DataObject)nodes[i].getCookie(DataObject.class);
                dob.setModified(false);
            }
        }
    }

    protected static JComponent waitTopComponent(String name, int index) {
        return TopComponentOperator.waitTopComponent(null, name, index, null);
    }

    protected static JComponent waitTopComponent(final ContainerOperator cont, final String name, final int index, final ComponentChooser subchooser) {
        try {
            Waiter waiter = new Waiter(new Waitable(){

                public Object actionProduced(Object obj) {
                    return TopComponentOperator.findTopComponent(cont, name, index, subchooser);
                }

                public String getDescription() {
                    return "Wait TopComponent with name=" + name + " index=" + String.valueOf(index) + (subchooser == null ? "" : " subchooser=" + subchooser.getDescription()) + " loaded";
                }
            });
            Timeouts times = JemmyProperties.getCurrentTimeouts().cloneThis();
            times.setTimeout("Waiter.WaitingTime", times.getTimeout("ComponentOperator.WaitComponentTimeout"));
            waiter.setTimeouts(times);
            waiter.setOutput(JemmyProperties.getCurrentOutput());
            return (JComponent)waiter.waitAction(null);
        }
        catch (InterruptedException e) {
            return null;
        }
    }

    public static class TopComponentChooser
    implements ComponentChooser {
        String ID;

        public TopComponentChooser(String ID) {
            this.ID = ID;
        }

        public boolean checkComponent(Component comp) {
            return comp instanceof TopComponent && comp != null && ((TopComponent)comp).getName() != null && ((TopComponent)comp).getName().indexOf(this.ID) != -1;
        }

        public String getDescription() {
            return "A TopComponent with \"" + this.ID + "\" ID";
        }
    }
}

