/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.gravy.dataconnectivity;

import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import javax.swing.JTable;
import org.netbeans.jellytools.Bundle;
import org.netbeans.jemmy.ComponentChooser;
import org.netbeans.jemmy.JemmyException;
import org.netbeans.jemmy.QueueTool;
import org.netbeans.jemmy.operators.ComponentOperator;
import org.netbeans.jemmy.operators.ContainerOperator;
import org.netbeans.jemmy.operators.JButtonOperator;
import org.netbeans.jemmy.operators.JDialogOperator;
import org.netbeans.jemmy.operators.JEditorPaneOperator;
import org.netbeans.jemmy.operators.JListOperator;
import org.netbeans.jemmy.operators.JPopupMenuOperator;
import org.netbeans.jemmy.operators.JTableOperator;
import org.netbeans.jemmy.operators.JTextComponentOperator;
import org.netbeans.jemmy.operators.Operator;
import org.netbeans.modules.db.sql.visualeditor.querybuilder.QBNodeComponent;
import org.netbeans.modules.db.sql.visualeditor.querybuilder.QueryBuilder;
import org.netbeans.modules.db.sql.visualeditor.querybuilder.QueryBuilderGraphFrame;
import org.netbeans.modules.db.sql.visualeditor.querybuilder.QueryBuilderInputTable;
import org.netbeans.modules.db.sql.visualeditor.querybuilder.QueryBuilderInternalFrame;
import org.netbeans.modules.db.sql.visualeditor.querybuilder.QueryBuilderPane;
import org.netbeans.modules.db.sql.visualeditor.querybuilder.QueryBuilderResultTable;
import org.netbeans.modules.db.sql.visualeditor.querybuilder.QueryBuilderTable;
import org.netbeans.modules.visualweb.gravy.Util;
import org.netbeans.modules.visualweb.gravy.dataconnectivity.AddQueryCriteriaOperator;

public class QueryBuilderOperator
extends ContainerOperator {
    ComponentOperator desktop = null;
    JTextComponentOperator query = null;
    public static final String SORT_TYPE = "Sort Type";
    public static final String SORT_ORDER = "Sort Order";
    public static final String DESCENDING = "Descending";
    public static final String ASCENDING = "Ascending";
    static final String ADD_QUERY_CRITERIA = "Add Query Criteria";
    public static final String CRITERIA = "Criteria";
    private static final String COLUMN = "Column";
    static final String PARSE_QUERY = "Parse Query";
    static final String RUN_QUERY = "Run Query";
    public static final String ADD_TABLE = "Add Table...";
    public static final String ADD_TABLE_TITLE = "Select Table(s) to Add";
    public static final String CANCEL = "Cancel";
    public static final String GROUP_BY = "Group By";
    static final String REMOVE_FROM_QUERY = "Remove from Query";
    public static final String EQUALS = "Equals";
    public static final String NOT_EQUALS = "Not Equals";
    public static final String LESS_THAN = "Less Than";
    public static final String LESS_THAN_EQUALS = "Less Than Equals";
    public static final String GREATER_THAN = "Greater Than";
    public static final String GREATER_THAN_EQUALS = "Greater Than Equals";

    private static Container findQueryBuilder(String tableName) {
        Container container = new JTableOperator((ContainerOperator)Util.getMainWindow(), (ComponentChooser)new QueryBuilderInputTableChooser(tableName)).getParent();
        while (!(container instanceof QueryBuilder)) {
            container = container.getParent();
        }
        return container;
    }

    public QueryBuilderOperator(ContainerOperator parent, String tabId) {
        super(QueryBuilderOperator.findQueryBuilder(tabId));
        this.setComparator((Operator.StringComparator)new Operator.DefaultStringComparator(true, true));
    }

    public QueryBuilderOperator(String tabId) {
        this((ContainerOperator)Util.getMainWindow(), tabId);
    }

    public QueryBuilderOperator(ContainerOperator parent) {
        super(parent, (ComponentChooser)new QueryBuilderChooser());
        this.setComparator((Operator.StringComparator)new Operator.DefaultStringComparator(true, true));
    }

    public QueryBuilderOperator() {
        this((ContainerOperator)Util.getMainWindow());
    }

    public void close() {
        Util.closeWindow();
    }

    public QueryBuilderPaneOperator getGraphFrame() {
        return new QueryBuilderPaneOperator();
    }

    public TableFrameOperator getTableFrame(String tableName) {
        return new TableFrameOperator(tableName);
    }

    public InputTableOperator getInputTable() {
        return new InputTableOperator();
    }

    private ComponentOperator getDesktop() {
        if (this.desktop == null) {
            this.desktop = new QueryBuilderOperator().getGraphFrame();
        }
        return this.desktop;
    }

    public JTextComponentOperator getQueryTextComponent() {
        if (this.query == null) {
            this.query = new JEditorPaneOperator((ContainerOperator)this);
        }
        return this.query;
    }

    public JTableOperator getResultTable() {
        return new JTableOperator((ContainerOperator)this, (ComponentChooser)new Operator.Finder(QueryBuilderResultTable.class));
    }

    public void pushPopup(String menuText) {
        this.getDesktop().clickForPopup(10, 10);
        new JPopupMenuOperator().pushMenuNoBlock(menuText);
    }

    public void addTable(String tableName) {
        this.pushPopup(ADD_TABLE);
        JDialogOperator addTableDialog = new JDialogOperator(ADD_TABLE_TITLE);
        new JListOperator((ContainerOperator)addTableDialog).selectItem(tableName);
        new JButtonOperator((ContainerOperator)addTableDialog, "OK").push();
    }

    public void removeTable(String tableName) {
        Container cont = this.getTableFrame(tableName).getTable().getParent();
        cont = cont.getParent();
        cont = cont.getParent();
        new ContainerOperator(cont.getParent()).clickForPopup(cont.getX() + 3, cont.getY() - 3);
        Util.wait(3000);
        new JPopupMenuOperator().pushMenuNoBlock(REMOVE_FROM_QUERY);
    }

    public void retypeQuery(String newQuery) {
        this.getQueryTextComponent().setText(newQuery);
    }

    public void changeQuery(String substring, String newSubstring) {
        this.getQueryTextComponent().selectText(substring);
        this.getQueryTextComponent().replaceSelection(newSubstring);
    }

    public JTableOperator runQuery() {
        this.getQueryTextComponent().clickForPopup();
        new JPopupMenuOperator().pushMenuNoBlock(RUN_QUERY);
        this.getQueueTool().waitEmpty();
        Util.wait(500);
        return this.getResultTable();
    }

    public void parseQuery() {
        this.getQueryTextComponent().clickForPopup();
        new JPopupMenuOperator().pushMenuNoBlock(PARSE_QUERY);
        this.getQueueTool().waitEmpty();
        Util.wait(1000);
    }

    public AddQueryCriteriaOperator invokeAddCriteria(String column) {
        return this.invokeAddCriteria(this.getInputTable().findCellRow(column));
    }

    public AddQueryCriteriaOperator invokeAddCriteria(int column) {
        InputTableOperator inputTable = this.getInputTable();
        Point p = inputTable.getPointToClick(column, inputTable.findColumn(COLUMN));
        Util.wait(500);
        new QueueTool().waitEmpty();
        inputTable.clickForPopup(p.x, p.y);
        JPopupMenuOperator popup = new JPopupMenuOperator();
        Util.wait(500);
        new QueueTool().waitEmpty();
        popup.pushMenuNoBlock(ADD_QUERY_CRITERIA);
        Util.wait(500);
        new QueueTool().waitEmpty();
        return new AddQueryCriteriaOperator();
    }

    public void addSimpleCriteria(String column, String value, String operatorValue) {
        AddQueryCriteriaOperator dialog = this.invokeAddCriteria(column);
        if (operatorValue != null) {
            dialog.cboCompareType().selectItem(operatorValue);
        }
        dialog.txtValue().setText(value);
        dialog.btOK().push();
    }

    public void addParamCriteria(String column) {
        AddQueryCriteriaOperator dialog = this.invokeAddCriteria(column);
        dialog.rbtParameter().setSelected(true);
        dialog.btOK().push();
    }

    public void addParamCriteria(int column) {
        AddQueryCriteriaOperator dialog = this.invokeAddCriteria(column);
        dialog.rbtParameter().setSelected(true);
        dialog.btOK().push();
    }

    public void selectJoin(String table1, String table2) {
        QueryBuilderGraphFrame gframe = (QueryBuilderGraphFrame)this.getGraphFrame().getSource();
        QueryBuilderInternalFrame fr1 = (QueryBuilderInternalFrame)this.getTableFrame(table1).getSource();
        QueryBuilderInternalFrame fr2 = (QueryBuilderInternalFrame)this.getTableFrame(table2).getSource();
    }

    private Container findTableFrame(String tableName) {
        Container container = new JTableOperator((ContainerOperator)this, (ComponentChooser)new QueryBuilderTableChooser(tableName)).getParent();
        while (!(container instanceof QBNodeComponent)) {
            container = container.getParent();
            System.out.println("TRACE: findTableFrame: " + container.getClass().getName());
        }
        return container;
    }

    public static String getBundleString(String p_text) {
        System.out.println("Getting bundle for " + p_text);
        try {
            return Bundle.getStringTrimmed((String)"com.sun.rave.dataconnectivity.querybuilder.Bundle", (String)p_text);
        }
        catch (JemmyException jemmyException) {
            return null;
        }
    }

    public static class QueryBuilderChooser
    implements ComponentChooser {
        private String tabId = null;

        public QueryBuilderChooser() {
        }

        public QueryBuilderChooser(String _tabId) {
            this.tabId = _tabId;
        }

        public boolean checkComponent(Component comp) {
            boolean res = comp instanceof QueryBuilder;
            if (this.tabId != null && res) {
                String name = new JTableOperator(new ContainerOperator(ContainerOperator.findContainerUnder((Component)comp)), (ComponentChooser)new QueryBuilderInputTableChooser(this.tabId)).getValueAt(0, 2).toString();
                return name.equalsIgnoreCase(this.tabId);
            }
            return res;
        }

        public String getDescription() {
            return QueryBuilder.class.getName();
        }
    }

    public static class QueryBuilderInputTableChooser
    implements ComponentChooser {
        String tableName;

        public QueryBuilderInputTableChooser(String tableName) {
            this.tableName = tableName;
        }

        public boolean checkComponent(Component comp) {
            JTableOperator table;
            return comp instanceof QueryBuilderInputTable && (table = new JTableOperator((JTable)((QueryBuilderInputTable)comp))).getValueAt(0, 2).toString().indexOf(this.tableName) != -1;
        }

        public String getDescription() {
            return "QueryInputTable with name: " + this.tableName;
        }
    }

    public class InputTableOperator
    extends JTableOperator {
        public InputTableOperator() {
            super((ContainerOperator)QueryBuilderOperator.this, (ComponentChooser)new Operator.Finder(QueryBuilderInputTable.class));
        }
    }

    public class QueryBuilderGraphFrameChooser
    implements ComponentChooser {
        public boolean checkComponent(Component comp) {
            return comp instanceof QueryBuilderGraphFrame;
        }

        public String getDescription() {
            return QueryBuilderGraphFrame.class.getName();
        }
    }

    public class QueryBuilderGraphFrameOperator
    extends ContainerOperator {
        public QueryBuilderGraphFrameOperator() {
            super((ContainerOperator)QueryBuilderOperator.this, (ComponentChooser)new QueryBuilderGraphFrameChooser());
        }
    }

    public class QueryBuilderPaneChooser
    implements ComponentChooser {
        public boolean checkComponent(Component comp) {
            return comp instanceof QueryBuilderPane;
        }

        public String getDescription() {
            return "QueryBuilderPane Component";
        }
    }

    public class QueryBuilderPaneOperator
    extends ContainerOperator {
        public QueryBuilderPaneOperator() {
            super((ContainerOperator)QueryBuilderOperator.this, (ComponentChooser)new QueryBuilderPaneChooser());
        }
    }

    public class TableFrameChooser
    implements ComponentChooser {
        String tableName;

        public TableFrameChooser(String tableName) {
            this.tableName = tableName;
        }

        public boolean checkComponent(Component comp) {
            return comp instanceof QueryBuilderPane;
        }

        public String getDescription() {
            return "TableFrameChooser";
        }
    }

    public class QueryBuilderTableChooser
    implements ComponentChooser {
        String tableName;

        public QueryBuilderTableChooser(String tableName) {
            this.tableName = tableName;
        }

        public boolean checkComponent(Component comp) {
            boolean res = comp instanceof QueryBuilderTable;
            if (res) {
                int i;
                String firstValue = ((QueryBuilderTable)comp).getValueAt(0, 2).toString();
                String secondValue = ((QueryBuilderTable)comp).getValueAt(1, 2).toString();
                boolean firstFound = false;
                boolean secondFound = false;
                InputTableOperator inputTable = QueryBuilderOperator.this.getInputTable();
                int rowCout = inputTable.getRowCount();
                for (i = 0; i < rowCout; ++i) {
                    if (!inputTable.getValueAt(i, 0).toString().equals(firstValue) || inputTable.getValueAt(i, 2).toString().indexOf(this.tableName) == -1) continue;
                    firstFound = true;
                    break;
                }
                for (i = 0; i < rowCout; ++i) {
                    if (!inputTable.getValueAt(i, 0).toString().equals(secondValue) || inputTable.getValueAt(i, 2).toString().indexOf(this.tableName) == -1) continue;
                    secondFound = true;
                    break;
                }
                return firstFound && secondFound;
            }
            return false;
        }

        public String getDescription() {
            return "Chooser for QueryBuilderTable";
        }
    }

    public class TableFrameOperator
    extends ContainerOperator {
        JTableOperator table;
        String tableName;

        public TableFrameOperator(String tableName) {
            super(QueryBuilderOperator.this.findTableFrame(tableName));
            this.table = null;
            this.tableName = tableName;
        }

        public String getTitle() {
            return this.tableName;
        }

        public ContainerOperator getTitleOperator() {
            Container cont = this.getTable().getParent();
            cont = cont.getParent();
            return new ContainerOperator(cont);
        }

        public JTableOperator getTable() {
            if (this.table == null) {
                this.table = new JTableOperator((ContainerOperator)this, (ComponentChooser)new QueryBuilderTableChooser());
                this.getQueueTool().waitEmpty(100L);
            }
            return this.table;
        }

        public void changeFieldSelection(String fieldName) {
            System.out.println(fieldName);
            System.out.println(this.getTable().findCell(fieldName, 0));
            int row = this.getTable().findCell((String)fieldName, (int)0).y;
            if (row == -1) {
                throw new JemmyException("Can not find \"" + fieldName + "\" in \"\" table");
            }
            this.getTable().clickOnCell(row, 0);
        }

        public class QueryBuilderTableChooser
        implements ComponentChooser {
            public boolean checkComponent(Component comp) {
                boolean res = comp instanceof QueryBuilderTable;
                if (res) {
                    int i;
                    String firstValue = ((QueryBuilderTable)comp).getValueAt(0, 2).toString();
                    String secondValue = ((QueryBuilderTable)comp).getValueAt(1, 2).toString();
                    boolean firstFound = false;
                    boolean secondFound = false;
                    InputTableOperator inputTable = QueryBuilderOperator.this.getInputTable();
                    int rowCout = inputTable.getRowCount();
                    for (i = 0; i < rowCout; ++i) {
                        if (!inputTable.getValueAt(i, 0).toString().equals(firstValue) || inputTable.getValueAt(i, 2).toString().indexOf(TableFrameOperator.this.tableName) == -1) continue;
                        firstFound = true;
                        break;
                    }
                    for (i = 0; i < rowCout; ++i) {
                        if (!inputTable.getValueAt(i, 0).toString().equals(secondValue) || inputTable.getValueAt(i, 2).toString().indexOf(TableFrameOperator.this.tableName) == -1) continue;
                        secondFound = true;
                        break;
                    }
                    return firstFound && secondFound;
                }
                return false;
            }

            public String getDescription() {
                return "Chooser for QueryBuilderTable";
            }
        }
    }
}

