/*
 * Decompiled with CFR 0.152.
 */
package com4j;

import com4j.COM4J;
import com4j.Com4jObject;
import com4j.ComException;
import com4j.ComMethod;
import com4j.ComThread;
import com4j.DISPID;
import com4j.DefaultedComMethod;
import com4j.DispatchComMethod;
import com4j.EventProxy;
import com4j.GUID;
import com4j.IConnectionPointContainer;
import com4j.Native;
import com4j.ReturnValue;
import com4j.StandardComMethod;
import com4j.Task;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class Wrapper
implements InvocationHandler,
Com4jObject {
    private int ptr;
    private int hashCode = 0;
    Wrapper next;
    private final ComThread thread;
    private Map<Method, ComMethod> cache = Collections.synchronizedMap(new WeakHashMap());
    private static final Object[] EMPTY_ARRAY = new Object[0];
    InvocationThunk invCache;

    private Wrapper(int ptr) {
        if (ptr == 0) {
            throw new IllegalArgumentException();
        }
        assert (ComThread.isComThread());
        this.ptr = ptr;
        this.thread = ComThread.get();
    }

    static <T extends Com4jObject> T create(Class<T> primaryInterface, int ptr) {
        Wrapper w = new Wrapper(ptr);
        Com4jObject r = (Com4jObject)primaryInterface.cast(Proxy.newProxyInstance(primaryInterface.getClassLoader(), new Class[]{primaryInterface}, (InvocationHandler)w));
        w.thread.addLiveObject(r);
        return (T)r;
    }

    static Com4jObject create(int ptr) {
        Wrapper w = new Wrapper(ptr);
        w.thread.addLiveObject(w);
        return w;
    }

    int getPtr() {
        return this.ptr;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.ptr != 0) {
            this.thread.addToFreeList(this);
        }
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Class<?> declClazz;
        if (this.ptr == 0) {
            throw new IllegalStateException("COM object is already disposed");
        }
        if (args == null) {
            args = EMPTY_ARRAY;
        }
        if ((declClazz = method.getDeclaringClass()) == Com4jObject.class || declClazz == Object.class) {
            try {
                return method.invoke((Object)this, args);
            }
            catch (IllegalAccessException e) {
                throw new IllegalAccessError(e.getMessage());
            }
            catch (InvocationTargetException e) {
                throw e.getTargetException();
            }
        }
        if (this.invCache == null) {
            this.invCache = new InvocationThunk();
        }
        return this.invCache.invoke(this.getMethod(method), args);
    }

    private ComMethod getMethod(Method method) {
        ComMethod r = this.cache.get(method);
        if (r != null) {
            return r;
        }
        r = this.createComMethod(method);
        this.cache.put(method, r);
        return r;
    }

    private ComMethod createComMethod(Method method) {
        ReturnValue rv = method.getAnnotation(ReturnValue.class);
        if (rv != null && rv.defaultPropertyThrough().length > 0) {
            return new DefaultedComMethod(method, rv);
        }
        DISPID id = method.getAnnotation(DISPID.class);
        if (id != null) {
            return new DispatchComMethod(method);
        }
        return new StandardComMethod(method);
    }

    @Override
    public void dispose() {
        if (this.ptr != 0) {
            new Task<Void>(){

                @Override
                public Void call() {
                    Wrapper.this.dispose0();
                    return null;
                }
            }.execute();
        }
    }

    boolean dispose0() {
        boolean r = this.ptr != 0;
        Native.release(this.ptr);
        this.ptr = 0;
        return r;
    }

    @Override
    public <T extends Com4jObject> boolean is(Class<T> comInterface) {
        try {
            GUID iid = COM4J.getIID(comInterface);
            return (Integer)new QITestTask(iid).execute(this.thread) != 0;
        }
        catch (ComException e) {
            return false;
        }
    }

    @Override
    public <T extends Com4jObject> T queryInterface(final Class<T> comInterface) {
        return (T)((Com4jObject)new Task<T>(){

            @Override
            public T call() {
                GUID iid = COM4J.getIID(comInterface);
                int nptr = Native.queryInterface(Wrapper.this.ptr, iid);
                if (nptr == 0) {
                    return null;
                }
                return Wrapper.create(comInterface, nptr);
            }
        }.execute(this.thread));
    }

    @Override
    public <T> EventProxy<?> advise(final Class<T> eventInterface, final T object) {
        return (EventProxy)new Task<EventProxy<?>>(){

            @Override
            public EventProxy<?> call() {
                IConnectionPointContainer cpc = Wrapper.this.queryInterface(IConnectionPointContainer.class);
                if (cpc == null) {
                    throw new ComException("This object doesn't have event source", -1);
                }
                GUID iid = COM4J.getIID(eventInterface);
                Com4jObject cp = cpc.FindConnectionPoint(iid);
                EventProxy<Object> proxy = new EventProxy<Object>(eventInterface, object);
                proxy.nativeProxy = Native.advise(COM4J.getPtr(cp), proxy, iid.v[0], iid.v[1]);
                cpc.dispose();
                cp.dispose();
                return proxy;
            }
        }.execute();
    }

    @Override
    public String toString() {
        return "ComObject:" + Integer.toHexString(this.ptr);
    }

    @Override
    public final int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = this.ptr != 0 ? (Integer)new QITestTask(COM4J.IID_IUnknown).execute(this.thread) : 0;
        }
        return this.hashCode;
    }

    @Override
    public final boolean equals(Object rhs) {
        if (!(rhs instanceof Com4jObject)) {
            return false;
        }
        return this.hashCode() == rhs.hashCode();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class QITestTask
    extends Task<Integer> {
        private final GUID iid;

        public QITestTask(GUID iid) {
            this.iid = iid;
        }

        @Override
        public Integer call() {
            int nptr = Native.queryInterface(Wrapper.this.ptr, this.iid);
            if (nptr != 0) {
                Native.release(nptr);
            }
            return nptr;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class InvocationThunk
    extends Task<Object> {
        private ComMethod method;
        private Object[] args;

        private InvocationThunk() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized Object invoke(ComMethod method, Object[] args) {
            Wrapper.this.invCache = null;
            this.method = method;
            this.args = args;
            try {
                Object t = this.execute(Wrapper.this.thread);
                return t;
            }
            finally {
                Wrapper.this.invCache = this;
            }
        }

        @Override
        public synchronized Object call() {
            Object r = this.method.invoke(Wrapper.this.ptr, this.args);
            this.method = null;
            this.args = null;
            return r;
        }
    }
}

