<%-- /*
* Copyright 2005 Sun Microsystems, Inc. All rights reserved.
*
* Redistribution and use in source and binary forms, with or without
* modification, are permitted provided that the following conditions
* are met:
*
* - Redistributions of source code must retain the above copyright
*   notice, this list of conditions and the following disclaimer.
*
* - Redistribution in binary form must reproduce the above copyright
*   notice, this list of conditions and the following disclaimer in
*   the documentation and/or other materials provided with the
*   distribution.
*
* Neither the name of Sun Microsystems, Inc. or the names of
* contributors may be used to endorse or promote products derived
* from this software without specific prior written permission.
*
* This software is provided "AS IS," without a warranty of any
* kind. ALL EXPRESS OR IMPLIED CONDITIONS, REPRESENTATIONS AND
* WARRANTIES, INCLUDING ANY IMPLIED WARRANTY OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE OR NON-INFRINGEMENT, ARE HEREBY
* EXCLUDED. SUN AND ITS LICENSORS SHALL NOT BE LIABLE FOR ANY DAMAGES
* SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR
* DISTRIBUTING THE SOFTWARE OR ITS DERIVATIVES. IN NO EVENT WILL SUN
* OR ITS LICENSORS BE LIABLE FOR ANY LOST REVENUE, PROFIT OR DATA, OR
* FOR DIRECT, INDIRECT, SPECIAL, CONSEQUENTIAL, INCIDENTAL OR
* PUNITIVE DAMAGES, HOWEVER CAUSED AND REGARDLESS OF THE THEORY OF
* LIABILITY, ARISING OUT OF THE USE OF OR INABILITY TO USE SOFTWARE,
* EVEN IF SUN HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
*
* You acknowledge that Software is not designed, licensed or intended
* for use in the design, construction, operation or maintenance of
* any nuclear facility.
*/
--%>
<%@ taglib prefix="sql" uri="http://java.sun.com/jsp/jstl/sql" %>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %> 
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt" %>
<%@page contentType="text/html"%>

<fmt:setLocale value="en_US" />

<sql:setDataSource dataSource="jdbc/CatalogDB"/>
<sql:query var="packageContents"> 
 select p.name, p.description,p.location, p.price , l.name as lodgingname, l.description as lodgingdescription, l.price as lodgingprice, p.imageuri, l.imageuri as lodgingimageuri from package p, lodging l where p.lodgingid = l.lodgingid and p.packageid = ? and p.locale = ?
 <sql:param>${param.PACKAGE_ID}</sql:param>
 <sql:param>en_US</sql:param>
</sql:query>
<sql:query var="activityDetails"> 
 select activity.name, activity.description, activity.price, activity.imageuri from activity, activitylist, package where package.packageid = activitylist.packageid and activity.activityid = activitylist.activityid and package.packageid = ? and package.locale = ?
 <sql:param>${param.PACKAGE_ID}</sql:param>
 <sql:param>en_US</sql:param>
</sql:query>

<table border="0" width="100%">

  <tr>
     <td>
     <c:url var="imageURL" value="images/${packageContents.rows[0].imageuri}"/>
     <image src="${imageURL}" alt="${packageContents.rows[0].name} Image">
   </td>
    <td>
    <h1>${packageContents.rows[0].name}</h1><br><br>
    <b> Location :</b>${packageContents.rows[0].location} <br><br>
     ${packageContents.rows[0].description} <br><br>
    <b>Estimated Price :</b>
    <fmt:formatNumber value="${packageContents.rows[0].price}" type="currency" /></b></td>
    <td align="right">
     <form mthod="POST" action="cart.do">
     <input type="HIDDEN" name="target_action" value="select_package">
     <input type="HIDDEN" name="package_id" value="${param.PACKAGE_ID}">
     <input type="SUBMIT" value="Select Package" name="Select Package">
    </form>
    </td>
  </tr> 
</table>
<table width="100%" border="0">
  <tr>   
   <td colspan="3" >
    <h2>Lodging Details </h2>
   </td>
  </tr>
  <tr>
   <td>&nbsp;&nbsp;&nbsp;</td>
   <td>
     <c:url var="imageURL" value="images/${packageContents.rows[0].lodgingimageuri}"/>
     <image src="${imageURL}" alt="${packageContents.rows[0].lodgingname} Image">
    </td>
    <td>
        Name : ${packageContents.rows[0].lodgingname}<br>
       ${packageContents.rows[0].lodgingdescription}<br>  
        <b>Price : <fmt:formatNumber value="${packageContents.rows[0].lodgingprice}" type="currency" />  &nbsp; ${packageContent[5]}</b><br> 
   </td>   
  </tr>

  <tr>   
   <td colspan="3" >
    <h2>Included Activities</h2>
   </td>
  </tr>
        <c:forEach var="activityDetail" items="${activityDetails.rows}">
          <tr>
           <td>&nbsp;&nbsp;&nbsp;</td>
           <td>
            <c:url var="imageURL" value="images/${activityDetail.imageuri}"/>
            <image src="${imageURL}" alt="${activityDetail.name} Image">
           </td>
         <td>
          <b><c:out value="${activityDetail.name}"/></b><br> 
          ${activityDetail.description}<br> 
           <b>Price : <fmt:formatNumber value="${activityDetail.price}" type="currency" /></b>
          </td>
         </tr>
        </c:forEach>
  <tr/>
 <tr><td colsapn="3">&nbsp;</td></tr>
  <tr>
    <td colspan="4" align="right">
     <form mthod="POST" action="cart.do">
     <input type="HIDDEN" name="target_action" value="select_package">
     <input type="HIDDEN" name="package_id" value="${param.PACKAGE_ID}">
     <input type="SUBMIT" value="Select Package" name="Select Package">
    </form>
   </td>
  </tr>
 </table>