/*
* Copyright 2005 Sun Microsystems, Inc. All rights reserved.
*
* Redistribution and use in source and binary forms, with or without
* modification, are permitted provided that the following conditions
* are met:
*
* - Redistributions of source code must retain the above copyright
*   notice, this list of conditions and the following disclaimer.
*
* - Redistribution in binary form must reproduce the above copyright
*   notice, this list of conditions and the following disclaimer in
*   the documentation and/or other materials provided with the
*   distribution.
*
* Neither the name of Sun Microsystems, Inc. or the names of
* contributors may be used to endorse or promote products derived
* from this software without specific prior written permission.
*
* This software is provided "AS IS," without a warranty of any
* kind. ALL EXPRESS OR IMPLIED CONDITIONS, REPRESENTATIONS AND
* WARRANTIES, INCLUDING ANY IMPLIED WARRANTY OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE OR NON-INFRINGEMENT, ARE HEREBY
* EXCLUDED. SUN AND ITS LICENSORS SHALL NOT BE LIABLE FOR ANY DAMAGES
* SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR
* DISTRIBUTING THE SOFTWARE OR ITS DERIVATIVES. IN NO EVENT WILL SUN
* OR ITS LICENSORS BE LIABLE FOR ANY LOST REVENUE, PROFIT OR DATA, OR
* FOR DIRECT, INDIRECT, SPECIAL, CONSEQUENTIAL, INCIDENTAL OR
* PUNITIVE DAMAGES, HOWEVER CAUSED AND REGARDLESS OF THE THEORY OF
* LIABILITY, ARISING OUT OF THE USE OF OR INABILITY TO USE SOFTWARE,
* EVEN IF SUN HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
*
* You acknowledge that Software is not designed, licensed or intended
* for use in the design, construction, operation or maintenance of
* any nuclear facility.
*/

package com.sun.j2ee.blueprints.opc.utils;

import javax.jms.*;

import com.sun.j2ee.blueprints.servicelocator.*;
import com.sun.j2ee.blueprints.servicelocator.ejb.*;
import com.sun.j2ee.blueprints.opc.JNDINames;

public class JMSUtils {

    public static boolean sendMessage(String jmsDest, String property, 
              String value, String xmlDoc) {
  Connection jmsCon = null;
  try {
      ServiceLocator sl = new ServiceLocator(); 
      ConnectionFactory jmsConFactory = sl.getJMSConnectionFactory(JNDINames.OPC_QUEUE_CONNECTION_FACTORY);
      Destination target = sl.getJMSDestination(jmsDest);
      jmsCon = jmsConFactory.createConnection();
      Session jmsSession = jmsCon.createSession(true,0);
      MessageProducer jmsSender = jmsSession.createProducer(target);
      TextMessage message = jmsSession.createTextMessage(xmlDoc);
      message.setStringProperty(property, value);
      jmsSender.send(message);
        } catch (ServiceLocatorException se) {
      System.err.println("JMSUtil exception " + se.getMessage());
      return false;
  } catch (JMSException exe) {
      System.err.println("JMSUtil exception " + exe.getMessage());
      return false;
  } catch (Exception ge) {
      System.err.println("JMSUtil exception " + ge.getMessage());
      return false;
        } finally {
            if (jmsCon != null) {
                try {
                    jmsCon.close();
                } catch (JMSException exe) {
        System.err.println("JMSUtil exception " + exe.getMessage());
        return false;
                }
            }
        }
  return true;
    }

    public static boolean sendMessage(String jmsDest, String property, 
              String value, Object obj) {  
  Connection jmsCon = null;
  try {
      ServiceLocator sl = new ServiceLocator(); 
      ConnectionFactory jmsConFactory = sl.getJMSConnectionFactory(JNDINames.OPC_QUEUE_CONNECTION_FACTORY);
      Destination target = sl.getJMSDestination(jmsDest);
            jmsCon = jmsConFactory.createConnection();
            Session jmsSession = jmsCon.createSession(true,0);
            MessageProducer jmsSender = jmsSession.createProducer(target);
            ObjectMessage message = jmsSession.createObjectMessage((java.io.Serializable) obj);
            message.setStringProperty(property, value); 
            jmsSender.send(message);
        } catch (ServiceLocatorException se) {
      System.err.println("JMSUtil exception" + se.getMessage());
      return false;
  } catch (JMSException exe) {
      System.err.println("JMSUtil exception " + exe.getMessage());
      return false;
  } catch (Exception ge) {
      System.err.println("JMSUtil exception " + ge.getMessage());
      return false;
        } finally {
            if (jmsCon != null) {
                try {
                    jmsCon.close();
                } catch (JMSException exe) {
        System.err.println("JMSUtil exception " + exe.getMessage());
        return false;
                }
            }
        }
  return true;
    }
}
