/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */

package org.netbeans.modules.apisupport.project.ui.wizard.librarydescriptor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.netbeans.api.project.libraries.LibrariesCustomizer;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.modules.apisupport.project.ui.platform.LibrariesModel;
import org.netbeans.modules.apisupport.project.ui.wizard.BasicWizardIterator;
import org.openide.WizardDescriptor;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

/**
 * Represents <em>Libraries</em> panel in J2SE Library Descriptor Wizard.
 *
 * @author Radek Matous
 */
final class SelectLibraryPanel extends BasicWizardIterator.Panel {
    
    private NewLibraryDescriptor.DataModel data;
    
    /**
     * Creates new form SelectLibraryPanel
     */
    public SelectLibraryPanel(WizardDescriptor setting, NewLibraryDescriptor.DataModel data) {
        super(setting);
        this.data = data;
        initComponents();
        initAccessibility();
        putClientProperty("NewFileWizard_Title", getMessage("LBL_LibraryWizardTitle"));
        
    }
    
    private void initAccessibility() {
        this.getAccessibleContext().setAccessibleDescription(getMessage("ACS_SelectLibraryPanel"));
        manageLibrariessButton.getAccessibleContext().setAccessibleDescription(getMessage("ACS_CTL_ManageLibraries"));
        librariesValue.getAccessibleContext().setAccessibleDescription(getMessage("ACS_LBL_Library"));
    }
    
    private void checkValidity() {
        //TODO: 
        markValid();
    }
    
    Library getSelectedLibrary() {
        return (librariesValue != null) ?(Library)librariesValue.getSelectedItem() : null;
    }
    
    protected void storeToDataModel() {
        data.setLibrary(getSelectedLibrary());
    }
    
    protected void readFromDataModel() {
        checkValidity();
    }
    
    protected String getPanelName() {
        return getMessage("LBL_SelectLibraryPanel_Title");
    }
    
    protected HelpCtx getHelp() {
        return new HelpCtx(SelectLibraryPanel.class);
    }
    
    private static String getMessage(String key) {
        return NbBundle.getMessage(SelectLibraryPanel.class, key);
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        platformPanel = new javax.swing.JPanel();
        library = new javax.swing.JLabel();
        librariesValue = LibrariesModel.getComboBox();
        manageLibrariessButton = new javax.swing.JButton();
        fillerPanel = new javax.swing.JPanel();
        fillerLabel = new javax.swing.JLabel();

        setLayout(new java.awt.GridBagLayout());

        platformPanel.setLayout(new java.awt.GridBagLayout());

        library.setLabelFor(librariesValue);
        org.openide.awt.Mnemonics.setLocalizedText(library, org.openide.util.NbBundle.getMessage(SelectLibraryPanel.class, "LBL_Library"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 0, 12);
        platformPanel.add(library, gridBagConstraints);

        librariesValue.addItemListener(new java.awt.event.ItemListener() {
            public void itemStateChanged(java.awt.event.ItemEvent evt) {
                librariesValueItemStateChanged(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 0, 12);
        platformPanel.add(librariesValue, gridBagConstraints);

        org.openide.awt.Mnemonics.setLocalizedText(manageLibrariessButton, org.openide.util.NbBundle.getMessage(SelectLibraryPanel.class, "CTL_ManageLibraries"));
        manageLibrariessButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                manageLibraries(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        platformPanel.add(manageLibrariessButton, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        add(platformPanel, gridBagConstraints);

        fillerPanel.setLayout(new java.awt.GridBagLayout());

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        fillerPanel.add(fillerLabel, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        add(fillerPanel, gridBagConstraints);

    }
    // </editor-fold>//GEN-END:initComponents
    
    private void librariesValueItemStateChanged(java.awt.event.ItemEvent evt) {//GEN-FIRST:event_librariesValueItemStateChanged
        checkValidity();
    }//GEN-LAST:event_librariesValueItemStateChanged
    
    private void manageLibraries(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_manageLibraries
        LibrariesModel model = (LibrariesModel) librariesValue.getModel();
        Collection oldLibraries = Arrays.asList(model.getLibraries());
        LibrariesCustomizer.showCustomizer((Library)librariesValue.getSelectedItem());
        List<Library> currentLibraries = Arrays.asList(model.getLibraries());
        Collection<Library> newLibraries = new ArrayList<Library>(currentLibraries);
        
        newLibraries.removeAll(oldLibraries);
        int indexes[] = new int [newLibraries.size()];
        
        int i=0;
        for (Iterator<Library> it = newLibraries.iterator(); it.hasNext(); i++) {
            indexes[i] = currentLibraries.indexOf(it.next());
        }
        if (indexes.length > 0 && i > 0) {
            librariesValue.setSelectedIndex(indexes[i-1]);
        }
    }//GEN-LAST:event_manageLibraries
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JLabel fillerLabel;
    private javax.swing.JPanel fillerPanel;
    private javax.swing.JComboBox librariesValue;
    private javax.swing.JLabel library;
    private javax.swing.JButton manageLibrariessButton;
    private javax.swing.JPanel platformPanel;
    // End of variables declaration//GEN-END:variables
    
}
