/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */

package org.netbeans.modules.cnd.make2netbeans.test;

import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.filechooser.FileFilter;
import org.netbeans.modules.cnd.api.utils.FileChooser;
import org.netbeans.modules.cnd.api.utils.MakefileFileFilter;
import org.netbeans.modules.cnd.makeproject.api.remote.FilePathAdaptor;


/**
 * The first panel of wizard
 * @author Andrey Gubichev
 */
public final class TestVisualPanel1 extends JPanel {

    private static final String DEFAULT_BUILD = "${MAKE} "; // NOI18N
    private static final String DEFAULT_CLEAN = "${MAKE} clean "; // NOI18N

    /** Creates new form TestVisualPanel1 */
    public TestVisualPanel1() {
        initComponents();
        makefilePath = null;
        projectFolder = null;
        projectName = null;
        buildCommand = DEFAULT_BUILD;
        cleanCommand = DEFAULT_CLEAN;
        output = null;
        buildCommandTextField.setText(buildCommand);
        cleanCommandTextField.setText(cleanCommand);
    }

    /**
     *
     * @return name of panel
     */
    @Override
    public String getName() {
        return "Step #1"; // NOI18N
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        folderLabel = new javax.swing.JLabel();
        projectFolderTextField = new javax.swing.JTextField();
        projectBrowseButton = new javax.swing.JButton();
        makefileLabel = new javax.swing.JLabel();
        makefilePathTextField = new javax.swing.JTextField();
        makefileBrowseButton = new javax.swing.JButton();
        buildCommandTextField = new javax.swing.JTextField();
        buildLabel = new javax.swing.JLabel();
        cleanLabel = new javax.swing.JLabel();
        cleanCommandTextField = new javax.swing.JTextField();
        outputLabel = new javax.swing.JLabel();
        outputTextField = new javax.swing.JTextField();
        outputBrowseButton = new javax.swing.JButton();
        jScrollPane1 = new javax.swing.JScrollPane();
        jTextArea1 = new javax.swing.JTextArea();
        depthSpinner = new javax.swing.JSpinner();
        depthLabel = new javax.swing.JLabel();
        prefixLabel = new javax.swing.JLabel();
        prefixTextField = new javax.swing.JTextField();
        invokeDwarfDiscovery = new javax.swing.JCheckBox();

        setLayout(new java.awt.GridBagLayout());

        folderLabel.setLabelFor(projectFolderTextField);
        org.openide.awt.Mnemonics.setLocalizedText(folderLabel, "Specify a new project folder:"); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        add(folderLabel, gridBagConstraints);

        projectFolderTextField.addPropertyChangeListener(new java.beans.PropertyChangeListener() {
            public void propertyChange(java.beans.PropertyChangeEvent evt) {
                projectFolderTextFieldPropertyChange(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        add(projectFolderTextField, gridBagConstraints);

        org.openide.awt.Mnemonics.setLocalizedText(projectBrowseButton, "Browse"); // NOI18N
        projectBrowseButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                projectBrowseButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new java.awt.Insets(0, 10, 0, 0);
        add(projectBrowseButton, gridBagConstraints);

        makefileLabel.setLabelFor(makefilePathTextField);
        org.openide.awt.Mnemonics.setLocalizedText(makefileLabel, "Specify path to existing makefile:"); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        add(makefileLabel, gridBagConstraints);

        makefilePathTextField.addPropertyChangeListener(new java.beans.PropertyChangeListener() {
            public void propertyChange(java.beans.PropertyChangeEvent evt) {
                makefilePathTextFieldPropertyChange(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        add(makefilePathTextField, gridBagConstraints);

        org.openide.awt.Mnemonics.setLocalizedText(makefileBrowseButton, "Browse"); // NOI18N
        makefileBrowseButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                makefileBrowseButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.insets = new java.awt.Insets(0, 10, 0, 0);
        add(makefileBrowseButton, gridBagConstraints);

        buildCommandTextField.addPropertyChangeListener(new java.beans.PropertyChangeListener() {
            public void propertyChange(java.beans.PropertyChangeEvent evt) {
                buildCommandTextFieldPropertyChange(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        add(buildCommandTextField, gridBagConstraints);

        buildLabel.setLabelFor(buildCommandTextField);
        org.openide.awt.Mnemonics.setLocalizedText(buildLabel, "Specify build command:"); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        add(buildLabel, gridBagConstraints);

        cleanLabel.setLabelFor(cleanCommandTextField);
        org.openide.awt.Mnemonics.setLocalizedText(cleanLabel, "Specify clean command:"); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        add(cleanLabel, gridBagConstraints);

        cleanCommandTextField.addPropertyChangeListener(new java.beans.PropertyChangeListener() {
            public void propertyChange(java.beans.PropertyChangeEvent evt) {
                cleanCommandTextFieldPropertyChange(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        add(cleanCommandTextField, gridBagConstraints);

        outputLabel.setLabelFor(outputTextField);
        org.openide.awt.Mnemonics.setLocalizedText(outputLabel, "Specify build result:"); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        add(outputLabel, gridBagConstraints);

        outputTextField.addPropertyChangeListener(new java.beans.PropertyChangeListener() {
            public void propertyChange(java.beans.PropertyChangeEvent evt) {
                outputTextFieldPropertyChange(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        add(outputTextField, gridBagConstraints);

        org.openide.awt.Mnemonics.setLocalizedText(outputBrowseButton, "Browse"); // NOI18N
        outputBrowseButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                outputBrowseButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.insets = new java.awt.Insets(0, 10, 0, 0);
        add(outputBrowseButton, gridBagConstraints);

        jTextArea1.setEditable(false);
        jTextArea1.setFont(jTextArea1.getFont().deriveFont(jTextArea1.getFont().getSize()-1f));
        jTextArea1.setLineWrap(true);
        jTextArea1.setRows(5);
        jTextArea1.setText("Project Folder is the directory in which all the project files will be stored. Existing makefile is the main makefile of existing project that is to be converted into NetBeans project. The Build and Clean commands are commands that map the IDE's Build and Clean actions to shell commands. They could be executing an existing Makefile like \"make -f Makefile\" and \"make -f Makefile clean\". Build Result is the full path to the output of the Build Command and could be a path to an executable or library."); // NOI18N
        jTextArea1.setWrapStyleWord(true);
        jScrollPane1.setViewportView(jTextArea1);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 20;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(10, 0, 0, 0);
        add(jScrollPane1, gridBagConstraints);

        depthSpinner.addPropertyChangeListener(new java.beans.PropertyChangeListener() {
            public void propertyChange(java.beans.PropertyChangeEvent evt) {
                depthSpinnerPropertyChange(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 12;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 10, 0, 0);
        add(depthSpinner, gridBagConstraints);

        depthLabel.setLabelFor(depthSpinner);
        org.openide.awt.Mnemonics.setLocalizedText(depthLabel, "Maximal depth of subprojects nesting:"); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 12;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        add(depthLabel, gridBagConstraints);

        org.openide.awt.Mnemonics.setLocalizedText(prefixLabel, "Prefix for projects names:"); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 13;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        add(prefixLabel, gridBagConstraints);

        prefixTextField.addPropertyChangeListener(new java.beans.PropertyChangeListener() {
            public void propertyChange(java.beans.PropertyChangeEvent evt) {
                prefixTextFieldPropertyChange(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 14;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        add(prefixTextField, gridBagConstraints);

        org.openide.awt.Mnemonics.setLocalizedText(invokeDwarfDiscovery, "Invoke dwarf-based discovery"); // NOI18N
        invokeDwarfDiscovery.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                invokeDwarfDiscoveryActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 15;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        add(invokeDwarfDiscovery, gridBagConstraints);
    }// </editor-fold>//GEN-END:initComponents

    private void outputTextFieldPropertyChange(java.beans.PropertyChangeEvent evt) {//GEN-FIRST:event_outputTextFieldPropertyChange
        output = outputTextField.getText();
    }//GEN-LAST:event_outputTextFieldPropertyChange

    private void outputBrowseButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_outputBrowseButtonActionPerformed
        String seed = null;
        if (projectFolderTextField.getText().length() > 0) {
            seed = projectFolderTextField.getText();
        } else if (FileChooser.getCurrectChooserFile() != null) {
            seed = FileChooser.getCurrectChooserFile().getPath();
        } else {
            seed = System.getProperty("user.home"); // NOI18N
        }
        FileFilter all = new FileFilter() {

            public boolean accept(File f) {
                return true;
            }

            public String getDescription() {
                return "All files"; // NOI18N
            }
        };

        JFileChooser fileChooser = new FileChooser("Select Executable Path", "Select", JFileChooser.DIRECTORIES_ONLY, new FileFilter[]{all}, seed, false); // NOI18N
        int ret = fileChooser.showOpenDialog(this);
        if (ret == JFileChooser.CANCEL_OPTION) {
            return;
        }
        String path = fileChooser.getSelectedFile().getPath();
        path = FilePathAdaptor.normalize(path);
        outputTextField.setText(path);
        output = path;
    }//GEN-LAST:event_outputBrowseButtonActionPerformed

    private void cleanCommandTextFieldPropertyChange(java.beans.PropertyChangeEvent evt) {//GEN-FIRST:event_cleanCommandTextFieldPropertyChange
        cleanCommand = cleanCommandTextField.getText();
    }//GEN-LAST:event_cleanCommandTextFieldPropertyChange

    private void buildCommandTextFieldPropertyChange(java.beans.PropertyChangeEvent evt) {//GEN-FIRST:event_buildCommandTextFieldPropertyChange
        buildCommand = buildCommandTextField.getText();
    }//GEN-LAST:event_buildCommandTextFieldPropertyChange

    private void makefilePathTextFieldPropertyChange(java.beans.PropertyChangeEvent evt) {//GEN-FIRST:event_makefilePathTextFieldPropertyChange
        makefilePath = makefilePathTextField.getText();
    }//GEN-LAST:event_makefilePathTextFieldPropertyChange

    private void projectFolderTextFieldPropertyChange(java.beans.PropertyChangeEvent evt) {//GEN-FIRST:event_projectFolderTextFieldPropertyChange
        projectFolder = projectFolderTextField.getText();
    }//GEN-LAST:event_projectFolderTextFieldPropertyChange

    //define project folder
    private void projectBrowseButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_projectBrowseButtonActionPerformed
        String seed = null;
        if (projectFolderTextField.getText().length() > 0) {
            seed = projectFolderTextField.getText();
        } else if (FileChooser.getCurrectChooserFile() != null) {
            seed = FileChooser.getCurrectChooserFile().getPath();
        } else {
            seed = System.getProperty("user.home"); // NOI18N
        }
        FileFilter all = new FileFilter() {

            public boolean accept(File f) {
                return true;
            }

            public String getDescription() {
                return "All files"; // NOI18N
            }
        };

        JFileChooser fileChooser = new FileChooser("Select Project Folder", "Select", JFileChooser.DIRECTORIES_ONLY, new FileFilter[]{all}, seed, false); // NOI18N
        int ret = fileChooser.showOpenDialog(this);
        if (ret == JFileChooser.CANCEL_OPTION) {
            return;
        }
        String path = fileChooser.getSelectedFile().getPath();
        path = FilePathAdaptor.normalize(path);
        projectFolderTextField.setText(path);
        projectFolder = path;
    }//GEN-LAST:event_projectBrowseButtonActionPerformed

    //define makefile path
    private void makefileBrowseButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_makefileBrowseButtonActionPerformed
        String seed = null;
        if (makefilePathTextField.getText().length() > 0) {
            seed = makefilePathTextField.getText();
        } else if (FileChooser.getCurrectChooserFile() != null) {
            seed = FileChooser.getCurrectChooserFile().getPath();
        } else {
            seed = System.getProperty("user.home"); // NOI18N
        }
        JFileChooser fileChooser = new FileChooser("Select Makefile", "Select", JFileChooser.FILES_ONLY, new FileFilter[]{MakefileFileFilter.getInstance()}, seed, false); // NOI18N
        int ret = fileChooser.showOpenDialog(this);
        if (ret == JFileChooser.CANCEL_OPTION) {
            return;
        }
        String path = fileChooser.getSelectedFile().getPath();
        path = FilePathAdaptor.normalize(path);
        makefilePathTextField.setText(path);
        makefilePath = path;
        if (path != null) {
            File makefile = new File(path);
            makefilePath = makefile.getPath();
        }
        String makefileName = makefilePath.substring(makefilePath.lastIndexOf(File.separator) + 1, makefilePath.length());
        buildCommand += " -f " + makefileName; // NOI18N
        buildCommandTextField.setText(buildCommand);
        cleanCommand = DEFAULT_BUILD + " -f " + makefileName + " clean"; // NOI18N
        cleanCommandTextField.setText(cleanCommand);
    }//GEN-LAST:event_makefileBrowseButtonActionPerformed

    private void prefixTextFieldPropertyChange(java.beans.PropertyChangeEvent evt) {//GEN-FIRST:event_prefixTextFieldPropertyChange
        prefixName = prefixTextField.getText();
    }//GEN-LAST:event_prefixTextFieldPropertyChange

    private void depthSpinnerPropertyChange(java.beans.PropertyChangeEvent evt) {//GEN-FIRST:event_depthSpinnerPropertyChange
        depthLevel = ((Integer)depthSpinner.getValue()).intValue();
    }//GEN-LAST:event_depthSpinnerPropertyChange

private void invokeDwarfDiscoveryActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_invokeDwarfDiscoveryActionPerformed
    exploreDwarf = invokeDwarfDiscovery.isSelected();
}//GEN-LAST:event_invokeDwarfDiscoveryActionPerformed

    /**
     *
     * @return makefile path
     */
    public String getMakefilePath() {
        return makefilePath;
    }

    /**
     *
     * @return project folder
     */
    public String getProjectFolder() {
        return projectFolder;
    }

    /**
     *
     * @return project name
     */
    public String getProjectName() {
        return projectName;
    }

    public String getBuildCommand() {
        return buildCommand;
    }

    public String getCleanCommand() {
        return cleanCommand;
    }

    public String getOutput() {
        return output;
    }

    public String getPrefixName() {
        return prefixName;
    }

    public int getDepthLevel() {
        return depthLevel;
    }

    public boolean isInvokeDwarfProvider() {
        return exploreDwarf;
    }

    private String projectFolder;
    private String makefilePath;
    private String projectName;
    private String buildCommand;
    private String cleanCommand;
    private String output;
    private int depthLevel;
    private String prefixName;
    private boolean exploreDwarf;
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JTextField buildCommandTextField;
    private javax.swing.JLabel buildLabel;
    private javax.swing.JTextField cleanCommandTextField;
    private javax.swing.JLabel cleanLabel;
    private javax.swing.JLabel depthLabel;
    private javax.swing.JSpinner depthSpinner;
    private javax.swing.JLabel folderLabel;
    private javax.swing.JCheckBox invokeDwarfDiscovery;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JTextArea jTextArea1;
    private javax.swing.JButton makefileBrowseButton;
    private javax.swing.JLabel makefileLabel;
    private javax.swing.JTextField makefilePathTextField;
    private javax.swing.JButton outputBrowseButton;
    private javax.swing.JLabel outputLabel;
    private javax.swing.JTextField outputTextField;
    private javax.swing.JLabel prefixLabel;
    private javax.swing.JTextField prefixTextField;
    private javax.swing.JButton projectBrowseButton;
    private javax.swing.JTextField projectFolderTextField;
    // End of variables declaration//GEN-END:variables
}