/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */

/**
 *
 */
package org.netbeans.modules.bpel.model.api;

import org.netbeans.modules.bpel.model.api.events.VetoException;

/**
 * <p>
 * Java class for ServiceRefType complex type.
 * <p>
 * The following schema fragment specifies the expected content contained within
 * this class.
 *
 * <pre>
 *      &lt;xsd:element name="service-ref" type="sref:ServiceRefType">
 *              &lt;xsd:annotation>
 *                      &lt;xsd:documentation>
 *                              This element can be used within a from-spec.
 *                      &lt;/xsd:documentation>
 *              &lt;/xsd:annotation>
 *      &lt;/xsd:element>
 *      &lt;xsd:complexType name="ServiceRefType">
 *              &lt;xsd:annotation>
 *                      &lt;xsd:documentation>
 *                              This type definition is for service reference container.
 *                              This container is used as envelope to wrap around the actual endpoint reference value,
 *                              when a BPEL process interacts the endpoint reference of a partnerLink.
 *                              It provides pluggability of different versions of service referencing schemes
 *                              being used within a BPEL program. The design pattern here is similar to those of
 *                              expression language.
 *                      &lt;/xsd:documentation>
 *              &lt;/xsd:annotation>
 *              &lt;xsd:sequence>
 *                      &lt;xsd:any namespace="##other" processContents="lax"/>
 *              &lt;/xsd:sequence>
 *              &lt;xsd:attribute name="reference-scheme" type="xsd:anyURI"/>
 *      &lt;/xsd:complexType>
 * </pre>
 * 
 * @author ads
 */
public interface ServiceRef extends BpelContainer {
    
    String SERVICE_REF_NS   = 
        "http://docs.oasis-open.org/wsbpel/2.0/serviceref";     // NOI18N

    String REFERENCE_SCHEME = "reference-scheme";               // NOI18N
    
    /**
     * @return "reference-scheme" attribute value.
     */
    String getReferenceScheme();
    
    /**
     * Setter for "reference-scheme" attribute.
     * @param value New "reference-scheme" attribute value.
     * @throws VetoException {@link VetoException} will be thrown if <code>value</code>
     * is not acceptable here.
     */
    void setReferenceScheme( String value ) throws VetoException ;
    
    /**
     * Removes "reference-scheme" attribute.
     */
    void removeReferenceScheme();
}
