/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */

/**
 *
 */
package org.netbeans.modules.bpel.model.api.events;

import org.netbeans.modules.bpel.model.api.BpelEntity;

/**
 * @author ads
 */
public class PropertyUpdateEvent extends ChangeEvent {

    private static final long serialVersionUID = 6578752844551641594L;

    /**
     * Constructor for PropertyUpdateEvent with source ref.
     *
     * @param source
     *            source of event ( who produce this event ).
     * @param parent
     *            element in OM that contains event attribute.
     * @param name
     *            attribute name.
     * @param oldValue
     *            attribute old value.
     * @param newValue
     *            attribute new value.
     */
    public PropertyUpdateEvent( Object source, BpelEntity parent, String name,
            Object oldValue, Object newValue )
    {
        super(source, parent, name);
        myOldValue = oldValue;
        myNewValue = newValue;
    }

    /**
     * Constructor that don't have source reference.
     * 
     * @param parent
     *            element in OM, entity that contains attribute with value
     * @param name
     *            attribute name
     * @param oldValue
     *            old attribue value
     * @param newValue
     *            new attribue value
     */
    public PropertyUpdateEvent( BpelEntity parent, String name,
            Object oldValue, Object newValue )
    {
        this(Thread.currentThread(), parent, name, oldValue, newValue);
    }

    /**
     * @return old attribute value.
     */
    public Object getOldValue() {
        return myOldValue;
    }

    /**
     * @return new attribute value.
     */
    public Object getNewValue() {
        return myNewValue;
    }

    private Object myOldValue;

    private Object myNewValue;

}
