/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */

/**
 *
 */
package org.netbeans.modules.bpel.model.impl;

import java.util.List;
import java.util.Map;

import org.netbeans.modules.bpel.model.api.BpelEntity;
import org.netbeans.modules.bpel.model.api.events.ChangeEvent;
import org.netbeans.modules.bpel.model.api.events.EntityInsertEvent;
import org.netbeans.modules.bpel.model.api.events.EntityUpdateEvent;
import org.netbeans.modules.bpel.model.api.support.UniqueId;
import org.netbeans.modules.bpel.model.impl.events.BuildEvent;
import org.netbeans.modules.bpel.model.impl.events.CopyEvent;
import org.netbeans.modules.bpel.model.impl.events.CutEvent;
import org.netbeans.modules.bpel.model.impl.events.TreeCreatedEvent;
import org.netbeans.modules.bpel.model.impl.services.InnerEventDispatcherAdapter;


/**
 * This is unique id service. It created new ids for just created model, new ids
 * for copied element, set the same id references for cut entity.
 * 
 * @author ads
 */
public class UIDCreationService extends InnerEventDispatcherAdapter {


    /* (non-Javadoc)
     * @see org.netbeans.modules.soa.model.bpel20.xam.spi.InnerEventDispatcher#isApplicable(org.netbeans.modules.soa.model.bpel20.api.events.ChangeEvent)
     */
    public boolean isApplicable( ChangeEvent event ) {
        if ( event instanceof TreeCreatedEvent ){
            return true;
        }
        BpelEntity parent = event.getParent();
        if ( parent!=null ){
            // we need to generate id when model is syncing from source for added/inserted elements.
            return parent.getBpelModel().inSync() && ( 
                    event instanceof EntityInsertEvent || 
                    event instanceof EntityUpdateEvent );
        }
        return false;    
    }
    
    
    @Override
    public void preDispatch( ChangeEvent event )  {
        if ( event.getClass().equals( EntityInsertEvent.class)){
            createUid( null , 
                    (( EntityInsertEvent<? extends BpelEntity>)event).getValue(),
                    null);
        }
        if ( event.getClass().equals( EntityUpdateEvent.class)){
            createUid( null , 
                    (( EntityUpdateEvent<? extends BpelEntity>)event).getNewValue(),
                    null);
        }
    }


    /* (non-Javadoc)
     * @see org.netbeans.modules.soa.model.bpel20.xam.spi.InnerEventDispatcher#postDispatch(org.netbeans.modules.soa.model.bpel20.api.events.ChangeEvent)
     */
    public void postDispatch( ChangeEvent event ) {
        BpelEntity old = null;
        BpelEntity newEntity = null;
        Map map = null;
        if (event.getClass().equals(CutEvent.class)) {
            old = event.getParent();
            newEntity = ((CutEvent<? extends BpelEntity>) event)
                    .getOutOfModelEntity();
        }
        else if (event.getClass().equals(CopyEvent.class)) {
            old = event.getParent();
            newEntity = ((CopyEvent<? extends BpelEntity>) event)
                    .getOutOfModelEntity();
            map = (Map) newEntity.getCookie(BpelEntityImpl.IdMapKey.class);
        }
        else if (event.getClass().equals(TreeCreatedEvent.class)) {
            newEntity = event.getParent();
        }
        else if (event.getClass().equals(BuildEvent.class)) {
            newEntity = ((BuildEvent<? extends BpelEntity>) event).getParent();
        }
        else {
            return;
        }
        createUid(old, newEntity, map);
    }

    @SuppressWarnings("unchecked")
    private void createUid( BpelEntity old, BpelEntity newEntity, Map map ) {
        if ((old == null) || (map != null)) {
            if ( newEntity.getUID()!=null ){

                assert newEntity.getBpelModel().inSync();
                /* 
                 * if this is update from source then EntityUpdateEvent
                 * could be generated when regular element was deleted
                 * and its place was occupied by nonregular element.
                 * Such element already have ID. 
                 */ 
                return;
            }
            // this is the case when element just created via builder or
            // it is copied or event generated while syncing with source.

            BpelModelImpl modelImpl = (BpelModelImpl) newEntity.getBpelModel();
            long id = modelImpl.getNextID();
            UniqueIdImpl newId = new UniqueIdImpl((BpelEntityImpl) newEntity,
                    id);
            ((BpelEntityImpl) newEntity).setUID(newId);
            if (map != null) {// copy case.
                assert old != null;
                UniqueId uid = old.getUID();
                map.put(uid, newId);
            }
        }
        else {// this is "cut" case.
            UniqueId id = old.getUID();
            ((BpelEntityImpl) newEntity).setUID(id);
            (( UniqueIdImpl) id).setEntity( (BpelEntityImpl)newEntity );
        }
        BpelEntity component = (BpelEntity) newEntity;
        BpelEntity[] oldChildren = null;
        if (old != null) {
            List<? extends BpelEntity> list = ((BpelEntity) old)
                    .getChildren();
            oldChildren = list.toArray(new BpelEntity[list.size()]);
        }
        int i = 0;
        for (BpelEntity comp : component.getChildren()) {
            if (old != null) {
                assert oldChildren != null;
                createUid(oldChildren[i], comp, map);
            }
            else {
                createUid(null, comp, map);
            }
            
            i++;
        }
    }

}
