/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */

/**
 *
 */
package org.netbeans.modules.bpel.model.impl.references;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

import org.netbeans.modules.bpel.model.api.BpelModel;
import org.netbeans.modules.bpel.model.api.Import;
import org.netbeans.modules.bpel.model.api.support.ImportHelper;
import org.netbeans.modules.bpel.model.impl.Utils;
import org.netbeans.modules.bpel.model.xam.spi.ExternalModelRetriever;
import org.netbeans.modules.xml.schema.model.SchemaModel;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.netbeans.modules.xml.xam.Model;
import org.netbeans.modules.xml.xam.Model.State;
//import org.openide.filesystems.FileObject;


/**
 * @author ads
 *
 */
public class ExternalModelRetrieverImpl implements ExternalModelRetriever {


    /* (non-Javadoc)
     * @see org.netbeans.modules.bpel.model.xam.spi.ExternalModelRetriever#getWSDLModels(org.netbeans.modules.bpel.model.api.BpelModel, java.lang.String)
     */
    @SuppressWarnings("unchecked")
    public Collection<WSDLModel> getWSDLModels( BpelModel model,
            String namespace )
    {
        if ( namespace == null ) {
            return Collections.EMPTY_LIST;
        }
        List<WSDLModel> list = new LinkedList<WSDLModel>();
        collectWsdlModelsViaImports(model, namespace, list);

        //collectWsdlModelsViaFS(model, namespace, list);
        
        return list;

    }
    

    /* (non-Javadoc)
     * @see org.netbeans.modules.bpel.model.xam.spi.ExternalModelRetriever#getSchemaModels(org.netbeans.modules.bpel.model.api.BpelModel, java.lang.String)
     */
    @SuppressWarnings("unchecked")
    public Collection<SchemaModel> getSchemaModels( BpelModel model,
            String namespace )
    {
        if ( namespace == null ) {
            return Collections.EMPTY_LIST;
        }
        List<SchemaModel> list = new LinkedList<SchemaModel>();
        
        collectShemaModelsViaImports(model, namespace, list);
        //collectSchemaModelsViaFS(model, namespace, list);
        return list;

    }

    /*private void collectWsdlModelsViaFS( BpelModel model, String namespace, 
            List<WSDLModel> list ) 
    {
        FileObject[] files = Utils.getFilesByNamespace( model.getModelSource() , 
                namespace , DocumentTypesEnum.wsdl );
        for (FileObject file : files) {
            WSDLModel wsdlModel;
            try {
                ModelSource modelSource = Utilities.getModelSource( file , true );
                wsdlModel = WSDLModelFactory.getDefault().
                    getModel( modelSource );
            }
            catch (IOException e) {
                // The model that we trying to access is possibly broken.
                // SO we skip it in out list.
                wsdlModel = null;
            }
            
            if ( wsdlModel != null ){
                list.add( wsdlModel );
            }
        }
    }*/

    private void collectWsdlModelsViaImports( BpelModel model, String namespace, 
            List<WSDLModel> list ) 
    {
        Import[] imports = model.getProcess().getImports();
        for (Import imp : imports) {
            if ( namespace.equals(imp.getNamespace()) ){
                WSDLModel wsdlModel = ImportHelper.getWsdlModel(imp);
                if ( wsdlModel!= null && wsdlModel.getState() == Model.State.VALID ){
                    list.add( wsdlModel );
                }
            }
        }
    }


    /*private void collectSchemaModelsViaFS( BpelModel model, String namespace, 
            List<SchemaModel> list ) 
    {
        FileObject[] files = Utils.getFilesByNamespace( model.getModelSource() ,
                namespace , DocumentTypesEnum.schema );
        for (FileObject file : files) {
            SchemaModel schemaModel ;
            try {
                ModelSource modelSource = Utilities.getModelSource( file , true );
                schemaModel = SchemaModelFactory.getDefault().
                    getModel( modelSource );
            }
            catch (IOException e) {
                // The model that we trying to access is possibly broken.
                // SO we skip it in out list.
                schemaModel = null;
            }
            if ( schemaModel != null && model.getState() == Model.State.VALID){
                list.add( schemaModel );
            }
        }
    }*/

    private void collectShemaModelsViaImports( BpelModel model, String namespace, 
            List<SchemaModel> list ) 
    {
        Import[] imports = model.getProcess().getImports();
        for( Import imp : imports){
            if ( Import.WSDL_IMPORT_TYPE.equals( imp.getImportType()) ){
                // Fix for #78085
                Collection<SchemaModel> collection = ImportHelper.
                    getInlineSchema( imp, namespace );
                if ( collection!= null ){
                    list.addAll( collection );
                }
            }
            if ( !namespace.equals( imp.getNamespace() )){
                continue;
            }
            SchemaModel schemaModel = ImportHelper.getSchemaModel( imp );
            if ( schemaModel != null && schemaModel.getState() == State.VALID ){
                list.add( schemaModel );
            }
        }
    }

}
