/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */
package org.netbeans.modules.bpel.model.validation.imports;

import java.util.Collections;
import java.util.Set;

import org.netbeans.modules.bpel.model.api.BpelModel;
import org.netbeans.modules.bpel.model.api.Process;
import org.netbeans.modules.bpel.model.validation.AbstractValidator;
import org.netbeans.modules.bpel.model.validation.ValidationVisitor;
import org.netbeans.modules.xml.xam.Model;
import org.netbeans.modules.xml.xam.spi.Validation;
import org.netbeans.modules.xml.xam.spi.ValidationResult;
import org.netbeans.modules.xml.xam.spi.Validation.ValidationType;
/**
 * This validator invokes validation on imported WSDL and Schema models
 * if COMPLETE validation is requested.
 * @author Praveen Savur
 */
public class BPELImportsValidator extends AbstractValidator {
    private Validation validation;
    
    /**
     * Returns name of this validation service.
     */
    public String getName() {
        return getClass().getName();
    }
    
    /**
     * Overridden this method so that this can be invoked only for
     * PARTIAL validationType.
     */
    @Override
            public ValidationResult validate( Model model, Validation validation,
            ValidationType validationType) {

        
        if(!(model instanceof BpelModel)) {
            return EMPTY_RESULT;
        }
        final BpelModel bpelModel = (BpelModel) model;
        
        if ( bpelModel.getState() == Model.State.NOT_WELL_FORMED ){
            return EMPTY_RESULT;
        }
        
        if(validationType.equals(ValidationType.PARTIAL)) {
            return EMPTY_RESULT;
        }
        
        this.validation = validation;
        
        // Initialize our result object
        Set<ResultItem> results;
        Set<Model> models = Collections.singleton( model );
        
        final BPELImportsVisitor visitor = getVisitor();
        
        Runnable run = new Runnable() {
            public void run() {
                Process process = bpelModel.getProcess();
                if( process != null ) {
                    process.accept(visitor);
                }
            }
        };
        
        bpelModel.invoke(run);

        
        // Perform validation of imported models outside the bpelModel.invoke()
        visitor.validateImportedModels();
        
        results = visitor.getResultItems();
        if ( results == null ){
            results = Collections.EMPTY_SET;
        }
        
        //Fix for IZ86249 
        //Release reference to last vallidation, causing memory leaks
        this.validation = null;
        
        return new ValidationResult(results, models);
    }
    
    
    public BPELImportsVisitor getVisitor() {
        return new BPELImportsVisitor(this);
    }
    
    public Validation getValidation() {
        return validation;
    }
}
