/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */

package org.netbeans.modules.bpel.xpath.model.node.visitor;

import org.netbeans.modules.bpel.model.api.Activity;
import org.netbeans.modules.bpel.model.api.ActivityHolder;
import org.netbeans.modules.bpel.model.api.Assign;
import org.netbeans.modules.bpel.model.api.BooleanExpr;
import org.netbeans.modules.bpel.model.api.BpelContainer;
import org.netbeans.modules.bpel.model.api.BpelEntity;
import org.netbeans.modules.bpel.model.api.Branches;
import org.netbeans.modules.bpel.model.api.Catch;
import org.netbeans.modules.bpel.model.api.CatchAll;
import org.netbeans.modules.bpel.model.api.Compensate;
import org.netbeans.modules.bpel.model.api.CompensateScope;
import org.netbeans.modules.bpel.model.api.CompensationHandler;
import org.netbeans.modules.bpel.model.api.CompletionCondition;
import org.netbeans.modules.bpel.model.api.Condition;
import org.netbeans.modules.bpel.model.api.Copy;
import org.netbeans.modules.bpel.model.api.Correlation;
import org.netbeans.modules.bpel.model.api.CorrelationContainer;
import org.netbeans.modules.bpel.model.api.CorrelationSet;
import org.netbeans.modules.bpel.model.api.CorrelationSetContainer;
import org.netbeans.modules.bpel.model.api.DeadlineExpression;
import org.netbeans.modules.bpel.model.api.Documentation;
import org.netbeans.modules.bpel.model.api.Else;
import org.netbeans.modules.bpel.model.api.ElseIf;
import org.netbeans.modules.bpel.model.api.Empty;
import org.netbeans.modules.bpel.model.api.EventHandlers;
import org.netbeans.modules.bpel.model.api.Exit;
import org.netbeans.modules.bpel.model.api.ExtensibleAssign;
import org.netbeans.modules.bpel.model.api.Extension;
import org.netbeans.modules.bpel.model.api.ExtensionActivity;
import org.netbeans.modules.bpel.model.api.ExtensionContainer;
import org.netbeans.modules.bpel.model.api.ExtensionEntity;
import org.netbeans.modules.bpel.model.api.FaultHandlers;
import org.netbeans.modules.bpel.model.api.FinalCounterValue;
import org.netbeans.modules.bpel.model.api.Flow;
import org.netbeans.modules.bpel.model.api.For;
import org.netbeans.modules.bpel.model.api.ForEach;
import org.netbeans.modules.bpel.model.api.From;
import org.netbeans.modules.bpel.model.api.FromPart;
import org.netbeans.modules.bpel.model.api.FromPartContainer;
import org.netbeans.modules.bpel.model.api.If;
import org.netbeans.modules.bpel.model.api.Import;
import org.netbeans.modules.bpel.model.api.Invoke;
import org.netbeans.modules.bpel.model.api.Link;
import org.netbeans.modules.bpel.model.api.LinkContainer;
import org.netbeans.modules.bpel.model.api.Literal;
import org.netbeans.modules.bpel.model.api.MessageExchange;
import org.netbeans.modules.bpel.model.api.MessageExchangeContainer;
import org.netbeans.modules.bpel.model.api.OnAlarmEvent;
import org.netbeans.modules.bpel.model.api.OnAlarmPick;
import org.netbeans.modules.bpel.model.api.OnEvent;
import org.netbeans.modules.bpel.model.api.OnMessage;
import org.netbeans.modules.bpel.model.api.PartnerLink;
import org.netbeans.modules.bpel.model.api.PartnerLinkContainer;
import org.netbeans.modules.bpel.model.api.PatternedCorrelation;
import org.netbeans.modules.bpel.model.api.PatternedCorrelationContainer;
import org.netbeans.modules.bpel.model.api.Pick;
import org.netbeans.modules.bpel.model.api.Query;
import org.netbeans.modules.bpel.model.api.ReThrow;
import org.netbeans.modules.bpel.model.api.Receive;
import org.netbeans.modules.bpel.model.api.RepeatEvery;
import org.netbeans.modules.bpel.model.api.RepeatUntil;
import org.netbeans.modules.bpel.model.api.Reply;
import org.netbeans.modules.bpel.model.api.Scope;
import org.netbeans.modules.bpel.model.api.Sequence;
import org.netbeans.modules.bpel.model.api.ServiceRef;
import org.netbeans.modules.bpel.model.api.Source;
import org.netbeans.modules.bpel.model.api.SourceContainer;
import org.netbeans.modules.bpel.model.api.StartCounterValue;
import org.netbeans.modules.bpel.model.api.Target;
import org.netbeans.modules.bpel.model.api.TargetContainer;
import org.netbeans.modules.bpel.model.api.TerminationHandler;
import org.netbeans.modules.bpel.model.api.Throw;
import org.netbeans.modules.bpel.model.api.To;
import org.netbeans.modules.bpel.model.api.ToPart;
import org.netbeans.modules.bpel.model.api.ToPartContainer;
import org.netbeans.modules.bpel.model.api.Validate;
import org.netbeans.modules.bpel.model.api.Variable;
import org.netbeans.modules.bpel.model.api.VariableContainer;
import org.netbeans.modules.bpel.model.api.Wait;
import org.netbeans.modules.bpel.model.api.While;
import org.netbeans.modules.bpel.model.api.support.BpelModelVisitor;
import org.netbeans.modules.bpel.xpath.model.nodes.NodeFactory;
import org.netbeans.modules.bpel.xpath.model.nodes.TreeNode;
import org.netbeans.modules.bpel.model.api.Process;

/**
 *
 * @author jsandusky
 */
public class LocalVariableFinderVisitor implements BpelModelVisitor {
    
    private TreeNode mPreviousChild;
    
    
    public LocalVariableFinderVisitor() {
    }
    
    public TreeNode getLocalVariableNodes() {
        return mPreviousChild;
    }
    
    
    public void visit(Process process) {
        goToTopLevel(process);
    }    
    
    
    public void visit(Scope scope) {
        TreeNode node = (TreeNode) NodeFactory.getInstance().createNode(scope);
        if (node != null) {
            if (mPreviousChild != null) {
                node.addChild(mPreviousChild);
            }
            mPreviousChild = node;
        }
        
        goToTopLevel(scope);
    }

    
    public void visit(ForEach forEach) {
        TreeNode node = (TreeNode) NodeFactory.getInstance().createNode(forEach);
        if (node != null) {
            if (mPreviousChild != null) {
                node.addChild(mPreviousChild);
            }
            mPreviousChild = node;
        }

        goToTopLevel(forEach);
    }
    

    public void visit(Catch theCatch) {
        TreeNode node = (TreeNode) NodeFactory.getInstance().createNode(theCatch);
        if (node != null) {
            if (mPreviousChild != null) {
                node.addChild(mPreviousChild);
            }
            mPreviousChild = node;
        }

        goToTopLevel(theCatch);
    }
    
    
    public void visit(FaultHandlers handlers) {
        goToTopLevel(handlers);
    }

    
    public void visit(CatchAll catchAll) {
        goToTopLevel(catchAll);
    }
    
    
    public void visit(Activity activity) {
        goToTopLevel(activity);
    }
    

    public void visit(OnMessage message)  {
        goToTopLevel(message);
    }
    
    
    public void visit(CompensationHandler handler) {
        goToTopLevel(handler);
    }

    
    public void visit(Else els) {
        goToTopLevel(els);
    }
    

    public void visit(PatternedCorrelation correlation) {
        goToTopLevel(correlation);
    }
    

    public void visit(TerminationHandler handler) {
        goToTopLevel(handler);
    }
    

    public void visit(While whil) {
        goToTopLevel(whil);
    }

    
    public void visit(Exit terminate) {
        goToTopLevel(terminate);
    }

    
    public void visit(Receive receive) {
        goToTopLevel(receive);
    }
    

    public void visit(SourceContainer container) {
        goToTopLevel(container);
    }
    

    public void visit(PatternedCorrelationContainer container) {
        goToTopLevel(container);
    }

    
    public void visit(FinalCounterValue value) {
        goToTopLevel(value);
    }

    
    public void visit(Copy copy) {
        goToTopLevel(copy);
    }

    
    public void visit(RepeatEvery repeatEvery) {
        goToTopLevel(repeatEvery);
    }

    
    public void visit(ExtensionContainer container) {
        goToTopLevel(container);
    }

    
    public void visit(Empty empty) {
        goToTopLevel(empty);
    }
    

    public void visit(CompensateScope compensateScope) {
        goToTopLevel(compensateScope);
    }

    
    public void visit(Invoke invoke) {
        goToTopLevel(invoke);
    }

    
    public void visit(Import imp) {
        goToTopLevel(imp);
    }

    
    public void visit(FromPartContainer fromPartContainer) {
        goToTopLevel(fromPartContainer);
    }

    
    public void visit(Correlation correlation) {
        goToTopLevel(correlation);
    }

    
    public void visit(Target target) {
        goToTopLevel(target);
    }

    
    public void visit(Source source) {
        goToTopLevel(source);
    }
    

    public void visit(ServiceRef ref) {
        goToTopLevel(ref);
    }
    

    public void visit(CorrelationSet set) {
        goToTopLevel(set);
    }
    

    public void visit(ElseIf elseIf) {
        goToTopLevel(elseIf);
    }


    public void visit(Flow flow) {
        goToTopLevel(flow);
    }

    
    public void visit(Link link) {
        goToTopLevel(link);
    }
    

    public void visit(Throw throv) {
        goToTopLevel(throv);
    }

    
    public void visit(ToPartContainer toPartContainer) {
        goToTopLevel(toPartContainer);
    }

    
    public void visit(ReThrow rethrow) {
        goToTopLevel(rethrow);
    }

    
    public void visit(MessageExchangeContainer container) {
        goToTopLevel(container);
    }
    

    public void visit(RepeatUntil repeatUntil) {
        goToTopLevel(repeatUntil);
    }

    
    public void visit(OnEvent event) {
        goToTopLevel(event);
    }

    
    public void visit(ToPart toPart) {
        goToTopLevel(toPart);
    }

    
    public void visit(Wait wait) {
        goToTopLevel(wait);
    }

    
    public void visit(OnAlarmEvent alarmEvent) {
        goToTopLevel(alarmEvent);
    }

    
    public void visit(MessageExchange exchange) {
        goToTopLevel(exchange);
    }

    
    public void visit(TargetContainer container) {
        goToTopLevel(container);
    }


    public void visit(Query query) {
        goToTopLevel(query);
    }

    
    public void visit(FromPart fromPart) {
        goToTopLevel(fromPart);
    }

    
    public void visit(Validate validate) {
        goToTopLevel(validate);
    }

    
    public void visit(Documentation documentation) {
        goToTopLevel(documentation);
    }
    

    public void visit(CorrelationSetContainer container) {
        goToTopLevel(container);
    }


    public void visit(StartCounterValue value) {
        goToTopLevel(value);
    }


    public void visit(OnAlarmPick alarmPick) {
        goToTopLevel(alarmPick);
    }

    
    public void visit(Branches branches) {
        goToTopLevel(branches);
    }

    
    public void visit(For fo) {
        goToTopLevel(fo);
    }
    

    public void visit(If iff) {
        goToTopLevel(iff);
    }

    
    public void visit(ExtensionEntity entity) {
        goToTopLevel(entity);
    }

    
    public void visit(ExtensibleAssign assign) {
        goToTopLevel(assign);
    }
    

    public void visit(To to) {
        goToTopLevel(to);
    }

    
    public void visit(From from) {
        goToTopLevel(from);
    }

    
    public void visit(Compensate compensate) {
        goToTopLevel(compensate);
    }


    public void visit(DeadlineExpression expression) {
        goToTopLevel(expression);
    }

    
    public void visit(BooleanExpr expr) {
        goToTopLevel(expr);
    }

    
    public void visit(Sequence sequence) {
        goToTopLevel(sequence);
    }

    
    public void visit(Variable variable) {
        goToTopLevel(variable);
    }
    

    public void visit(EventHandlers handlers) {
        goToTopLevel(handlers);
    }

    
    public void visit(ExtensionActivity activity) {
        goToTopLevel(activity);
    }
    

    public void visit(Reply reply) {
        goToTopLevel(reply);
    }

    
    public void visit(Condition condition) {
        goToTopLevel(condition);
    }

    
    public void visit(LinkContainer container) {
        goToTopLevel(container);
    }

    
    public void visit(VariableContainer container) {
        goToTopLevel(container);
    }
    

    public void visit(Pick pick) {
        goToTopLevel(pick);
    }

    
    public void visit(CorrelationContainer container) {
        goToTopLevel(container);
    }

    
    public void visit(Extension extension) {
        goToTopLevel(extension);
    }
    

    public void visit(PartnerLink link) {
        goToTopLevel(link);
    }

    
    public void visit(Assign assign) {
        goToTopLevel(assign);
    }

    
    public void visit(CompletionCondition condition) {
        goToTopLevel(condition);
    }
    

    public void visit(PartnerLinkContainer container) {
        goToTopLevel(container);
    }

    
    public void visit(Literal literal) {
        goToTopLevel(literal);
    }
    
    
    private void goToTopLevel(BpelEntity entity) {
        BpelContainer parent = entity.getParent();
        if (parent != null) {
            parent.accept(this);
        }
    }
}
