/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */

package org.netbeans.modules.bpel.xpath.model.xsd.visitor;

import org.netbeans.modules.xml.schema.model.AttributeReference;
import org.netbeans.modules.xml.schema.model.ElementReference;
import org.netbeans.modules.xml.schema.model.GlobalAttribute;
import org.netbeans.modules.xml.schema.model.GlobalElement;
import org.netbeans.modules.xml.schema.model.GlobalSimpleType;
import org.netbeans.modules.xml.schema.model.GlobalType;
import org.netbeans.modules.xml.schema.model.LocalAttribute;
import org.netbeans.modules.xml.schema.model.LocalElement;
import org.netbeans.modules.xml.schema.model.LocalSimpleType;
import org.netbeans.modules.xml.schema.model.LocalType;
import org.netbeans.modules.xml.schema.model.SimpleTypeDefinition;
import org.netbeans.modules.xml.schema.model.SimpleTypeRestriction;
import org.netbeans.modules.xml.schema.model.TypeContainer;
import org.netbeans.modules.xml.xam.dom.NamedComponentReference;
import org.openide.util.NbBundle;

/**
 *
 * @author radval
 *
 */
public class XSDToolTipTextGeneratorVisitor extends AbstractXSDVisitor {
    
    private StringBuffer mToolTipTextBuffer = new StringBuffer(20);
    
    public String getToolTipText() {
        return this.mToolTipTextBuffer.toString();
    }
    
    public void visit(ElementReference er) {
        NamedComponentReference<GlobalElement> geRef = er.getRef();
        if (geRef != null && geRef.get() != null) {
            visit(geRef.get());
        }
    }
    
    public void visit(GlobalElement ge) {
        visitTypeContainer(ge);
        
    }
    
    
    public void visit(LocalElement le) {
        visitTypeContainer(le);
        
    }
    
    private void visitTypeContainer(TypeContainer tc) {
        String elementType = null;
        if (tc.getType() != null) {
            GlobalType gt = tc.getType().get();
            if (gt != null) {
                elementType = gt.getName();
                if (!elementType.trim().equals("")) {
                    this.mToolTipTextBuffer.append(
                            NbBundle.getMessage(XSDToolTipTextGeneratorVisitor.class,
                                "STR_ELEMENT_IS_OF_TYPE_X",     // NOI18N
                                elementType));
                }
            }
            
        } else  {
            LocalType lt = tc.getInlineType();
            if (lt != null) {
                this.mToolTipTextBuffer.append(
                        NbBundle.getMessage(XSDToolTipTextGeneratorVisitor.class,
                            "STR_ELEMENT_HAS_INLINE_TYPE"));    // NOI18N
            }
        }
    }
    
    public void visit(GlobalAttribute ga) {
        String attributeTypeName = null;
        NamedComponentReference<GlobalSimpleType> gstRef = ga.getType();
        GlobalSimpleType gst = null;
        if (gstRef != null) {
            gst = gstRef.get();
            if (gst != null) {
                attributeTypeName = findTypeName(gst);
            }
        } else {
            //TODO: temp till getInline is fixed and does not throw NPE
            try {
                LocalSimpleType lst = ga.getInlineType();
                attributeTypeName = findTypeName(lst);
            } catch(Exception ex) {
                
            }
            
        }
        
        
        
        if (attributeTypeName != null) {
            mToolTipTextBuffer.append(
                    NbBundle.getMessage(XSDToolTipTextGeneratorVisitor.class,
                        "STR_ATTRIBUTE_IS_OF_TYPE_X",   // NOI18N
                        attributeTypeName));
        }
    }
    
    public void visit(LocalAttribute la) {
        String attributeTypeName = null;
        NamedComponentReference<GlobalSimpleType> gstRef = la.getType();
        GlobalSimpleType gst = null;
        LocalSimpleType lst = null;
        
        
        if (gstRef != null) {
            gst = gstRef.get();
            if (gst != null) {
                attributeTypeName = findTypeName(gst);
            }
        } else {
            //TODO: temp till getInline is fixed and does not throw NPE
            try {
                lst = la.getInlineType();
                attributeTypeName = findTypeName(lst);
            } catch(Exception ex) {
                
            }
        }
        
        if (attributeTypeName != null) {
            mToolTipTextBuffer.append(
                    NbBundle.getMessage(XSDToolTipTextGeneratorVisitor.class,
                        "STR_ATTRIBUTE_IS_OF_TYPE_X",   // NOI18N
                        attributeTypeName));
        }
    }
    
    public void visit(AttributeReference reference) {
        NamedComponentReference<GlobalAttribute> gaRef = reference.getRef();
        if (gaRef != null && gaRef.get() != null) {
            visit(gaRef.get());
        }
    }
    
    
    private String findTypeName(SimpleTypeDefinition std) {
        if (std != null && std instanceof SimpleTypeRestriction) {
            SimpleTypeRestriction str = (SimpleTypeRestriction) std;
            NamedComponentReference<GlobalSimpleType> gst = str.getBase();
            
            return findTypeName(gst.get());
        }
        
        return null;
    }
    
    private String findTypeName(GlobalSimpleType gst) {
        String typeName = null;
        if (gst != null) {
            if (gst.getName()!= null) {
                typeName = gst.getName();
            } else {
                SimpleTypeDefinition std = gst.getDefinition();
                typeName = findTypeName(std);
            }
        }
        
        return typeName;
    }
    
    private String findTypeName(LocalSimpleType lst) {
        String typeName = null;
        if (lst != null) {
            SimpleTypeDefinition std = lst.getDefinition();
            typeName = findTypeName(std);
        }
        
        return typeName;
    }
    
    private String findTypeName(GlobalType gt) {
        if (gt != null) {
            return gt.getName();
        }
        
        return null;
    }
}

