/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */

package org.netbeans.modules.bpel.xpath.view;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.netbeans.modules.bpel.model.api.BpelEntity;
import org.netbeans.modules.bpel.model.api.BpelModel;

import org.netbeans.modules.soa.mapper.common.basicmapper.IBasicMapper;
import org.netbeans.modules.soa.mapper.common.basicmapper.methoid.IFieldNode;
import org.netbeans.modules.soa.mapper.common.basicmapper.tree.IMapperTreeNode;
import org.netbeans.modules.soa.mapper.common.IMapperLink;
import org.netbeans.modules.soa.mapper.common.IMapperNode;
import java.util.logging.Logger;
import org.netbeans.modules.bpel.xpath.model.nodes.CanvasNode;

import org.netbeans.modules.bpel.xpath.model.nodes.Node;
import org.netbeans.modules.bpel.xpath.model.nodes.NodeHelper;
import org.netbeans.modules.bpel.xpath.view.expression.impl.MapperUtil;
import org.netbeans.modules.bpel.xpath.view.output.ResultWindow;

/**
 *
 * @author radval
 *
 */
public abstract class AbstractXPathExpressionUpdater {
    
    protected Logger LOGGER = Logger.getLogger(AbstractXPathExpressionUpdater.class.getName());
    private IBasicMapper mMapper;
    
    private BpelModel mModel;
    private BpelEntity mHoldingEntity;
    
    
    public AbstractXPathExpressionUpdater(IBasicMapper mapper, BpelEntity holdingEntity) {
        this.mMapper = mapper;
        this.mHoldingEntity = holdingEntity;
        this.mModel = holdingEntity.getBpelModel();
    }
    
    public BpelEntity getBPELElement() {
        return this.mHoldingEntity;
    }
    public BpelModel getBPELDocument() {
        return this.mModel;
    }
    
    /**
     * This method is called when a link is updated which is not
     * a direct link to target tree node.
     *
     * Ex: ST-->OP1-->OP2-->TT
     * if link deleted is OP1-->OP2
     * then links passes to this method is OP2-->TT
     * Implementator of this method should update the xpath expression
     * of the object stored in the link.
     *
     * @param links
     */
    public abstract void handleLinkUpdateToNonTargetTreeNode(List links);
    
    /**
     * This method is called when a link is deleted which is a direct link
     * to target tree node.
     *
     * Ex:
     * ST-->OP1-->OP2-->TT
     *
     * if link is deleted is OP2-->TT
     * then links passed to this method is OP2-->TT.
     * Implementator of this method should deleted the link
     * object which is stored in the link.
     * @param links
     */
    public abstract void handleLinkRemovalFromTargetTreeNode(List links);
    
    /**
     * This method is called when a operator node is updated
     * which is not directly connected to target tree node.
     * ST-->OP1-->OP2-->TT
     * if node OP1 is deleted
     * then links passed to this method is OP2-TT.
     * Implementator of this method should update the xpath expression
     * of the object stored in the link.
     * @param links
     */
    public abstract void handleNodeUpdateNotConnectedToTargetTreeNode(List links);
    
    
    public void updateMapping(
            final IMapperNode srcNode,
            final IMapperNode destNode,
            final IMapperLink link,
            boolean isRemove) {
        
        Node sourceNode = null;
        Node targetNode = null;
        List affectedLinksToTargetTreeNodes = new ArrayList();
        List affectedLinksToNonTargetTreeNodes = new ArrayList();
        
        if (
                srcNode instanceof IMapperTreeNode && 
                destNode instanceof IMapperTreeNode) {
            IMapperTreeNode sMapperTreeNode = (IMapperTreeNode) srcNode;
            IMapperTreeNode tMapperTreeNode = (IMapperTreeNode) destNode;
            sourceNode = (Node) sMapperTreeNode.getPath().getLastPathComponent();
            targetNode = (Node) tMapperTreeNode.getPath().getLastPathComponent();
            affectedLinksToTargetTreeNodes.add(link);
            
        } else if (
                srcNode instanceof IFieldNode && 
                destNode instanceof IMapperTreeNode) {
            
            IMapperTreeNode tMapperTreeNode = (IMapperTreeNode) destNode;
            
            sourceNode = MapperUtil.getMapperNodeObject(srcNode);
            targetNode = (Node) tMapperTreeNode.getPath().getLastPathComponent();
            affectedLinksToTargetTreeNodes.add(link);
            
        } else if (
                srcNode instanceof IMapperTreeNode && 
                destNode instanceof IFieldNode) {
            
            IMapperTreeNode sMapperTreeNode = (IMapperTreeNode) srcNode;
            
            sourceNode = (Node) sMapperTreeNode.getPath().getLastPathComponent();
            targetNode = MapperUtil.getMapperNodeObject(destNode);
            affectedLinksToNonTargetTreeNodes = NodeHelper.findSubsequentLinksToTargetTree(sourceNode, this.mMapper.getMapperModel().getSelectedViewModel());
            
        } else if (
                srcNode instanceof IFieldNode && 
                destNode instanceof IFieldNode) {
            
            sourceNode = MapperUtil.getMapperNodeObject(srcNode);
            targetNode = MapperUtil.getMapperNodeObject(destNode);
            affectedLinksToNonTargetTreeNodes = NodeHelper.findSubsequentLinksToTargetTree(sourceNode, this.mMapper.getMapperModel().getSelectedViewModel());
            
        }
        
        if (isRemove && sourceNode != null && targetNode != null) {
            if (sourceNode instanceof CanvasNode) {
                ((CanvasNode) sourceNode).removeOutput(targetNode);
            }
            if (targetNode instanceof CanvasNode) {
                ((CanvasNode) targetNode).removeInput(sourceNode);
            }
        }
        
        setSynchronizationListenerEnable(false);
        if (affectedLinksToNonTargetTreeNodes != null) {
            handleLinkUpdateToNonTargetTreeNode(affectedLinksToNonTargetTreeNodes);
        }
        if (isRemove && affectedLinksToTargetTreeNodes != null) {
            handleLinkRemovalFromTargetTreeNode(affectedLinksToTargetTreeNodes);
        }
        setSynchronizationListenerEnable(true);
    }
    
    public void updateMapperNode(IMapperNode mapperNode, boolean isRemove) {
        Node node = (Node) mapperNode.getNodeObject();
        if (node != null) {
            //find direct links to target tree node
            List directLinksToTargetTreeNode = NodeHelper.findDirectLinksToTargetTree(node, this.mMapper.getMapperModel().getSelectedViewModel());
            
            //find indirect links to target tree nodes
            //first find out if there are any links to target
            //tree node where this node is also part of the chain on inputs
            //if so we need to update the link object xpath expression
            List indirectLinksToTargetTreeNode = NodeHelper.findSubsequentLinksToTargetTree(node, this.mMapper.getMapperModel().getSelectedViewModel());
            
            if (isRemove) {
                //remove this node from all nodes which are connected to this node
                if (node instanceof CanvasNode) {
                    List inputs = ((CanvasNode) node).getInputs();
                    Iterator it = inputs.iterator();
                    while (it.hasNext()) {
                        Node input = (Node) it.next();
                        if (input instanceof CanvasNode) {
                            ((CanvasNode) input).removeOutput(node);
                        }
                    }
                }

                //remove this node from all nodes this node is connected as input
                if (node instanceof CanvasNode) {
                    List outputs = ((CanvasNode) node).getOutputs();
                    Iterator it = outputs.iterator();
                    while(it.hasNext()) {
                        Node output = (Node) it.next();
                        if (output instanceof CanvasNode) {
                            ((CanvasNode) output).removeInput(node);
                        }
                    }
                }
            }
            
            setSynchronizationListenerEnable(false);
            //now update xpath expression of the
            //object held in  indirect
            //links to target tree node
            handleNodeUpdateNotConnectedToTargetTreeNode(indirectLinksToTargetTreeNode);
            if (isRemove) {
                //now remove the object held in direct links
                //to target tree node
                handleLinkRemovalFromTargetTreeNode(directLinksToTargetTreeNode);
            }
            setSynchronizationListenerEnable(true);
        }
    }
    
    private void setSynchronizationListenerEnable(boolean isEnabled) {
        ResultWindow.getInstance().setSynchronizationListenerEnable(isEnabled);
    }
    
    protected IBasicMapper getMapper() {
        return mMapper;
    }
    
}
