/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */

package org.netbeans.modules.bpel.xpath.view.expression;

import java.awt.BorderLayout;

import javax.swing.JPanel;
import org.netbeans.modules.bpel.model.api.BpelEntity;

import org.netbeans.modules.bpel.model.api.BpelModel;
import org.netbeans.modules.bpel.model.api.VariableContainer;
import org.netbeans.modules.bpel.xpath.model.nodes.impl.VariablesRootNodeImpl;
import org.netbeans.modules.bpel.xpath.view.expression.impl.MapperView;
import org.netbeans.modules.bpel.xpath.view.model.tree.BusinessProcessTreeModel;

/**
 *
 * @author radval
 *
 */
public abstract class AbstractMapperView extends JPanel {

    protected MapperView mMapper;
    private BpelModel mDocument;
    protected VariablesRootNodeImpl mVariablesRootNode;


    public AbstractMapperView(BpelModel document) {
        this(document, null);
    }
    
    public AbstractMapperView(BpelModel document, BpelEntity element) {
        this.mDocument = document;
        this.mMapper = (element != null) ? createMapper(element)
                                         : createMapper();
        initGUI();
    }
    
    protected abstract MapperView createMapper();
    
    /** Override the method with an appropriate one.
     *  @param  element     BPEL element associated with Mapper.
     *  @since  5.5
     */
    protected MapperView createMapper(BpelEntity element) {
        return null;
    }
    
    private void initGUI() {
        this.setLayout(new BorderLayout());
        this.add(BorderLayout.CENTER, this.mMapper);
    }
    
    public BpelModel getBPELDocument() {
        return this.mDocument;
    }
    
    public MapperView getMapper() {
        return this.mMapper;
    }
    
    protected void setBpelModel(BpelModel document) {
        mDocument = document;
    }
    
        
    protected void initializeTreeModels(
            MapperView mapper,
            BusinessProcessTreeModel sourceModel, 
            BusinessProcessTreeModel destModel,
            boolean isVariablesDestinationTree)
    {
        if (sourceModel != null) {
            mapper.initializePredicates(sourceModel);
        }
        if (destModel != null) {
            mapper.initializePredicates(destModel);
        }
        
        VariableContainer globalVars = getBPELDocument().getProcess().getVariableContainer();
        mVariablesRootNode = new VariablesRootNodeImpl(getBPELDocument().getProcess(), globalVars);
        
        sourceModel.setRoot(mVariablesRootNode);
        mapper.getMapperViewManager().getSourceView().getTree().setModel(sourceModel);
        mapper.getMapperViewManager().getSourceView().getTree().setRootVisible(false);
        mapper.getMapperViewManager().getSourceView().getTree().setShowsRootHandles(true);
        mapper.getMapperViewManager().getSourceView().getTree().expandRow(0);
        
        if (isVariablesDestinationTree) {
            destModel.setRoot(mVariablesRootNode);
            mapper.getMapperViewManager().getDestView().getTree().setModel(destModel);
            mapper.getMapperViewManager().getDestView().getTree().setRootVisible(false);
            mapper.getMapperViewManager().getDestView().getTree().setShowsRootHandles(true);
            mapper.getMapperViewManager().getDestView().getTree().expandRow(0);
        } else {
            mapper.getMapperViewManager().getDestView().getTree().setModel(destModel);
        }
    }
}

