/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */

package org.netbeans.modules.bpel.xpath.view.expression.impl;

import java.awt.Container;
import java.awt.Frame;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.swing.JOptionPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.tree.TreePath;
import org.netbeans.modules.bpel.model.api.Assign;
import org.netbeans.modules.bpel.model.api.BpelEntity;

import org.netbeans.modules.bpel.xpath.model.node.visitor.NodeTreePathBuilderVisitor;
import org.netbeans.modules.bpel.xpath.model.node.visitor.NodeModelRemoverVisitor;
import org.netbeans.modules.bpel.xpath.model.nodes.Node;
import org.netbeans.modules.bpel.xpath.model.nodes.NodeFactory;
import org.netbeans.modules.bpel.xpath.model.nodes.TreeNode;
import org.netbeans.modules.bpel.xpath.model.nodes.XPathLocationStepNode;
import org.netbeans.modules.bpel.xpath.model.nodes.impl.XPathLocationStepNodeImpl;
import org.netbeans.modules.bpel.xpath.view.impl.PredicateXPathExpressionView;
import org.netbeans.modules.bpel.xpath.view.model.tree.BusinessProcessTreeModel;
import org.netbeans.modules.soa.mapper.basicmapper.util.MapperUtilities;
import org.netbeans.modules.soa.mapper.common.IMapperEvent;
import org.netbeans.modules.xml.xpath.LocationStep;
import org.openide.util.NbBundle;

/**
 * Predicates Manager
 *
 * @author Ravi Shankar
 */
public class PredicatesManager {
    
    public static final String PREDICATE_BEGIN = "[";   // NOI18N
    public static final String PREDICATE_END   = "]";   // NOI18N
    
    public static final char PREDICATE_BEGIN_CHAR = '[';
    public static final char PREDICATE_END_CHAR   = ']';

    private Map mActivitiesMap = null;
    private Map mPredicateMapperModels = new HashMap();
    
    private MapperView mBpelMapper;
    
    /**
     * @param view BPView
     */
    public PredicatesManager(MapperView bpelMapper) {
        this.mBpelMapper = bpelMapper;
    }

    
        /**
     * 
     * @param parentNode
     * @param predicates
     * @param tree
     * @param tPath
     */
    public TreeNode createAndAddNewPredicate(TreeNode parentNode, 
                                             TreeNode sourceNode,
                                             LocationStep step, 
                                             final JTree tree)
    {
    	NodeTreePathBuilderVisitor ntpBuilder = new NodeTreePathBuilderVisitor();
		parentNode.accept(ntpBuilder);
		TreePath treePath = ntpBuilder.getTreePath();
		
        final Enumeration e = tree.getExpandedDescendants(treePath);
        BusinessProcessTreeModel model = (BusinessProcessTreeModel) tree.getModel();
        XPathLocationStepNode locationStepNode = (XPathLocationStepNode) NodeFactory.getInstance().createNode(step);
        locationStepNode.setSourceOfLocationStepNode(sourceNode);
        int index = parentNode.getChildren().indexOf(sourceNode);
        parentNode.addChild(index+1, locationStepNode);
        
        model.fireTreeStructureChanged(treePath);
        SwingUtilities.invokeLater(new Runnable() {
            public void run() {
                while (e != null && e.hasMoreElements()) {
                    tree.expandPath((TreePath) e.nextElement());
                }
            }
        });
        
        return locationStepNode;
    }
    
    private void updateOtherTree(BpelMapper mapper, JTree tree, TreePath tPath) {
        BpelEntity entity = mapper.getSelectedElement();
        if (entity instanceof Assign) {
            JTree srcTree = mapper.getMapperViewManager().getSourceView().getTree();
            JTree destTree = mapper.getMapperViewManager().getDestView().getTree();
            if (tree == srcTree) {
                Enumeration e = destTree.getExpandedDescendants(tPath.getParentPath());
                if (destTree.getModel() instanceof BusinessProcessTreeModel) {
                    BusinessProcessTreeModel destModel =
                        (BusinessProcessTreeModel) destTree.getModel();
                    destModel.fireTreeStructureChanged(tPath.getParentPath());
                    while (e != null && e.hasMoreElements()) {
                       destTree.expandPath((TreePath) e.nextElement());
                    }
                }
            } else if (tree == destTree) {
                Enumeration e = srcTree.getExpandedDescendants(tPath.getParentPath());
                if (srcTree.getModel() instanceof BusinessProcessTreeModel) {
                    BusinessProcessTreeModel srcModel =
                        (BusinessProcessTreeModel) srcTree.getModel();
                    srcModel.fireTreeStructureChanged(tPath.getParentPath());
                    while (e != null && e.hasMoreElements()) {
                       srcTree.expandPath((TreePath) e.nextElement());
                    }
                }
            }
        }
    }
    
    /**
     * this method is called to create a new predicate
     * @param selectedNode selected predicate node
     * @param tree JTree
     * @param tPath tree path for the selected node
     */
    public void insertNewPredicateInTree(BpelMapper mapper, 
                                         Node selectedNode, 
                                         JTree tree, 
                                         TreePath tPath)
    {
        Frame owner = null;
        Container parent = mapper.getParent();
        while (parent != null) {
            if (parent instanceof Frame) {
                owner = (Frame) parent;
                break;
            }
            parent = parent.getParent();
        }
        
        PredicateXPathExpressionView view = new PredicateXPathExpressionView(
                null,
                mapper.getSelectedElement(), 
                mapper.getBPELDocument(),
                tree);
        PredicateMapperDialog dlg = new PredicateMapperDialog(owner, view, selectedNode);
        dlg.setVisible(true);
        
        LocationStep step = dlg.getLocationStep();
        if (step != null) {
            TreeNode sourceNode = (TreeNode) tPath.getLastPathComponent();
            TreeNode parentNode = sourceNode.getParent();
            
            XPathLocationStepNode stepTreeNode = new XPathLocationStepNodeImpl(step);
            stepTreeNode.setSourceOfLocationStepNode(sourceNode);
            
            int index = parentNode.getChildren().indexOf(sourceNode);
            parentNode.addChild(index + 1, stepTreeNode);
            
            BusinessProcessTreeModel model = (BusinessProcessTreeModel) tree.getModel();
            model.fireTreeStructureChanged(tPath.getParentPath());
            tree.expandPath(tPath.getParentPath());
            updateOtherTree(mapper, tree, tPath);
            
            TreePath newPath = tPath.getParentPath().pathByAddingChild(stepTreeNode);
            tree.scrollPathToVisible(newPath);
            tree.setSelectionPath(newPath);
        }
    }
    
    /**
     * this method is called to delete a predicate
     * @param mapper BpelMapper
     * @param selectedNode selected predicate node
     * @param tree JTree
     * @param tPath tree path for the selected node
     */
    public void deletePredicateFromTree(BpelMapper mapper, 
                                        Node selectedNode,
                                        JTree tree, 
                                        TreePath tPath) {
        if (JOptionPane.showConfirmDialog(
                mapper,
                NbBundle.getMessage(PredicatesManager.class, "STR_DELETE_PREDICATE_LINE1")  // NOI18N
                + "\n"  // NOI18N
                + NbBundle.getMessage(PredicatesManager.class, "STR_DELETE_PREDICATE_LINE2")    // NOI18N
                + "\n"  // NOI18N
                + NbBundle.getMessage(PredicatesManager.class, "STR_PREDICATE_CONTINUE"),   // NOI18N
                NbBundle.getMessage(PredicatesManager.class, "STR_DELETE_PREDICATE_TITLE"), // NOI18N
                JOptionPane.YES_NO_OPTION) == JOptionPane.YES_OPTION) {
            
            XPathLocationStepNode stepNode = (XPathLocationStepNode) selectedNode;
            NodeModelRemoverVisitor remover = 
                    new NodeModelRemoverVisitor(mapper.getBasicMapper());
            remover.visit(stepNode);
            
            TreeNode sourceNode = (TreeNode) tPath.getLastPathComponent();
            TreeNode parentNode = sourceNode.getParent();
            parentNode.removeChild(stepNode);

            BusinessProcessTreeModel model = (BusinessProcessTreeModel) tree.getModel();
            model.fireTreeStructureChanged(tPath.getParentPath());
            updateOtherTree(mapper, tree, tPath);
        }
    }
    
    /**
     * this method is called to edit a predicate expression
     * @param mapper BpelMapper
     * @param selectedNode selected predicate node
     * @param tree JTree
     * @param tPath tree path for the selected node
     */
    public void editPredicateInTree(BpelMapper mapper,
                                    Node selectedNode,
                                    JTree tree,
                                    TreePath tPath)
    {
        Frame owner = null;
        Container parent = mapper.getParent();
        while (parent != null) {
            if (parent instanceof Frame) {
                owner = (Frame) parent;
                break;
            }
            parent = parent.getParent();
        }
        
        XPathLocationStepNode stepNode = (XPathLocationStepNode) selectedNode;
        TreeNode originalNode = stepNode.getSourceOfLocationStepNode();
        PredicateXPathExpressionView view = new PredicateXPathExpressionView(
                stepNode,
                mapper.getSelectedElement(), 
                mapper.getBPELDocument(),
                tree);
        PredicateMapperDialog dlg = new PredicateMapperDialog(owner, view, originalNode);
        dlg.setVisible(true);
        
        LocationStep step = dlg.getLocationStep();
        if (step != null) {
            TreeNode sourceNode = (TreeNode) tPath.getLastPathComponent();
            TreeNode parentNode = sourceNode.getParent();
            
            stepNode.setLocationStep(step);
            
            BusinessProcessTreeModel model = (BusinessProcessTreeModel) tree.getModel();
            model.fireTreeStructureChanged(tPath.getParentPath());
            tree.expandPath(tPath.getParentPath());
            updateOtherTree(mapper, tree, tPath);
            
            mapper.getBasicMapper().getMapperViewManager().postMapperEvent(
                    MapperUtilities.getMapperEvent(
                        this,
                        stepNode.getMapperNode(),
                        IMapperEvent.REQ_UPDATE_NODE,
                        NbBundle.getMessage(PredicatesManager.class,
                            "STR_X_REQUESTING_UPDATE_NODE_Y",   // NOI18N
                            getClass().getName(),
                            stepNode.getMapperNode())));
        }
    }
    
    public static String[] extractPredicateExpressions(String wholeExpression) {
        List expressions = new ArrayList();
        StringBuffer currentExpression = new StringBuffer();
        char[] chars = wholeExpression.toCharArray();
        boolean hasStartMarker = false;
        for (int i=0; i < chars.length; i++) {
            char c = chars[i];
            if        (c == PredicatesManager.PREDICATE_BEGIN_CHAR) {
                currentExpression.delete(0, currentExpression.length());
                hasStartMarker = true;
            } else if (c == PredicatesManager.PREDICATE_END_CHAR) {
                if (hasStartMarker) {
                    expressions.add(currentExpression.toString());
                }
                hasStartMarker = false;
            } else {
                currentExpression.append(c);
            }
        }
        return (String[]) expressions.toArray(new String[expressions.size()]);
    }
}
