/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */

package org.netbeans.modules.bpel.xpath.view.impl;

import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import org.netbeans.modules.bpel.model.api.BpelModel;
import org.netbeans.modules.bpel.xpath.view.Renderer;
import org.netbeans.modules.bpel.xpath.view.expression.impl.MapperUtil;
import org.netbeans.modules.bpel.xpath.view.expression.impl.MapperView;

import org.netbeans.modules.soa.mapper.common.basicmapper.IBasicMapper;
import org.netbeans.modules.soa.mapper.common.IMapperLink;
import org.netbeans.modules.soa.mapper.common.IMapperNode;

/**
 *
 * @author radval
 *
 */
public abstract class AbstractRenderer implements Renderer {
    
    protected static final Logger LOGGER = Logger.getLogger(AbstractRenderer.class.getName());
    private MapperView mBpelMapper;
    
    
    public AbstractRenderer(MapperView bpelMapper) {
        this.mBpelMapper = bpelMapper;
    }
    
    public MapperView getBpelMapper() {
        return this.mBpelMapper;
    }
    
    public BpelModel getBPELDocument() {
        return this.mBpelMapper.getBPELDocument();
    }
    
    public IBasicMapper getMapper() {
        return this.mBpelMapper.getBasicMapper();
    }
    
    protected void addLink(IMapperNode source, IMapperNode target, Object linkObject) {
        if(source != null && target != null) {
            IMapperLink link = this.getMapper().createLink(source, target);
            if(link != null) {
                link.setLinkObject(linkObject);
                addLink(link);
            }
        }
    }

    /**
     * This is copy of addLink() method of BasicMapper except we don't need
     * fire the mapper event.
     *
     * So, if the mapper guys make any change to their method, we need keep on
     * sync
     */
    protected void addLink(IMapperLink link) {
        IBasicMapper mapper = getMapper();
        MapperUtil.createLinkWithoutMapperEvents(link, mapper);
    }
    
    protected void layout() {
        // do autolayout of the canvas nodes.
        SwingUtilities.invokeLater(new Runnable() {
            public void run() {
                getMapper().getMapperViewManager().getCanvasView().getAutoLayout().autoLayout();
            }
        });
    }
}
