/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */

package org.netbeans.modules.bpel.xpath.view.search;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.JTree;
import org.netbeans.modules.bpel.xpath.model.nodes.TreeNode;
import org.netbeans.modules.bpel.xpath.view.output.ResultWindow;
import org.netbeans.modules.xml.xam.Component;
import org.netbeans.modules.xml.xam.ui.search.Query;
import org.netbeans.modules.xml.xam.ui.search.SearchException;
import org.netbeans.modules.xml.xam.ui.search.SearchProvider;
import org.netbeans.modules.xml.xam.ui.search.WildcardStringMatcher;
import org.openide.util.NbBundle;

/**
 * Implements a SearchProvider that compares the value of the name attribute
 * with the query string, using a case-insensitive string comparison.
 *
 * @author Nathan Fiedler
 */
public class MapperSearchProvider implements SearchProvider {
    
    /** The last query submitted by the user, if any, lower-cased. */
    private String phrase;
    /** True if the phrase contains wildcards (e.g. * or ?). */
    private boolean wildcarded;
    /** List of matching components. */
    private List results;
    /** Provides the selected component, if needed. */
    private MapperCategory category;
    /** The compiled regular expression pattern, if provided. */
    private Pattern pattern;

    /**
     * Creates a new instance of ComponentNameSearchProvider.
     *
     * @param  model     model in which to perform search.
     * @param  category  provides the selected component.
     */
    public MapperSearchProvider(MapperCategory category) {
        this.category = category;
    }

    public String getDisplayName() {
        return NbBundle.getMessage(MapperSearchProvider.class,
                "LBL_SearchProvider_ComponentName");
    }

    public String getInputDescription() {
        return NbBundle.getMessage(MapperSearchProvider.class,
                "HELP_SearchProvider_ComponentName");
    }

    public String getShortDescription() {
        return NbBundle.getMessage(MapperSearchProvider.class,
                "HINT_SearchProvider_ComponentName");
    }

    public List<Object> search(Query query) throws SearchException {
        if (query.isRegularExpression()) {
            try {
                pattern = Pattern.compile(query.getQuery());
                phrase = null;
            } catch (PatternSyntaxException pse) {
                throw new SearchException(pse.getMessage(), pse);
            }
        } else {
            pattern = null;
            phrase = query.getQuery().toLowerCase();
            wildcarded = WildcardStringMatcher.containsWildcards(phrase);
        }
        
        List<Object> results = new ArrayList<Object>();
        NodeSearchVisitor visitor = new NodeSearchVisitor(
                phrase, 
                wildcarded, 
                pattern);
        MapperCategoryPane categoryPane = 
                ResultWindow.getInstance().
                getDesignContextChangeListener().
                getDesignContextChanger().
                getCategoryPane();
        
        // Only obtain search results from the source tree, because
        // even if we are also searching through the destination tree
        // both trees will be based off the same XAM Components in
        // the search result list.
        return getSearchResultsForTree(
                visitor, 
                categoryPane.getSourceFindTree(), 
                query);
    }
    
    private List<Object> getSearchResultsForTree(
            NodeSearchVisitor visitor,
            JTree tree,
            Query query)
    {
        TreeNode selectedNode = null;
        if (tree != null) {
            if (tree.getSelectionPath() != null) {
                selectedNode = (TreeNode) tree.getSelectionPath().getLastPathComponent();
            }
        }

        // Search for named components with the given name.
        if (query.useSelected() && selectedNode != null) {
            selectedNode.accept(visitor);
        } else if (tree != null) {
            ((TreeNode) tree.getModel().getRoot()).accept(visitor);
        }
        // XXX fixme
        List<Component> results = visitor.getResults();
        List<Object> ors = new ArrayList<Object>();
        ors.addAll(results);
        return ors;
    }
}
