/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */


package org.netbeans.modules.edm.editor.widgets.property.editor;

import java.beans.PropertyEditorSupport;

import org.openide.explorer.propertysheet.ExPropertyEditor;
import org.openide.explorer.propertysheet.PropertyEnv;
import org.openide.nodes.Node;
import org.openide.windows.WindowManager;

import org.netbeans.modules.edm.editor.widgets.property.JoinNode;
import org.netbeans.modules.edm.editor.widgets.property.TargetTableNode;
import org.netbeans.modules.sql.framework.model.SQLConstants;


/**
 *
 * @author Nithya
 */
public class StatementTypeCustomEditor extends PropertyEditorSupport implements
        ExPropertyEditor {   
    
    private TargetTableNode node;
    
    private PropertyEnv env;
    
    public StatementTypeCustomEditor() {
        initialize();
    }

    @Override 
    public String[] getTags() {
        String[] tags = {"Insert","Insert/Update",
        "Update","Delete"};
        return tags;
    }
    
    @Override
    public Object getValue(){        
        String type = "";
        if(node == null) {
            initialize();
        }
        
        int stmtType = node.getTargetTable().getStatementType();
        switch(stmtType) {
        case SQLConstants.INSERT_STATEMENT:
            type = "INSERT";
            break;
        case SQLConstants.INSERT_UPDATE_STATEMENT:
            type = "INSERT/UPDATE";
            break;
        case SQLConstants.UPDATE_STATEMENT:
            type = "UPDATE";
            break;
        case SQLConstants.DELETE_STATEMENT:            
            type = "DELETE";        
        }
        return type;
    }     
    
    @Override
    public String getAsText() {
        return (String)getValue();
    }
    
    @Override
    public void setValue(Object object) {
        String type = (String)object;
        if(type.equals("INSERT")) {
            node.getTargetTable().setStatementType(SQLConstants.INSERT_STATEMENT);
        } else if(type.equals("INSERT/UPDATE")) {
            node.getTargetTable().setStatementType(SQLConstants.INSERT_UPDATE_STATEMENT);
        } else if(type.equals("UPDATE")) {
            node.getTargetTable().setStatementType(SQLConstants.UPDATE_STATEMENT);
        } else if(type.equals("DELETE")) {
            node.getTargetTable().setStatementType(SQLConstants.DELETE_STATEMENT);
        }
        node.getMashupDataObject().getMashupDataEditorSupport().synchDocument();
    }
    
    @Override
    public void setAsText(String text) {
        if(node == null) {
            initialize();
        }
        setValue(text);
    }
    
    private void initialize() {
        Node[] nodes = WindowManager.getDefault().getRegistry().getActivatedNodes();
        for(Node node : nodes) {
            if(node instanceof TargetTableNode) {
                this.node = (TargetTableNode) node;
                break;
            }
        }
    }

    public void attachEnv(PropertyEnv env) {
        this.env = env;
    }
}