/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */
package org.netbeans.modules.etl.ui.property;

import org.netbeans.modules.etl.ui.ETLDataObject;
import org.netbeans.modules.sql.framework.model.RuntimeInput;
import org.openide.ErrorManager;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;


import org.netbeans.modules.sql.framework.model.SourceTable;



/**
 *
 * @author Nithya R
 */
public class RuntimeInputNode extends AbstractNode {
    
    private RuntimeInput runIn;
    
    private ETLDataObject mObj;
    
    public RuntimeInputNode(RuntimeInput obj) {
        super(Children.LEAF);
        runIn = (RuntimeInput) obj;
    }
    
    
    @Override
    public boolean canCopy() {
        return false;
    }
    
    @Override
    public boolean canRename() {
        return false;
    }
    
    @Override
    public boolean canCut() {
        return false;
    }
    
    @Override
    public boolean canDestroy() {
        return true;
    }
    
    /** Creates a property sheet. */
    protected Sheet createSheet() {
        Sheet sheet = Sheet.createDefault();
        Sheet.Set set = sheet.createPropertiesSet();
        Sheet.Set expset = sheet.createExpertSet();
        set.setDisplayName("Basic");
        set.setExpert(false);
        expset.setDisplayName("Expert");
        expset.setExpert(true);
        try {
            PropertySupport.Reflection nameProp = new PropertySupport.Reflection(this.runIn,
                    String.class, "getFullyQualifiedName", null);
            nameProp.setName("Table Name");
            nameProp.setShortDescription("RunTimeInput Name");
            set.put(nameProp);
            
            PropertySupport.Reflection databaseModelNameProp = new PropertySupport.Reflection(this.runIn.getParent(),
                    String.class, "getModelName", null);
            databaseModelNameProp.setName("Database Model Name");
            databaseModelNameProp.setShortDescription("RunTimeInput DatabaseModelName");
            set.put(databaseModelNameProp);
            
        } catch (Exception ex) {
            ErrorManager.getDefault().notify(ex);
        }
        sheet.put(set);
        sheet.put(expset);
        return sheet;
    }
    
    public RuntimeInput getRuntimeInput() {
        return this.runIn;
    }
    
    public ETLDataObject getETLDataObject() {
        return mObj;
    }
    
}