/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */


package org.netbeans.modules.etl.ui.property.editor;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyEditorSupport;
import org.netbeans.modules.etl.ui.DataObjectProvider;
import org.netbeans.modules.etl.ui.ETLDataObject;
import org.netbeans.modules.etl.ui.property.CollaborationGraphNode;
import org.openide.explorer.propertysheet.ExPropertyEditor;
import org.openide.explorer.propertysheet.PropertyEnv;
import org.openide.nodes.Node;
import org.openide.windows.WindowManager;
import org.netbeans.modules.sql.framework.model.SQLDefinition;

public class ExecutionStrategyTypeCustomEditor extends PropertyEditorSupport implements ExPropertyEditor {

    private CollaborationGraphNode node;
    private ETLDataObject mObj;
    private PropertyEnv env;
    private PropertyChangeSupport support;
    private Object oldValue = null;

    public ExecutionStrategyTypeCustomEditor() {
        initialize();
        support = new PropertyChangeSupport(this);
    }

    @Override
    public String[] getTags() {
        String[] tags = {"Pipeline", "Best Fit", "Staging"};
        return tags;
    }

    @Override
    public Object getValue() {
        String type = "";
        if (node == null) {
            initialize();
        }
        int extType = node.getETLDataObject().getModel().getETLDefinition().getExecutionStrategyCode();
        switch (extType) {
            case SQLDefinition.EXECUTION_STRATEGY_BEST_FIT:
                type = "Best Fit";
                break;
            case SQLDefinition.EXECUTION_STRATEGY_PIPELINE:
                type = "Pipeline";
                break;
            case SQLDefinition.EXECUTION_STRATEGY_STAGING:
                type = "Staging";
                break;
        }        
        this.oldValue = type;
        return type;
    }

    @Override
    public String getAsText() {
        return (String) getValue();
    }

    @Override
    public void setValue(Object object) {
        String type = (String) object;
        if (type.equals("Best Fit")) {
            node.getETLDataObject().getModel().getETLDefinition().setExecutionStrategyCode(SQLDefinition.EXECUTION_STRATEGY_BEST_FIT);
        } else if (type.equals("Pipeline")) {
            node.getETLDataObject().getModel().getETLDefinition().setExecutionStrategyCode(SQLDefinition.EXECUTION_STRATEGY_PIPELINE);
        } else if (type.equals("Staging")) {
            node.getETLDataObject().getModel().getETLDefinition().setExecutionStrategyCode(SQLDefinition.EXECUTION_STRATEGY_STAGING);
        }
        if ((this.oldValue).equals(type.trim())) {
            support.firePropertyChange("", null, null);
        } else {
            mObj.getETLEditorSupport().synchDocument();
        }
    }

    @Override
    public void setAsText(String text) {
        if (node == null) {
            initialize();
        }
        setValue(text);
    }

    private void initialize() {
        Node[] nodes = WindowManager.getDefault().getRegistry().getActivatedNodes();
        for (Node node : nodes) {
            if (node instanceof CollaborationGraphNode) {
                this.node = (CollaborationGraphNode) node;
                this.mObj = DataObjectProvider.getProvider().getActiveDataObject();
                break;
            }
        }
    }

    public void attachEnv(PropertyEnv env) {
        this.env = env;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {        
        support.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {        
        support.removePropertyChangeListener(listener);
    }
}