/*
 * The contents of this file are subject to the terms of the Common
 * Development and Distribution License (the License). You may not use this
 * file except in compliance with the License.  You can obtain a copy of the
 * License at http://www.netbeans.org/cddl.html
 
 * When distributing Covered Code, include this CDDL Header Notice in each
 * file and include the License. If applicable, add the following below the
 * CDDL Header, with the fields enclosed by brackets [] replaced by your own
 * identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 
 * Copyright 2006 Sun Microsystems, Inc. All Rights Reserved
 *
 */


package org.netbeans.modules.aspect.editor.graph;

import org.netbeans.modules.aspect.editor.graph.AdvicePopupProvider;
import java.awt.Image;
import java.util.Iterator;
import java.util.List;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;

import org.netbeans.api.visual.widget.Widget;
import org.openide.filesystems.FileUtil;
import org.openide.util.Utilities;
import org.netbeans.api.visual.action.ActionFactory;

import org.netbeans.modules.aspect.editor.dataobject.AspectDataObject;
import org.netbeans.modules.aspect.editor.jaxbmodel.AdviceType;
import org.netbeans.modules.aspect.editor.jaxbmodel.AspectType;
import org.netbeans.modules.aspect.editor.jaxbmodel.AspectmapType;
import org.netbeans.modules.aspect.editor.jaxbutils.AspectConstants;
import org.netbeans.modules.aspect.editor.jaxbmodel.ExchangeSimpleType;
import org.netbeans.modules.aspect.editor.jaxbmodel.InputType;
import org.netbeans.modules.aspect.editor.jaxbmodel.OutputType;
import org.netbeans.modules.aspect.editor.jaxbutils.Utiltools;
import org.netbeans.modules.aspect.editor.mapbuilder.AspectMapBuilder;
import org.netbeans.modules.aspect.editor.mapbuilder.AspectMapBuilder;
import org.netbeans.modules.aspect.editor.property.*;
import org.netbeans.modules.aspect.editor.widgets.AspectGraphScene;
import org.netbeans.modules.aspect.editor.widgets.AspectNodeWidget;
import org.netbeans.modules.aspect.editor.widgets.AspectPinWidget;
import org.openide.nodes.Node;
import org.openide.windows.WindowManager;

/**
 * DOCUMENT ME!
 *
 * To change the template for this generated type comment go to Window - Preferences
 *         - Java - Code Generation - Code and Comments
 *
 * @author tli
 *
 */
public class AspectEditorPane extends JComponent {
    
    private static final Image IMAGE_ITEM = Utilities.loadImage(
            "org/netbeans/modules/aspect/editor/resources/aspect.png"); // NOI18N
    private static final Image IMAGE_ITEM_PROVIDES = Utilities.loadImage(
            "org/netbeans/modules/aspect/editor/resources/provide16.png"); // NOI18N
    private static final Image IMAGE_ITEM_CONSUMES = Utilities.loadImage(
            "org/netbeans/modules/aspect/editor/resources/consume16.png"); // NOI18N
    private static final Image IMAGE_ITEM_PROPERTIES = Utilities.loadImage(
            "org/netbeans/modules/aspect/editor/resources/properties.png"); // NOI18N
    
    private static long nodeID = 1;
    private static long edgeID = 1;
    private static long pinID = 1;
    
    private AspectGraphScene scene;
    
    //private Aspect aspect;
    private AspectType aspect;
    
    //private Input input; JAXB
    private InputType input;
    
    //private Output output; JAXB
    private OutputType output;
    
    //private List<Output> outputs; JAXB
    private List<OutputType> outputs;
    
    //private List<Advice> advices; JAXB
    private List<AdviceType> advices;
    
    //private AspectMapModel model; JAXB
    private AspectmapType model;
    
    private AspectDataObject mObj;
    
    
    public enum Nodes {
        INPUT, OUTPUT, ADVICE
    }
    
    
    public AspectEditorPane(AspectDataObject dObj){
        super();
        mObj = dObj;
        
        // Initialize all data structures.
        objectMap = new HashMap<Widget, Object>();
        graphMap = new HashMap<Object, Widget>();
        outputMap = new HashMap<String, String>();
        //outputs = new ArrayList<Output>(); JAXB
        outputs = new ArrayList<OutputType>();
        scene = new AspectGraphScene(this.mObj);
        scene.getActions().addAction(ActionFactory.createZoomAction());
        scene.getActions().addAction(ActionFactory.createPanAction());
        scene.getActions().addAction(ActionFactory.createMoveAction());
        
        // parse Aspect map and generate graph.
        scene = parseAspectMap();
        
        // auto layout scene.
        scene.layoutScene();
        scene.getActions().addAction(ActionFactory.createAcceptAction(new SceneAcceptProvider(mObj, this)));
    }
    
    public JComponent getViewComponent() {
        return scene.createView();   // getView();
    }
    
    public void setAspect(String asp) {
        //Iterator it = model.getAspects().iterator(); JAXB
        Iterator it = getAspects().iterator();
        while(it.hasNext()) {
            AspectType aspElem = (AspectType)it.next();
            if(aspElem.getID().equals(asp)) {
                this.aspect = aspElem;
                break;
            }
        }
        refreshGraph(true, this.aspect);
    }
    
    //public Aspect getCurrentAspect() { JAXB
    public AspectType getCurrentAspect() {
        return this.aspect;
    }
    
    //public List<Aspect> getAspects() { JAXB
    public List<AspectType> getAspects() {
        //return model.getAspects(); JAXB
        return AspectMapBuilder.getAspectMapBuilder().getAspectList();
        
    }
    
    public void layoutGraph() {
        scene.layoutScene();
    }
    
    private String createNode(AspectGraphScene scene, Image image, Nodes node, String type, List<Image> glyphs, Object advicemodel) {
        String nodeID = "node" + this.nodeID ++;
        AspectNodeWidget widget = (AspectNodeWidget)scene.addNode(nodeID);
        StringBuffer tooltip = new StringBuffer();
        //Advice adv = (Advice)model; JAXB
        AdviceType adv = (AdviceType)advicemodel;
        //tooltip.append("Advice Type:" + adv.getType() +"\t OrderNo:" + adv.getOrderNo()); JAXB
        tooltip.append("Advice Type:" + adv.getType() +"\t OrderNo:" + adv.getOrder());
        widget.setNodeName(adv.getType());
        widget.setToolTipText(tooltip.toString());
        widget.getActions().addAction(scene.createWidgetHoverAction());
        List<Image> imageList = new ArrayList<Image>();
        imageList.add(image);
        widget.setGlyphs(imageList);
        graphMap.put(advicemodel, widget);
        objectMap.put(widget, advicemodel);
        scene.addPin(nodeID, nodeID + AspectGraphScene.PIN_ID_DEFAULT_SUFFIX);
        scene.validate();
        if (Byte.toString(adv.getOrder()).equals("1")) {
            setSelectedNode(widget);
        }
        return nodeID;
    }
    
    //public AspectMapModel getModel() { JAXB
    public AspectmapType getModel() {
        
        return this.model;
    }
    
    private void createPin(AspectGraphScene scene, String nodeID, String pinID,Image image, String name, String type, String tooltip, boolean popup, Object model) {
        AspectPinWidget pin = ((AspectPinWidget) scene.addPin(nodeID, pinID));
        List<Image> imageList = new ArrayList<Image>();
        imageList.add(image);
        pin.setProperties(name, imageList);
        pin.setToolTipText(tooltip);
        graphMap.put(pinID, pin);
        objectMap.put(pin, model);
        if(popup) {
            if(type.equalsIgnoreCase(AspectConstants.INPUT_ELEMENT)) {
                pin.getActions().addAction(ActionFactory.createPopupMenuAction(new InputPopupProvider(this)));
            } else if(type.equalsIgnoreCase(AspectConstants.ADVICE)) {
                pin.getActions().addAction(ActionFactory.createPopupMenuAction(new AdvicePopupProvider(this)));
            } else if(type.equalsIgnoreCase(AspectConstants.OUTPUT_ELEMENT)) {
                pin.getActions().addAction(ActionFactory.createPopupMenuAction(new OutputPopupProvider(this)));
            }
        }
        scene.validate();
    }
    
    private void createEdge(AspectGraphScene scene, String sourcePinID, String targetNodeID) {
        String edgeID = "edge" + this.edgeID ++;
        Widget widget = scene.addEdge(edgeID);
        scene.setEdgeSource(edgeID, sourcePinID + AspectGraphScene.PIN_ID_DEFAULT_SUFFIX);
        scene.setEdgeTarget(edgeID, targetNodeID + AspectGraphScene.PIN_ID_DEFAULT_SUFFIX);
        graphMap.put(edgeID, widget);
        objectMap.put(widget, edgeID);
        scene.validate();
    }
    
    private AspectGraphScene parseAspectMap(){
        //Unmarshall the existing aspect map
        //model = new AspectMapModel(FileUtil.toFile(mObj.getPrimaryFile())); JAXB
        
        AspectMapBuilder mBuilder = AspectMapBuilder.getAspectMapBuilder(FileUtil.toFile(mObj.getPrimaryFile()));
        this.model = mBuilder.unmarshallAspectMap();
        
        //java.util.List<Aspect> aspects = model.getAspects(); JAXB
        List<AspectType> aspects = getAspects();
        
        // generate graph only when some aspect is present.
        if(aspects.size() != 0) {
            //aspect = (Aspect)it.next(); JAXB
            Iterator it = aspects.iterator();
            while(it.hasNext()) {
                this.aspect = (AspectType)it.next();
                generateGraphForAspect(this.aspect, scene);
            }
        } else {
            //aspect = new Aspect(AspectMap.FILTER_REQUEST_REPLY_ELEMENT, "1"); //JAXB
            //model.addAspect(aspect); JAXB
            this.aspect = AspectMapBuilder.getAspectMapBuilder().addNewAspect(ExchangeSimpleType.FILTER_REQUEST_REPLY, "1");
            generateGraphForAspect(this.aspect, scene);
        }
        scene.getActions().addAction(ActionFactory.createPopupMenuAction(new ScenePopupProvider(this)));
        return scene;
    }
    
    //private void generateGraphForAspect(Aspect asp, final VMDGraphScene graph) {
    private void generateGraphForAspect(AspectType asp, final AspectGraphScene graph) {
        
        //advices = asp.getAdvices(); JAXB
        this.advices = AspectMapBuilder.getAspectMapBuilder().getAdviceList(asp);
        if (this.advices != null) {
            //advices = Util.getSortedAdviceList(advices); JAXB
            this.advices = Utiltools.getSortedAdviceList(advices);
            //asp.setAdvices(advices); JAXB - This May not be needed hence commented
            Iterator it = advices.iterator();
            String prevNodeID = null;
            String currentNodeID = null;
            AdviceType advice;
            while(it.hasNext()) {
                advice = (AdviceType)it.next();
                currentNodeID = createNode(graph, IMAGE_ITEM, Nodes.ADVICE, advice.getType(), null, advice);
                if(prevNodeID != null) {
                    createEdge(graph, prevNodeID , currentNodeID);
                } else {
                    createPin(scene, currentNodeID, "pin" + pinID++, IMAGE_ITEM_PROVIDES,
                            "", "Input", "Provides Endpoint", true, input);
                }
                createPin(scene, currentNodeID, "pin" + pinID++, IMAGE_ITEM_PROPERTIES,
                        "Properties", "Advice", "Properties", true, advice);
                prevNodeID = currentNodeID;
            }
            
            // if there is some advice, do this.
            
            if(advices.size() != 0) {
                // get the last advice.
                //Advice adv = (Advice)advices.get(advices.size() - 1); JAXB
                
                /*
                //THIS WILL BE USED WHEN RULESETS are INtroduced for Outputs
                AdviceType adv = (AdviceType)advices.get(advices.size() - 1); JAXB
                List<String> outputIds = adv.getPropertiesModel().getRuleset().getAllDestinations();//JAXB
                 */
                List<String> outputIds = new ArrayList<String>();
                
                // get all destinations for this advice.
                if(outputIds.size() == 0) {
                    //List<Output> outputs = this.aspect.getOutputs(); JAXB
                    this.outputs = AspectMapBuilder.getAspectMapBuilder().getOutputList(this.aspect);
                    //outputs = Util.getSortedOutputList(outputs); JAXB
                    this.outputs = Utiltools.getSortedOutputList(this.outputs);
                    Iterator outIt = outputs.iterator();
                    while(outIt.hasNext()) {
                        // defaulting the output pin to the first available output in the aspect.
                        //output = (Output)outIt.next(); JAXB
                        this.output = (OutputType)outIt.next();
                        createPin(scene, currentNodeID, "pin" + pinID++, IMAGE_ITEM_CONSUMES,
                                "                       ", "Output", "Consumes Endpoint", true, output);
                        break;
                    }
                }
                /*
                else {
                    //WILL BE USED AFTER Introduction of RuleSet in outputs
                    output = null;
                    aspect.setOutputs(Util.getSortedOutputList(aspect.getOutputs()));
                    Iterator outputIt = outputIds.iterator();
                    while(outputIt.hasNext()) {
                        String id = (String)outputIt.next();
                        createPin(scene, currentNodeID, "pin" + pinID++, IMAGE_ITEM_CONSUMES,
                                "                       ", "Output", "Consumes Endpoint", true, Util.getMatchingOutput(id, aspect));
                 
                        }
                    }
                 */
            }
        }
    }
    
    public void setSelectedNode(Widget wd) {
        Object obj = objectMap.get(wd);
        if(obj != null) {
            if(obj instanceof AdviceType) {
                AdviceType ad = (AdviceType)obj;
                if(ad.getType().equalsIgnoreCase(AspectConstants.ADVICE_LOGGING)){
                    WindowManager.getDefault().getRegistry().getActivated().setActivatedNodes(new Node[]{new loggingNode(ad)});
                }else if (ad.getType().equalsIgnoreCase(AspectConstants.ADVICE_THROTTLING)){
                    WindowManager.getDefault().getRegistry().getActivated().setActivatedNodes(new Node[]{new throttlingNode(ad)});
                }else if (ad.getType().equalsIgnoreCase(AspectConstants.ADVICE_AUTO_RECONNECT)){
                    WindowManager.getDefault().getRegistry().getActivated().setActivatedNodes(new Node[]{new autoReconnectNode(ad)});
                }
            }
        }
    }
    
    public JComponent reloadGraph(boolean sync) {
        refreshGraph(sync, this.aspect);
        return scene.createView();
    }
    
    //public void refreshGraph(boolean sync, Aspect asp) { JAXB
    public void refreshGraph(boolean sync, AspectType asp) {
        aspect = asp;
        removeAllWidgets();
        generateGraphForAspect(this.aspect, scene);
        scene.validate();
        scene.layoutScene();
        if(sync) {
            synchDocument();
        }
    }
    
    public void removeAdvice(Widget widget) {
        //Advice adv = (Advice)objectMap.get(widget); JAXB
        AdviceType adv = (AdviceType)objectMap.get(widget);
        //aspect.removeAdvice(adv); JAXB
        AspectMapBuilder.getAspectMapBuilder().removeAdvice(aspect, adv);
        refreshGraph(true, aspect);
        mObj.setModified(true);
    }
    
    private void removeAllWidgets() {
        Iterator it = objectMap.keySet().iterator();
        while(it.hasNext()) {
            Widget wd = (Widget)it.next();
            wd.removeFromParent();
            scene.validate();
        }
    }
    
    public void resetMaps() {
        // reset
        objectMap.clear();
        graphMap.clear();
        outputMap.clear();
        outputs.clear();
        nodeID = 1;
        pinID = 1;
        edgeID = 1;
    }
    
    //public void insertAfterInput(String advice) { JAXB
    public void insertAfterInput(String adviceType) {
        //List<Advice> list = Util.getSortedAdviceList(aspect.getAdvices()); JAXB
        List<AdviceType> list = Utiltools.getSortedAdviceList(AspectMapBuilder.getAspectMapBuilder().getAdviceList(this.aspect));
        Iterator it = list.iterator();
        while(it.hasNext()) {
            //Advice adv = (Advice)it.next(); //JAXB
            AdviceType adv = (AdviceType)it.next();
            //adv.setOrderNo(String.valueOf( Integer.parseInt(adv.getOrderNo()) + 1)); //JAXB
            adv.setOrder(new Byte(Integer.toString(Integer.parseInt(Byte.toString(adv.getOrder())) + 1)).byteValue());
        }
        //list = Util.makeSpaceforAdvice(list, 1); JAXB
        //list = Utiltools.makeSpaceforAdvice(list, 1);
        //Advice newAdvice = new Advice(adviceType, "1"); JAXB
        AdviceType advicetypeobj = AspectMapBuilder.getAspectMapBuilder().addNewAdvice(this.aspect, adviceType, "1");
        list.add(0, advicetypeobj);
        //aspect.setAdvices(list); JAXB
        refreshGraph(true, this.aspect);
    }
    
    //public void insertAfterAdvice(Advice advice, String adviceType) { //JAXB
    public void insertAfterAdvice(AdviceType advice, String adviceType) {
        //List<Advice> list = Util.getSortedAdviceList(aspect.getAdvices()); JAXB
        List<AdviceType> list = Utiltools.getSortedAdviceList(AspectMapBuilder.getAspectMapBuilder().getAdviceList(this.aspect));
        String orderNo = null;
        int index = -1;
        Iterator it = list.iterator();
        int i = 0;
        while(it.hasNext()) {
            //Advice adv = (Advice)it.next(); JAXB
            AdviceType adv = (AdviceType)it.next();
            if(orderNo != null) {
                adv.setOrder(Byte.parseByte(String.valueOf( Integer.parseInt(Byte.toString(adv.getOrder())) + 1)));
            }
            if(advice.getOrder() == adv.getOrder()) {
                orderNo = String.valueOf(Integer.parseInt(Byte.toString(advice.getOrder())) + 1);
                index = i;
            }
            i++;
        }
        //Advice newAdvice = new Advice(adviceType, orderNo); JAXB
        AdviceType advicetypeobj = AspectMapBuilder.getAspectMapBuilder().addNewAdvice(this.aspect, adviceType, orderNo);
        AdviceType newAdvice = new AdviceType();
        newAdvice.setOrder(Byte.parseByte(orderNo));
        newAdvice.setType(adviceType);
        list.add(index, newAdvice);
        //aspect.setAdvices(list); JAXB
        refreshGraph(true, this.aspect);
    }
    
    public void createNewAspect(String type) {
        //List<Aspect> aspectsList = Util.getSortedAspectList(model.getAspects());
        List<AspectType> aspectsList = Utiltools.getSortedAspectList(AspectMapBuilder.getAspectMapBuilder().getAspectList());
        //model.setAspects(aspectsList); JAXB
        String id = "";
        if(aspectsList.size() != 0) {
            id = String.valueOf(Integer.parseInt(
                    aspectsList.get(aspectsList.size() - 1).getID()) + 1);
        } else {
            id = "1";
        }
        //aspect = new Aspect(type, id); JAXB
        aspect = new AspectType();
        aspect.setID(id);
        aspect.setExchangeType(Utiltools.getAspectTypes(type));
        //model.addAspect(aspect); JAXB
        AspectMapBuilder.getAspectMapBuilder().addAspect(aspect);
        refreshGraph(true, aspect);
    }
    
    /* Need Basis - JAXB
    void setNewAdviceChain(List<Advice> list) {
        aspect.setAdvices(list);
        refreshGraph(true, aspect);
    }
     */
    
    public void setInputProperties(String partnerLink, String roleName, String portType,
            String messageType, String operation) {
        input = AspectMapBuilder.getAspectMapBuilder().getInput(this.aspect);
        //input = aspect.getInput(); JAXB
        input.setPartnerLink(partnerLink);
        input.setRoleName(roleName);
        input.setPortType(portType);
        input.setMessageType(messageType);
        input.setOperation(operation);
        //aspect.setInput(input);
        refreshGraph(true, aspect);
    }
    
    public Object getModelForWidget(Widget widget) {
        return objectMap.get(widget);
    }
    
    //public void updateAdvice(Advice advice) { JAXB
    public void updateAdvice(AdviceType advice) {
        //aspect.replace(advice); JAXB
        AspectMapBuilder.getAspectMapBuilder().replaceAdvice(advice);
        refreshGraph(true, this.aspect);
    }
    
    public AspectDataObject getDataObject() {
        return mObj;
    }
    
    //public void setCurrentAspect(Aspect asp) { JAXB
    public void setCurrentAspect(AspectType asp) {
        aspect = asp;
        refreshGraph(true, aspect);
    }
    
    public void synchDocument() {
        if(mObj != null) {
            if(mObj.getAspectDataEditorSupport() != null)
                mObj.getAspectDataEditorSupport().synchDocument();
        }
    }
    
    /* widget to object conversion Map */
    private Map<Widget, Object> objectMap;
    
    /* model to widget conversion Map */
    private Map<Object, Widget> graphMap;
    
    /* outputID to outputNodeID conversion Map */
    private Map<String, String> outputMap;
}