/*
 * utiltools.java
 *
 * Created on May 30, 2007, 4:55:53 PM
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

package org.netbeans.modules.aspect.editor.jaxbutils;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import org.netbeans.modules.aspect.editor.jaxbmodel.AdviceType;
import org.netbeans.modules.aspect.editor.jaxbmodel.AspectType;
import org.netbeans.modules.aspect.editor.jaxbmodel.ExchangeSimpleType;
import org.netbeans.modules.aspect.editor.jaxbmodel.OutputType;
import org.netbeans.modules.aspect.editor.mapbuilder.AspectMapBuilder;

/**
 *
 * @author Manish
 */
public class Utiltools {
    
    public Utiltools() {
    }
    
    public static List<AdviceType> getSortedAdviceList(List<AdviceType> adviceList) {
        SortedMap<Integer, AdviceType> map = new TreeMap<Integer, AdviceType>();
        if (adviceList != null) {
            Iterator it = adviceList.iterator();
            while(it.hasNext()) {
                AdviceType adv = (AdviceType)it.next();
                map.put(Integer.parseInt((new Byte(adv.getOrder())).toString()), adv);
            }
            
            // make sure id starts from 1.
            it = map.keySet().iterator();
            int i = 1;
            while(it.hasNext()) {
                Integer id = (Integer) it.next();
                ((AdviceType)map.get(id)).setOrder(new Byte(String.valueOf(i++)).byteValue());
            }
        }
        return new ArrayList<AdviceType>(map.values());
    }
    
    public static List<AspectType> getSortedAspectList(List<AspectType> aspectList) {
        Iterator it = aspectList.iterator();
        SortedMap<Integer, AspectType> map = new TreeMap<Integer, AspectType>();
        while(it.hasNext()) {
            AspectType asp = (AspectType)it.next();
            map.put(Integer.parseInt(asp.getID()), asp);
        }
        
        // make sure id starts from 1.
        it = map.keySet().iterator();
        int i = 1;
        while(it.hasNext()) {
            Integer id = (Integer) it.next();
            ((AspectType)map.get(id)).setID(String.valueOf(i++));
        }
        return new ArrayList<AspectType>(map.values());
    }
    
    public static List<AdviceType> makeSpaceforAdvice(List<AdviceType> list, int i) {
        list = getSortedAdviceList(list);
        Iterator it = list.iterator();
        while(it.hasNext()) {
            AdviceType adv = (AdviceType)it.next();
            if((Integer.parseInt(Byte.toString(adv.getOrder()))) >= i ) {
                adv.setOrder(Byte.parseByte(String.valueOf(i + 1)));
            }
        }
        return list;
    }
    
    public static void makeSpaceforDefaultOutput(AspectType aspect) {
        List<OutputType> outs = AspectMapBuilder.getAspectMapBuilder().getOutputList(aspect);
        Iterator it = getSortedOutputList(outs).iterator();
        int id = 2;
        while(it.hasNext()) {
            OutputType out = (OutputType)it.next();
            out.setID(String.valueOf(id++));
        }
        //aspect.setOutputs(outs); JAB , May not be needed
    }
    
    public static List<OutputType> getSortedOutputList(List<OutputType> outputList) {
        Iterator it = outputList.iterator();
        //SortedMap<Integer, Output> map = new TreeMap<Integer, OutputType>(); JAXB
        SortedMap<Integer, OutputType> map = new TreeMap<Integer, OutputType>();
        while(it.hasNext()) {
            OutputType out = (OutputType)it.next();
            map.put(Integer.parseInt(out.getID()), out);
        }
        
        // make sure id starts from 1.
        it = map.keySet().iterator();
        int i = 1;
        while(it.hasNext()) {
            Integer id = (Integer) it.next();
            ((OutputType)map.get(id)).setID(String.valueOf(i++));
        }
        
        return new ArrayList<OutputType>(map.values());
    }
    
    public static ExchangeSimpleType getAspectTypes(String type) {
        if (type.equals("requestReply")) {
            return ExchangeSimpleType.REQUEST_REPLY;
        } else if (type.equals("filterOneWay")) {
            return ExchangeSimpleType.FILTER_ONE_WAY;
        } else if (type.equals("filterRequestReply")) {
            return ExchangeSimpleType.FILTER_REQUEST_REPLY;
        }
        
        return ExchangeSimpleType.REQUEST_REPLY; //DEFAULT
    }
    
}
