/*
 * The contents of this file are subject to the terms of the Common
 * Development and Distribution License (the License). You may not use this
 * file except in compliance with the License.  You can obtain a copy of the
 * License at http://www.netbeans.org/cddl.html

 * When distributing Covered Code, include this CDDL Header Notice in each
 * file and include the License. If applicable, add the following below the
 * CDDL Header, with the fields enclosed by brackets [] replaced by your own
 * identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"

 * Copyright 2006 Sun Microsystems, Inc. All Rights Reserved
 *
 */

package org.netbeans.modules.aspect.editor.model;

import java.io.File;
import org.w3c.dom.Element;

/**
 * This class holds the advice tag model.
 * @author karthikeyan s
 */
public class Advice {
    
    private PropertiesModel propModel;
    
    private String type;
    
    private String orderNo;
    
    private String configFile="";
    
    /** Creates a new instance of Advice */
    public Advice(String advType, String order) {
        type = advType;
        orderNo = order;
        propModel = new PropertiesModel();
    }
    
    public Advice(Element advice) {
        type = advice.getAttribute(AspectConstants.ADVICE_ATTR_TYPE);
        orderNo = advice.getAttribute(AspectConstants.ADVICE_ATTR_ORDER);
        configFile= advice.getAttribute(AspectConstants.ADVICE_ATTR_CONFIG_FILE);
        propModel = new PropertiesModel(advice);
    }
    
    public void setType(String advType) {
        type = advType;
    }
    
    public void setOrderNo(String order) {
        orderNo = order;
    }
    
    public String getOrderNo() {
        return orderNo;
    }

    public String getType() {
        return type;
    }
    
    public void setPropertiesModel(PropertiesModel model) {
        propModel = model;
    }
    
    public PropertiesModel getPropertiesModel() {
        return propModel;
    }
    
    public String toXmlString() {
        StringBuffer xmlString = new StringBuffer();
        xmlString.append("\t<" + AspectMap.ADVICE + " " + AspectConstants.ADVICE_ATTR_TYPE +"=\"" +
                type + "\" " 
                
                + AspectConstants.ADVICE_ATTR_CONFIG_FILE +"=\"" +
                configFile + "\" " 
                
                + AspectConstants.ADVICE_ATTR_ORDER +"=\"" + orderNo +"\">\n");
        xmlString.append(propModel.toXMLString() + "\n");
        xmlString.append("\t</" + AspectMap.ADVICE + ">");
        return xmlString.toString();
    }
}
