/*
 *  Copyright (c) 2005, 2006 Imola Informatica.
 *  All rights reserved. This program and the accompanying materials
 *  are made available under the terms of the LGPL License v2.1
 *  which accompanies this distribution, and is available at
 *  http://www.gnu.org/licenses/lgpl.html
 */


package it.imolinfo.jbi4cics.netbeansplugin.cpy2wsdlwizard;

import java.awt.Image;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.SimpleBeanInfo;
import org.openide.loaders.UniFileLoader;
import org.openide.util.Utilities;

public class CPYDataLoaderBeanInfo extends SimpleBeanInfo {

    static final String IMAGE_ICON_BASE
            = "it/imolinfo/jbi4cics/netbeansplugin/cpy2wsdlwizard/cpy16x16.png";

    public CPYDataLoaderBeanInfo() {
    }

    @Override
    public BeanInfo[] getAdditionalBeanInfo() {                 // Overridden
        try {
            return new BeanInfo[] {
                Introspector.getBeanInfo(UniFileLoader.class)
            };
        } catch (IntrospectionException e) {
            throw new AssertionError(e);
        }
    }

    @Override
    public Image getIcon(final int type) {                      // Overridden
        switch (type) {
        case ICON_COLOR_16x16:
            /* falls through */
        case ICON_MONO_16x16:
            return Utilities.loadImage(IMAGE_ICON_BASE);

        default:
            return null;
        }
    }
}
