package it.imolinfo.jbi4corba.netbeansplugin.idl2wsdlwizard;

import java.awt.Image;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.SimpleBeanInfo;
import org.openide.loaders.UniFileLoader;
import org.openide.util.Utilities;

public class IDLDataLoaderBeanInfo extends SimpleBeanInfo {
    
    static final String IMAGE_ICON_BASE
            = "it/imolinfo/jbi4corba/netbeansplugin/idl2wsdlwizard/idl16x16.png";
    
    public IDLDataLoaderBeanInfo() {
    }

    public BeanInfo[] getAdditionalBeanInfo() {                 // Overridden
        try {
            return new BeanInfo[] {
                Introspector.getBeanInfo(UniFileLoader.class)
            };
        } catch (IntrospectionException e) {
            throw new AssertionError(e);
        }
    }
    
    public Image getIcon(int type) {                            // Overridden
        return ((type == BeanInfo.ICON_COLOR_16x16)
                || (type == BeanInfo.ICON_MONO_16x16))
               ? Utilities.loadImage(IMAGE_ICON_BASE)
               : null;
    }
}
