/*******************************************************************************
 *  Copyright (c) 2005, 2006, 2007 Imola Informatica.
 *  All rights reserved. This program and the accompanying materials
 *  are made available under the terms of the LGPL License v2.1
 *  which accompanies this distribution, and is available at
 *  http://www.gnu.org/licenses/lgpl.html
 *******************************************************************************/
package it.imolinfo.jbi4ejb.nbm;

import java.io.File;
import javax.swing.filechooser.FileFilter;


/**
 * Ear file filter for the swinf FileChooser. 
 * 
 * @author marco
 */
public class EarFileFilter extends FileFilter {
    
    private static final String EAR_FILE_FILTER_EXTENSION ="ear";

    /**
     * Instantiates a new ear file filter.
     */
    public EarFileFilter() {}

    
    /**
     * True if the file is accepted.
     * 
     * @param f the file to verify
     * 
     * @return true, if successful
     */
    public boolean accept(File f) {
        boolean ret = false;        
        if (f != null) {
            if ((f.isFile() && (f.getName().endsWith(EAR_FILE_FILTER_EXTENSION))) || f.isDirectory()) {
                ret = true;
            }
        }
        return ret;
    }
 
    /**
     * Gets the description.
     * 
     * @return the description
     */
    public String getDescription() {
        String desc = "Filters all the *.ear files";
        return desc;
    }

}
