package it.imolinfo.jbi4ejb.nbm;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.JPanel;

public final class SelectRemoteInterfaceVisualPanel extends JPanel {

    private static final Logger LOG = Logger.getLogger(SelectRemoteInterfaceVisualPanel.class.getName());
    
    private SelectRemoteInterfaceWizardPanel wizardPanel = null;
        
    public SelectRemoteInterfaceVisualPanel(SelectRemoteInterfaceWizardPanel wizardPanel) {        
        this.wizardPanel = wizardPanel;
        initComponents();        
    }

    public String getName() {
        return org.openide.util.NbBundle.getMessage(SelectRemoteInterfaceVisualPanel.class, "LBL_SelectEJB_INterface");
    }
    
        
    public void setListValues(List remoteInterfaces) {
        remoteInterfaceList.setListData(remoteInterfaces.toArray(new String[0]));
        
        remoteInterfaceList.repaint();
    }
    
    public void setSelectedValue(String selectedValue) {
        remoteInterfaceList.setSelectedValue(selectedValue, true);                        
    }    

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {

        labelSubTitle = new javax.swing.JLabel();
        remoteInterfacePanel = new javax.swing.JScrollPane();
        remoteInterfaceList = new javax.swing.JList();
        labelRemoteInterfaceSelected = new javax.swing.JLabel();

        org.openide.awt.Mnemonics.setLocalizedText(labelSubTitle, org.openide.util.NbBundle.getMessage(SelectRemoteInterfaceVisualPanel.class, "LBL_SelectEJB_RemoteInterfaceLong")); // NOI18N

        remoteInterfaceList.setSelectionMode(javax.swing.ListSelectionModel.SINGLE_SELECTION);
        remoteInterfaceList.addListSelectionListener(new javax.swing.event.ListSelectionListener() {
            public void valueChanged(javax.swing.event.ListSelectionEvent evt) {
                remoteInterfaceListValueChange(evt);
            }
        });
        remoteInterfacePanel.setViewportView(remoteInterfaceList);

        org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(org.jdesktop.layout.GroupLayout.TRAILING, layout.createSequentialGroup()
                .addContainerGap()
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.TRAILING)
                    .add(org.jdesktop.layout.GroupLayout.LEADING, remoteInterfacePanel, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 489, Short.MAX_VALUE)
                    .add(labelSubTitle, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 489, Short.MAX_VALUE)
                    .add(labelRemoteInterfaceSelected, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 320, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(labelSubTitle, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 15, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(remoteInterfacePanel, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 243, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .add(labelRemoteInterfaceSelected)
                .addContainerGap())
        );
    }// </editor-fold>//GEN-END:initComponents

private void remoteInterfaceListValueChange(javax.swing.event.ListSelectionEvent evt) {//GEN-FIRST:event_remoteInterfaceListValueChange
  
  remoteInterfaceSelected = (String) remoteInterfaceList.getSelectedValue();
  
  wizardPanel.fireChangeEvent();
  
}//GEN-LAST:event_remoteInterfaceListValueChange
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JLabel labelRemoteInterfaceSelected;
    private javax.swing.JLabel labelSubTitle;
    private javax.swing.JList remoteInterfaceList;
    private javax.swing.JScrollPane remoteInterfacePanel;
    // End of variables declaration//GEN-END:variables

  protected String remoteInterfaceSelected = "";

  public String getRemoteInterfaceSelected() {
      return (String) remoteInterfaceList.getSelectedValue();
  }
}

