/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.script.project.wizard.element;

import java.util.Collection;
import java.util.List;

import org.netbeans.modules.xml.xam.dom.NamedComponentReference;
import org.netbeans.modules.xml.wsdl.model.Definitions;
import org.netbeans.modules.xml.wsdl.model.ExtensibilityElement;
import org.netbeans.modules.xml.wsdl.model.Operation;
import org.netbeans.modules.xml.wsdl.model.PortType;
import org.netbeans.modules.xml.wsdl.model.WSDLComponentFactory;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;

import org.netbeans.modules.xml.wsdl.model.extensions.bpel.BPELComponentFactory;
import org.netbeans.modules.xml.wsdl.model.extensions.bpel.PartnerLinkType;
import org.netbeans.modules.xml.wsdl.model.extensions.bpel.Role;

/**
 * @author Raghunadh
 * 
 */
final class DialogOperation<T> {

  DialogOperation(
    WSDLModel model,
    PanelOperation<T> panel,
    Panel.PartnerRolePort partnerRolePort)
  {
    myModel = model;
    myPanel = panel;
    myPartnerRolePort = partnerRolePort;
  }

  protected void create(String name)
  {
    try {
      myModel.startTransaction();
      Definitions definitions = myModel.getDefinitions();
      WSDLComponentFactory factory = myModel.getFactory();

      PortType portType = getPortType(definitions, factory);
      Operation operation = createOperation(portType, factory, name);
      myPanel.setOperation(operation, myPartnerRolePort);
    } 
    finally {
      if (myModel.isIntransaction()) {
        myModel.endTransaction();
      }  
    }
    Util.saveModel(myModel);
  }

  private Operation createOperation(
    PortType portType,
    WSDLComponentFactory factory,
    String name)
  {
    Collection<Operation> operations = portType.getOperations();

    for (Operation operation : operations) {
      if (name.equals(operation.getName())) {
        return operation;
      }
    }
    Operation operation = factory.createRequestResponseOperation();
    operation.setName(name);
    portType.addOperation(operation);
    return operation;
  }

  private PortType getPortType(
    Definitions definitions,
    WSDLComponentFactory factory)
  {
    if (myPartnerRolePort != null) {
      return myPartnerRolePort.getPortType();
    }
    Collection<PortType> portTypes = definitions.getPortTypes();

    for (PortType portType : portTypes) {
      if (portType.getName().equals(PORT_TYPE_NAME)) {
        checkPartnerLinkType(definitions, portType);
        return portType;
      }
    }
    PortType portType = factory.createPortType();
    portType.setName(PORT_TYPE_NAME);
    definitions.addPortType(portType);
    checkPartnerLinkType(definitions, portType);
    return portType;
  }

  private void checkPartnerLinkType(Definitions definitions, PortType portType) {
    PartnerLinkType partnerLinkType = getPartnerLinkType(definitions);
    Role role1 = partnerLinkType.getRole1();

    if (hasPortType(role1, portType)) {
      myPartnerRolePort = new Panel.PartnerRolePort(
        partnerLinkType,
        role1,
        portType
      );
      return;
    }
    Role role2 = partnerLinkType.getRole1();

    if (hasPortType(role2, portType)) {
      myPartnerRolePort = new Panel.PartnerRolePort(
        partnerLinkType,
        role2,
        portType
      );
      return;
    }
    if (role1 == null) {
      role1 = new BPELComponentFactory(myModel).createRole(partnerLinkType);
      role1.setName(ROLE_NAME);
      partnerLinkType.setRole1(role1);
    }
    role1.setPortType(role1.createReferenceTo(portType, PortType.class));
    myPartnerRolePort = new Panel.PartnerRolePort(
      partnerLinkType,
      role1,
      portType
    );
  }

  private boolean hasPortType(Role role, PortType portType) {
    if (role == null) {
      return false;
    }
    NamedComponentReference<PortType> reference = role.getPortType();

    if (reference == null) {
      return false;
    }
    return portType.equals(reference.get());
  }

  private PartnerLinkType getPartnerLinkType(Definitions definitions) {
    List<ExtensibilityElement> elements = definitions.getExtensibilityElements();
    PartnerLinkType partnerLinkType;

    for (ExtensibilityElement element : elements) {
      if (element instanceof PartnerLinkType) {
        partnerLinkType = (PartnerLinkType) element;

        if (partnerLinkType.getName().equals(PARTNER_LINK_TYPE_NAME)) {
          return partnerLinkType;
        }
      }
    }
    partnerLinkType =
      new BPELComponentFactory(myModel).createPartnerLinkType(definitions);
    partnerLinkType.setName(PARTNER_LINK_TYPE_NAME);
    definitions.addExtensibilityElement(partnerLinkType);
    return partnerLinkType;
  }

  private WSDLModel myModel;
  private PanelOperation<T> myPanel;
  private Panel.PartnerRolePort myPartnerRolePort;

  private static final String ROLE_NAME = "Role"; // NOI18N
  private static final String PORT_TYPE_NAME = "PortType"; // NOI18N
  private static final String PARTNER_LINK_TYPE_NAME = "PartnerLinkType"; // NOI18N
}
