/*
 * TaskDefinitionMultiViewElement.java
 * 
 * Created on May 24, 2007, 3:09:23 PM
 * 
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package org.netbeans.modules.worklist.editor.multiview.escalation;

import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JToolBar;
import org.netbeans.modules.wlm.model.api.TEscalation;
import org.netbeans.modules.wlm.model.api.TTask;
import org.netbeans.modules.wlm.model.api.WLMComponent;
import org.netbeans.modules.wlm.model.api.WLMModel;
import org.netbeans.modules.worklist.dataloader.WorklistDataObject;
import org.netbeans.modules.worklist.editor.multiview.EditorConstants;
import org.netbeans.modules.worklist.editor.multiview.PanelKey;
import org.netbeans.modules.worklist.editor.multiview.TaskSelectionEvent;
import org.netbeans.modules.worklist.editor.multiview.TaskSelectionListener;
import org.netbeans.modules.worklist.editor.multiview.TaskSelectionModel;
import org.netbeans.modules.worklist.editor.multiview.assignment.UsersOrGroupsNode;
import org.netbeans.modules.worklist.editor.view.actions.RemoveAction;
import org.netbeans.modules.worklist.editor.view.nodes.AssignmentNode;
import org.netbeans.modules.worklist.editor.view.nodes.DeadlineOrDurationNode;
import org.netbeans.modules.worklist.editor.view.nodes.EscalationNode;
import org.netbeans.modules.worklist.node.cookie.WLMComponentCookie;
import org.netbeans.modules.xml.multiview.ToolBarMultiViewElement;
import org.netbeans.modules.xml.multiview.ui.SectionContainer;
import org.netbeans.modules.xml.multiview.ui.SectionContainerNode;
import org.netbeans.modules.xml.multiview.ui.SectionPanel;
import org.netbeans.modules.xml.multiview.ui.SectionView;
import org.netbeans.modules.xml.multiview.ui.ToolBarDesignEditor;
import org.netbeans.modules.xml.validation.ValidateAction;
import org.netbeans.modules.xml.xam.ComponentEvent;
import org.netbeans.modules.xml.xam.ComponentListener;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

/**
 *
 * @author radval
 */
public class EscalationMultiViewElement extends ToolBarMultiViewElement implements java.beans.PropertyChangeListener {

    private WorklistDataObject dObj;
    
    private EscalationsView view;
    private ToolBarDesignEditor comp;
    private EscalationPanelFactory factory;
    private javax.swing.Action addAction;
    private boolean needInit=true;
    private int index;
    private TaskSelectionModel taskSelectionModel;
    private TTask selectedTask;
    
    private List<TEscalation> existingEscalation = new ArrayList<TEscalation>();
    
    private RequestProcessor.Task repaintingTask;
   
    private static final String HELP_ID_PREFIX=WorklistDataObject.HELP_ID_PREFIX_ASSIGNMENT;
    
    static final String ESCALATION_PANEL = "Escalation";
    
    
    
    public EscalationMultiViewElement(final WorklistDataObject dObj, 
                                      int index,
                                      TaskSelectionModel taskSelectionModel) {
        super(dObj);
        this.dObj=dObj;
        this.index=index;
        this.taskSelectionModel = taskSelectionModel;
        
         comp = new ToolBarDesignEditor();
        factory = new EscalationPanelFactory(comp, dObj);
        addAction = new AddAction(dObj,NbBundle.getMessage(EscalationMultiViewElement.class,"LBL_addEscalation"));
        setVisualEditor(comp);
        view = new EscalationsView();
        comp.setContentView(view);
        repaintingTask = RequestProcessor.getDefault().create(new Runnable() {
            public void run() {
                javax.swing.SwingUtilities.invokeLater(new Runnable() {
                    public void run() {
                        repaintView();
                    }
                });
            }
        });
        
        initGUI();
    }

    public SectionView getSectionView() {
        return view;
    }

    public void propertyChange(PropertyChangeEvent evt) {
//        if (!dObj.isChangedFromUI()) {
//            String name = evt.getPropertyName();
//            if ( name.indexOf("WelcomeFileList")>0 || //NOI18N
//                 name.indexOf("JspConfig")>0 || //NOI18N
//                 name.indexOf("ErrorPage")>0 || //NOI18N
//                 name.indexOf("version")>0 ) { //NOI18N
//                // repaint view if the wiew is active and something is changed with elements listed above
//                if (PAGES_MV_ID.equals(dObj.getSelectedPerspective().preferredID())) {
//                    repaintingTask.schedule(100);
//                } else {
//                    needInit=true;
//                }
//            }
//        }
    }
    
    private void repaintView() {
        
        Object lastActive = comp.getLastActive();
        if (lastActive!=null) {
            ((SectionView)view).openPanel(lastActive);
        } else {
            EscalationsView escalationsView = (EscalationsView)view;
            Node initialNode = escalationsView.getEscalationsNode();
            Children ch = initialNode.getChildren();
            if (ch.getNodesCount()>0) 
                initialNode = ch.getNodes()[0];
            escalationsView.selectNode(initialNode);
        }
        view.checkValidity();
        //ritdObj.checkParseable();
    }
    
    public void componentShowing() {
        super.componentShowing();
        dObj.setLastOpenView(index);
        if (needInit || !dObj.isDocumentParseable()) {
            repaintView();
            needInit = false;
        }
    }
    
    
     private void initGUI() {
        dObj.getTaskSelectionModel().addTaskSelectionListner(new TaskSelectionAdapter());
        
        selectedTask = dObj.getTaskSelectionModel().getSelectedTask();
        
        WLMModel model = dObj.getModel();
        if(model != null) {
            model.addComponentListener(new TaskComponentListener());
        }

        JComponent toolbar = comp.getStructureView();
        if(toolbar instanceof JToolBar) {
            JToolBar tBar = (JToolBar) toolbar;
            tBar.add(new ValidateAction(model));
        }
   }
    
     private void refreshWhenChildAdded() {
         List<TEscalation> escalations =  selectedTask.getEscalations();
         if(escalations != null) {
             Iterator<TEscalation> it =  escalations.iterator();
             while(it.hasNext()) {
                 TEscalation escalation = it.next();
                 if(!existingEscalation.contains(escalation)) {
                   SectionContainer escalationContainer = view.addEscalation(escalation, escalations.indexOf(escalation));
                   if(escalationContainer != null) {
                        escalationContainer.open(); 
                   }
                }
                 
             }
             
             existingEscalation = escalations;
         }
         
    }
    
    private void refreshWhenChildRemoved() {
        List<TEscalation> escalations =  selectedTask.getEscalations();
         if(escalations != null) {
             Iterator<TEscalation> it =  existingEscalation.iterator();
             while(it.hasNext()) {
                 TEscalation escalation = it.next();
                 if(!escalations.contains(escalation)) {
                   view.removeEscalation(escalation);
                }
                 
             }
             
             existingEscalation = escalations;
         }
    }
    
    class EscalationsView extends SectionView {
        private SectionContainer escalationsContainer;
        private Node escalationsNode;
        
            
        EscalationsView () {
            super(factory);
            
            Children ch = new Children.Array();
            escalationsNode = new SectionContainerNode(ch);
            //root.setDisplayName("<Servlets>");
            escalationsNode.setDisplayName(NbBundle.getMessage(EscalationMultiViewElement.class,"TTL_escalations"));
            escalationsNode.setName(HELP_ID_PREFIX+"servletsNode"); //NOI18N

            refreshGUI();
            

            Children servletsChildren = new Children.Array();
            servletsChildren.add(new Node[]{escalationsNode});
        
            AbstractNode root = new AbstractNode(servletsChildren);
            setRoot(root);
            
        }
        
        Node getEscalationsNode() {
            return escalationsNode;
        }
        
        
        public org.netbeans.modules.xml.multiview.Error validateView() {
            org.netbeans.modules.xml.multiview.Error error = null; //getSectionView().getErrorPanel().getError();
//            if (error != null){
//                return error;
//            }
            
            TTask task = taskSelectionModel.getSelectedTask();
            if(task == null) {
                error = new org.netbeans.modules.xml.multiview.Error(org.netbeans.modules.xml.multiview.Error.ERROR_MESSAGE, "Select a task from overview section" , this);
            } 
            return error;
            //ritreturn SectionValidator.validateServlets(webApp);
        }
        
        private void refreshGUI() {
            TTask task = selectedTask;
            if(task != null) {
                
                if(escalationsNode != null) {
                    escalationsNode.getChildren().remove(escalationsNode.getChildren().getNodes());
                }
                
                if(escalationsContainer != null) {
                    removeSection(escalationsContainer);
                }
                

                escalationsContainer = new SectionContainer(this,escalationsNode,
                    NbBundle.getMessage(EscalationMultiViewElement.class,"TTL_escalations"),false);
                escalationsContainer.setHeaderActions(new javax.swing.Action[]{addAction});
                addSection(escalationsContainer);

                List<TEscalation> escalations = task.getEscalations();
                Node[] nodes = new Node[escalations.size()];
                existingEscalation = new ArrayList<TEscalation>();
                existingEscalation.addAll(escalations);
                        
                for (int i=0; i < escalations.size(); i++) {
                    TEscalation escalation = escalations.get(i);
                    addEscalation(escalation, i);
                }
                
            }
        }
        
        public SectionContainer addEscalation(TEscalation escalation, int i) {
            SectionContainer escalationContainer = null;
            if(escalation != null) {
                String displayName = "Escalation ("+ i + ")";
                    EscalationNode node = new EscalationNode(this, escalation, displayName);
                    EscalationData escalationData = new EscalationData(escalation);
                    node.addToLookup(escalationData);
                    
                    escalationContainer = new SectionContainer(this, node, displayName, false);
                    RemoveAction removeAction = new RemoveAction(escalation);
                    escalationContainer.setHeaderActions(new javax.swing.Action[]{removeAction});
                    escalationsContainer.addSection(escalationContainer);
                    escalationData.addContainer(escalationContainer);
                
                    
                    PanelKey key = new PanelKey(escalation, null);
                    DeadlineOrDurationNode deadlineOrDurationNode = new DeadlineOrDurationNode(escalation, "Deadline Or Duration");
                    SectionPanel dPanel = new SectionPanel(this, deadlineOrDurationNode, "Deadline Or Duration", key);
                    escalationContainer.addSection(dPanel);
                    escalationsNode.getChildren().add(new Node[] {deadlineOrDurationNode});
                    escalationData.addNode(deadlineOrDurationNode);
                    
                    String assignmentNodeDisplayName = "Assignment";
                    
                    AssignmentNode assignmentNode = new AssignmentNode(this, escalation.getAssignment(), assignmentNodeDisplayName);
                    escalationsNode.getChildren().add(new Node[] {assignmentNode});
                    escalationData.addNode(assignmentNode);
                
                    //SectionPanel assignmentPanel = new SectionPanel(this, assignmentNode, assignmentNodeDisplayName, keyAssign);
                    //escalationContainer.addSection(assignmentPanel);
                   
                    SectionContainer assignmentContainer = new SectionContainer(this, assignmentNode, assignmentNodeDisplayName);
                    escalationsContainer.addSection(assignmentContainer);
                    escalationData.addContainer(assignmentContainer);
                
                    String[] assignments = new String[] {EditorConstants.USERS_PANEL, EditorConstants.GROUPS_PANEL};
                    Node[] assignmentsNodes = new Node[assignments.length];
                    for (int j=0; j < assignmentsNodes.length;j++) {
                        assignmentsNodes[j] = new UsersOrGroupsNode(this, assignments[j]);
                        key = new PanelKey(escalation, assignments[j]);
                        SectionPanel ugPanel = new SectionPanel(this, assignmentsNodes[j], assignments[j], key);
                        assignmentContainer.addSection(ugPanel);
                        escalationsNode.getChildren().add(new Node[] {assignmentsNodes[j]});
                        escalationData.addNode(assignmentsNodes[j]);
                
                    }
                    
                    escalationsNode.getChildren().add(new Node[] {node});
            }
            
            return escalationContainer;
        }
        
        public void removeEscalation(TEscalation escalation) {
            Node matchingNode = null;
            
            Children children = escalationsNode.getChildren();
            Node[] nodes = children.getNodes();
            for(int i = 0; i < nodes.length; i++) {
                Node node = nodes[i];
                WLMComponentCookie cookie = node.getLookup().lookup(WLMComponentCookie.class);
                if(cookie != null) {
                    WLMComponent component = cookie.getWLMComponent();
                    if(component != null && component.equals(escalation)) {
                        matchingNode = node;
                        break;    
                    }
                }
            }
            
            if(matchingNode != null) {
                EscalationData data = matchingNode.getLookup().lookup(EscalationData.class);
                if(data != null) {
                    List<Node> otherNodes = data.getNodes();
                    Iterator<Node> it = otherNodes.iterator();
                    while(it.hasNext()) {
                        Node n = it.next();
                        children.remove(new Node[] {n});
                        removeSection(n);
                    }
                }
                
                children.remove(new Node[] {matchingNode});
                removeSection(matchingNode);
            }
        }
        
    }
    
    
    private class AddAction extends javax.swing.AbstractAction {
        
        AddAction(final WorklistDataObject dObj, String actionName) {
            super(actionName);
            char mnem = NbBundle.getMessage(EscalationMultiViewElement.class,"LBL_addEscalation_mnem").charAt(0);
            putValue(MNEMONIC_KEY,new Integer((int)mnem));
        }
        public void actionPerformed(java.awt.event.ActionEvent evt) {
            TEscalation escalation = dObj.getModel().getFactory().createEscalation(dObj.getModel());
            dObj.getModel().startTransaction();
            selectedTask.addEscalation(escalation);
            dObj.getModel().endTransaction();
        }
    }
    
    
    
    private class TaskSelectionAdapter implements TaskSelectionListener {

        public void taskSelected(TaskSelectionEvent evt) {
            TTask task = evt.getTask();
            selectedTask = task;
            //view.refreshGUI();
            view = new EscalationsView();
            comp.setContentView(view);
            view.checkValidity();
            //repaintingTask.schedule(100);
            
        }
    }
    
     private class TaskComponentListener implements ComponentListener {

        public void valueChanged(ComponentEvent evt) {
            
        }

        public void childrenAdded(ComponentEvent evt) {
            Object source = evt.getSource();
            if(source instanceof TTask) {
                refreshWhenChildAdded();
            }
        }

        public void childrenDeleted(ComponentEvent evt) {
            Object source = evt.getSource();
            if(source instanceof TTask) {
                refreshWhenChildRemoved();
            }
        }
        
    } 
     
    class EscalationData {
        TEscalation escalation;
        private List<Node> nodes = new ArrayList<Node>();
        
        private List<SectionContainer> containers = new ArrayList<SectionContainer>();
        
        public EscalationData(TEscalation escalation) {
            this.escalation = escalation;
        }
        
        public void addNode(Node node) {
            this.nodes.add(node);
        }
        
        public void addContainer(SectionContainer container) {
            this.containers.add(container);
        }
        
        public List<Node> getNodes() {
            return this.nodes;
        }
        
        public List<SectionContainer> getContainers() {
            return this.containers;
        }
    } 
}
