/*
 * ExplorerPropertyChangeListener.java
 * 
 * Created on Jun 21, 2007, 4:04:05 PM
 * 
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package org.netbeans.modules.worklist.editor.multiview.overview;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.netbeans.modules.xml.wsdl.model.Operation;
import org.netbeans.modules.xml.wsdl.model.WSDLComponent;
import org.openide.DialogDescriptor;
import org.openide.explorer.ExplorerManager;
import org.openide.nodes.Node;

/**
 *
 * @author radval
 */
public class ExplorerPropertyChangeListener implements PropertyChangeListener {

        private Operation selectedOperation;
        
        private DialogDescriptor dd;


        public ExplorerPropertyChangeListener(DialogDescriptor dd) {
            this.dd = dd;
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if(evt.getPropertyName().equals(ExplorerManager.PROP_SELECTED_NODES)) {
                Node[] nodes = (Node[]) evt.getNewValue();
                if(nodes.length > 0) {
                    Node node = nodes[0];

                    WSDLComponent comp = (WSDLComponent) node.getLookup().lookup(WSDLComponent.class);
                    if(comp != null && comp instanceof Operation) {
                        this.dd.setValid(true);
                        selectedOperation = (Operation) comp;
                    } else {
                        this.dd.setValid(false);
                    }
                }
            }
        }

        public Operation getSelectedOperation() {
    return this.selectedOperation;
}
    }
