/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.wlm.model.impl;

import org.netbeans.modules.wlm.model.api.TAssignment;
import org.netbeans.modules.wlm.model.api.TEscalation;
import org.netbeans.modules.wlm.model.api.WLMComponent;
import org.netbeans.modules.wlm.model.api.WLMModel;
import org.netbeans.modules.wlm.model.api.WLMVisitor;
import org.w3c.dom.Element;

public class EscalationImpl extends DeadLineOrDurationImpl implements
		TEscalation {

	public EscalationImpl(WLMModel model, Element e) {
		super(model, e);
		// TODO Auto-generated constructor stub
	}

	public EscalationImpl(WLMModel model) {
		this(model, createNewElement(WLMQNames.ESCALATION.getQName(), model));
	}

	public TAssignment getAssignment() {
		// TODO Auto-generated method stub
		return getChild(TAssignment.class);
	}

	public void setAssignment(TAssignment value) {
		// TODO Auto-generated method stub
		setChild(TAssignment.class, ASSIGNMENT_PROPERTY, value,
				TypeCollection.FOR_ESCALATION_ASSIGNMENT.types());
	}

	public void accept(WLMVisitor visitor) {
		// TODO Auto-generated method stub
		visitor.visitEscalation(this);
	}

	public WLMComponent createChild(Element childEl) {
		// TODO Auto-generated method stub
		WLMComponent child = null;
		if (childEl != null) {
			String localName = childEl.getLocalName();
			if (localName == null || localName.length() == 0) {
				localName = childEl.getTagName();
			}
			if (localName.equals(ASSIGNMENT_PROPERTY)) {
				child = new AssignmentImpl(getModel(), childEl);
			} else {
				child = super.createChild(childEl);
			}
		}
		return child;
	}

}
