/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 *
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.wlm.model.impl;

import javax.xml.namespace.QName;

import org.netbeans.modules.wlm.model.api.Group;
import org.netbeans.modules.wlm.model.api.Role;
import org.netbeans.modules.wlm.model.api.TAction;
import org.netbeans.modules.wlm.model.api.TAddress;
import org.netbeans.modules.wlm.model.api.TAssignment;
import org.netbeans.modules.wlm.model.api.TDeadlineExpr;
import org.netbeans.modules.wlm.model.api.TDurationExpr;
import org.netbeans.modules.wlm.model.api.TEscalation;
import org.netbeans.modules.wlm.model.api.TImport;
import org.netbeans.modules.wlm.model.api.TNotification;
import org.netbeans.modules.wlm.model.api.TRecipient;
import org.netbeans.modules.wlm.model.api.TTask;
import org.netbeans.modules.wlm.model.api.TTasks;
import org.netbeans.modules.wlm.model.api.TTimeout;
import org.netbeans.modules.wlm.model.api.User;
import org.netbeans.modules.wlm.model.api.WLMComponent;
import org.netbeans.modules.wlm.model.api.WLMComponentFactory;
import org.netbeans.modules.wlm.model.api.WLMModel;
import org.w3c.dom.Element;

/**
 * 
 * @author rico
 */
public class WLMComponentFactoryImpl implements WLMComponentFactory {

	private WLMModel model;

	/** Creates a new instance of WSDLComponentFactoryImpl */
	public WLMComponentFactoryImpl(WLMModel model) {
		this.model = model;
	}

	public WLMComponent create(Element element, WLMComponent context) {

		return context.createChild(element);
	}

	public WLMComponent create(WLMComponent parent, QName qName) {
		String q = qName.getPrefix();
		if (q == null || q.length() == 0) {
			q = qName.getLocalPart();
		} else {
			q = q + ":" + qName.getLocalPart();
		}
		Element element = model.getDocument().createElementNS(
				qName.getNamespaceURI(), q);
		return parent.createChild(element);
	}

	public TImport createImport(WLMModel model) {
		return new ImportImpl(model);
	}
	
	public TTasks createTasks (WLMModel model) {
		return new TasksImpl(model);
	}	
	
	public TTask createTask (WLMModel model) {
		return new TaskImpl(model);
	}	
	
	public TAssignment createAssignment (WLMModel model) {
		return new AssignmentImpl(model);
	}	
	
	public User createUser (WLMModel model) {
		return new UserImpl(model);
	}		
	
	public Group createGroup (WLMModel model) {
		return new GroupImpl(model);
	}
	
	public Role createRole (WLMModel model) {
		return new RoleImpl (model);
	}	
	public TTimeout createTimeout (WLMModel model) {
		return new TimeoutImpl (model);
	}		
	public TDeadlineExpr createDeadline (WLMModel model) {
		return new DeadlineImpl (model);
	}		
	public TDurationExpr createDuration (WLMModel model) {
		return new DurationImpl (model);
	}		
	
	public TEscalation createEscalation (WLMModel model) {
		return new EscalationImpl (model);
	}		
	
	public TNotification createNotification (WLMModel model) {
		return new NotificationImpl (model);
	}		
	
	public TAction createAction (WLMModel model) {
		return new ActionImpl (model);
	}		
	public TRecipient createRecipient (WLMModel model) {
		return new RecipientImpl (model);
	}			
	public TAddress createAddress (WLMModel model) {
		return new AddressImpl (model);
	}	
}
