/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */

package org.netbeans.modules.j2ee.refactoring.moveclass;

import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.jmi.reflect.RefObject;
import org.netbeans.api.java.project.JavaProjectConstants;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.j2ee.dd.api.web.Filter;
import org.netbeans.modules.j2ee.dd.api.web.Listener;
import org.netbeans.modules.j2ee.dd.api.web.Servlet;
import org.netbeans.modules.j2ee.dd.api.web.WebApp;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.modules.j2ee.dd.api.webservices.PortComponent;
import org.netbeans.modules.j2ee.dd.api.webservices.PortComponentHandler;
import org.netbeans.modules.j2ee.dd.api.webservices.WebserviceDescription;
import org.netbeans.modules.j2ee.dd.api.webservices.Webservices;
import org.netbeans.modules.j2ee.refactoring.Utility;
import org.netbeans.modules.javacore.api.JavaModel;
import org.netbeans.modules.javacore.internalapi.ExternalChange;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.netbeans.modules.refactoring.api.MoveClassRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.api.RefactoringElement;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.netbeans.modules.refactoring.spi.RefactoringElementImplementation;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.websvc.api.webservices.WebServicesSupport;
import org.netbeans.modules.websvc.spi.webservices.WebServicesConstants;
import org.netbeans.modules.websvc.wsdl.WsCompileConfigDataObject;
import org.netbeans.modules.websvc.wsdl.config.api.Configuration;
import org.netbeans.modules.websvc.wsdl.xmlutils.XMLJ2eeDataObject;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.NbBundle;

/**
 *
 * @author Martin Grebac
 */
public final class WebservicesXmlMoveClassRefactoring {
    
    private static final ErrorManager err = ErrorManager.getDefault().getInstance("org.netbeans.modules.j2ee.refactoring.rename");   // NOI18N
    
    public WebservicesXmlMoveClassRefactoring() { }
    
    /** Find usages in web deployment descriptor: web.xml
     */
    public Problem prepare(MoveClassRefactoring moveClassRefactor, Collection resources, RefactoringElementsBag refactoringElements) {
        
        Problem problem = null;
        
        for (Iterator i = resources.iterator(); i.hasNext();) {
            
            boolean isSEIMove = false;
            
            Resource resource = (Resource) i.next();
            FileObject fo = JavaModel.getFileObject(resource);
            
            err.log("resource package name:  " + resource.getPackageName());
            err.log("resource: name " + resource.getName());
            WebServicesSupport wsm = WebServicesSupport.getWebServicesSupport(fo);
            if (wsm != null) {              // the class is in a module with web services support
                
                FileObject webservicesXmlFO = wsm.getWebservicesDD();
                Webservices webservicesXmlDD = null;
                try {
                    webservicesXmlDD = org.netbeans.modules.j2ee.dd.api.webservices.DDProvider.getDefault().getDDRoot(webservicesXmlFO);
                } catch (IOException ioe) {
                    // ignore
                }
                
                if ((webservicesXmlDD != null) && (webservicesXmlDD.getStatus()!=Webservices.STATE_INVALID_UNPARSABLE)) {
                    List classes = resource.getClassifiers();
                    err.log("Classes in resource: " + classes);
                    
                    for (int j=0; j < classes.size(); j++ ) {
                        JavaClass jClass = (JavaClass)classes.get(j);
                        err.log("javaclass: "+ jClass);
                        
                        String name = jClass.getName();
                        err.log("name: " + name);
                        
                        String oldPackage = name.substring(0, name.lastIndexOf('.'));
                        err.log("oldPackage: " + oldPackage);
                        
                        String targetPackage = moveClassRefactor.getTargetPackageName(resource);
                        err.log("targetPackage: " + targetPackage);
                        
                        String newName = targetPackage + "." + jClass.getSimpleName();
                        err.log("newname: " + newName);
                        
                        WebserviceDescription[] wservices = webservicesXmlDD.getWebserviceDescription();
                        err.log("Web Services: " + wservices);
                        if ((wservices != null) && (wservices.length > 0)) {
                            for (int w=0; w < wservices.length; w++) {
                                WebserviceDescription webService = (WebserviceDescription)wservices[w];
                                err.log("Web Service: " + webService);
                                
                                /* And update the actual web service reference direct in webservices.xml */
                                PortComponent[] ports = webService.getPortComponent();
                                err.log("Ports: " + ports);
                                if ((ports != null) && (ports.length > 0)) {
                                    for (int p=0; p < ports.length; p++) {
                                        
                                        /* First check for presence in webservices.xml port */
                                        PortComponent portComponent = (PortComponent)ports[p];
                                        err.log("Port Component: " + portComponent);
                                        String serviceEndpointInterface = portComponent.getServiceEndpointInterface();
                                        err.log("serviceEndpointInterface: " + serviceEndpointInterface);
                                        
                                        PortComponentHandler[] handlers = portComponent.getHandler();
                                        for (int k = 0; k < handlers.length; k++) {
                                            if (name.equals(handlers[k].getHandlerClass())){
                                                RefactoringElementImplementation elem = new WebservicesHandlerMoveClassRefactoringElement(webservicesXmlDD, name, newName, handlers[k], webservicesXmlFO);
                                                refactoringElements.add(moveClassRefactor, elem);
                                            }
                                        }
                                        
                                        if ((serviceEndpointInterface != null) && (serviceEndpointInterface.equals(name))) {
                                            isSEIMove = true;
                                            RefactoringElementImplementation elem = new WebservicesSEIMoveClassRefactoringElement(webservicesXmlDD, name, newName, portComponent, webservicesXmlFO);
                                            refactoringElements.add(moveClassRefactor, elem);
                                        }
                                        
                                        /* try to locate the local wscompile config file:
                                         *   get project for webservices.xml, get name of the webservice and try to find properties of the type
                                         *   $propertyname-config.name - if found, get the property value and the path and locate the descriptor,
                                         *   then get the dd api descriptor object
                                         */
                                        String portName = portComponent.getPortComponentName();
                                        Project project = FileOwnerQuery.getOwner(webservicesXmlFO);
                                        err.log("Project: " + project);
                                        Map properties = wsm.getAntProjectHelper().getStandardPropertyEvaluator().getProperties();
                                        if (err.isLoggable(ErrorManager.INFORMATIONAL)) {
                                            err.log("Properties: " + properties);
                                        }
                                        String propertyName = portName + WebServicesConstants.CONFIG_PROP_SUFFIX;
                                        err.log("Property name: " + propertyName);
                                        String propertyValue = (String)properties.get(propertyName);
                                        err.log("Property value: " + propertyValue);
                                        if (propertyValue != null) { // there's such property in the project
                                            FileObject wsConfigXmlFO = null;
                                            
                                            File f = new File(propertyValue);
                                            if (f.isAbsolute()) {
                                                wsConfigXmlFO = FileUtil.toFileObject(f);
                                            } else {
                                                wsConfigXmlFO = project.getProjectDirectory().getFileObject(propertyValue);
                                            }
                                            if (wsConfigXmlFO != null) {
                                                Configuration wsConfigXmlDD = null;
                                                try {
                                                    wsConfigXmlDD = org.netbeans.modules.websvc.wsdl.config.api.DDProvider.getDefault().getDDRoot(wsConfigXmlFO);
                                                } catch (IOException ioe) {
                                                    //ignore
                                                }
                                                DataObject data = null;
                                                try {
                                                    data = DataObject.find(wsConfigXmlFO);
                                                } catch (DataObjectNotFoundException notfoundexc) {
                                                    //ignore
                                                }
                                                err.log("DataObject: " + data);
                                                if ((data != null) && (wsConfigXmlDD != null)) /*&& (wsConfigXmlDD.getStatus()!=Webservices.STATE_INVALID_UNPARSABLE)*/ {
                                                    org.netbeans.modules.websvc.wsdl.config.api.Service service = wsConfigXmlDD.getService();
                                                    if (service != null) {
                                                        String packageName = service.getPackageName();
                                                        err.log("Package name: " + packageName);
                                                        if ((packageName != null) && (packageName.equals(oldPackage))) {
                                                            if  (isSEIMove) {
                                                                if (!isConfigXmlAlreadyMoved(refactoringElements, wsConfigXmlFO)) {
                                                                    RefactoringElementImplementation elemFile = new WebservicesConfigXmlMoveClassRefactoringElement(data, moveClassRefactor.getTargetClassPathRoot(), moveClassRefactor.getTargetPackageName(fo));
                                                                    refactoringElements.add(moveClassRefactor, elemFile);
                                                                }
                                                                RefactoringElementImplementation elemPkg = new WebservicesConfigXmlPackageMoveClassRefactoringElement(data, jClass.getResource().getPackageName(), targetPackage);
                                                                refactoringElements.add(moveClassRefactor, elemPkg);
                                                                targetPackage = targetPackage.replace('.', '/');
                                                                
                                                                Sources srcs = ProjectUtils.getSources(project);
                                                                if (srcs != null) {
                                                                    SourceGroup[] sourceGroups = srcs.getSourceGroups(JavaProjectConstants.SOURCES_TYPE_JAVA);
                                                                    SourceGroup srcGroup = null;
                                                                    boolean found = false;
                                                                    for (int k=0; k < sourceGroups.length; k++) {
                                                                        srcGroup = sourceGroups[k];
                                                                        if (FileUtil.isParentOf(srcGroup.getRootFolder(), wsConfigXmlFO)) {
                                                                            found = true;
                                                                            break;
                                                                        }
                                                                    }
                                                                    if (found) {
                                                                        String relativePath = FileUtil.getRelativePath(srcGroup.getRootFolder(), wsConfigXmlFO);
                                                                        int index = propertyValue.indexOf(relativePath);
                                                                        String newValue = propertyValue.substring(0, 9) +
                                                                                propertyValue.substring(index, propertyValue.length()).replaceFirst(packageName, targetPackage);
                                                                        
                                                                        err.log("newvalue: " + newValue);
                                                                        err.log("moving SEI, so move the config xml file with it, too");
                                                                        RefactoringElementImplementation elem2 = new WebservicesProjectMoveClassRefactoringElement(data, wsm.getAntProjectHelper(), propertyName, propertyValue, newValue, targetPackage);
                                                                        refactoringElements.add(moveClassRefactor, elem2);
                                                                    }
                                                                }
                                                            }
                                                        }
                                                        org.netbeans.modules.websvc.wsdl.config.api.Interface[] interfaces = service.getInterface();
                                                        if ((interfaces != null) && (interfaces.length > 0)) {
                                                            for (int ii=0; ii < interfaces.length; ii++) {
                                                                org.netbeans.modules.websvc.wsdl.config.api.Interface iface = interfaces[ii];
                                                                String servant = iface.getServantName();
                                                                String iname = iface.getName();
                                                                err.log("Servant: " + servant);
                                                                err.log("Interface: " + iname);
                                                                if ((servant != null) && (servant.equals(name))) {
                                                                    RefactoringElementImplementation elem = new WebservicesConfigXmlServantMoveClassRefactoringElement(data, name, newName);
                                                                    refactoringElements.add(moveClassRefactor, elem);
                                                                }
                                                                if ((iname != null) && (iname.equals(name))) {
                                                                    RefactoringElementImplementation elem = new WebservicesConfigXmlInterfaceMoveClassRefactoringElement(data, name, newName);
                                                                    refactoringElements.add(moveClassRefactor, elem);
                                                                }
                                                            }
                                                        }
                                                    }
                                                } else {
                                                    Object[] args = new Object [] {wsConfigXmlFO.getPath()};
                                                    String msg = MessageFormat.format(NbBundle.getMessage(WebservicesXmlMoveClassRefactoring.class, "TXT_WebservicesConfigXmlMoveClassInvalidProblem"), args);
                                                    Problem newProblem = new Problem(false, msg);
                                                    problem = Utility.addProblemsToEnd(problem, newProblem);
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                } else if (webservicesXmlDD != null) {
                    Problem newProblem = new Problem(false, NbBundle.getMessage(WebservicesXmlMoveClassRefactoring.class, "TXT_WebservicesXmlMoveClassInvalidProblem"));
                    if (problem == null) {
                        problem = newProblem;
                    } else {
                        if (newProblem != null) problem.setNext(newProblem);
                    }
                }
            }
        } // refactor webservices.xml
        return problem;
    }
    
    private boolean isConfigXmlAlreadyMoved(RefactoringElementsBag refactoringElements, FileObject file) {
        Collection c = refactoringElements.getSession().getRefactoringElements();
        Iterator refElems = c.iterator();
        while (refElems.hasNext()) {
            RefactoringElement refElem = (RefactoringElement)refElems.next();
            FileObject f = refElem.getParentFile();
            if (f != null) {
                DataObject d=null;
                try {
                    d = DataObject.find(f);
                } catch (Exception e) {
                    
                }
                if ( (d!=null) && (d instanceof WsCompileConfigDataObject)) {
                    return file.equals(((WsCompileConfigDataObject)d).getPrimaryFile());
                }
            }
        }
        return false;
    }
    
    public final class WebservicesSEIMoveClassRefactoringElement extends AbstractMoveClassRefactoringElement implements ExternalChange {
        
        protected Webservices webservicesXmlDD;
        private PortComponent pc;
        
        /** Creates a new instance of WebservicesSEIMoveClassRefactoringElement */
        public WebservicesSEIMoveClassRefactoringElement(Webservices webservicesXmlDD, String oldName, String newName, PortComponent pc, FileObject parentFile) {
            this.webservicesXmlDD = webservicesXmlDD;
            this.pc = pc;
            this.oldName = oldName;
            this.newName = newName;
            this.parentFile = parentFile;
        }
        
        /** Returns text describing the refactoring formatted for display (using HTML tags).
         * @return Formatted text.
         */
        public String getDisplayText() {
            Object[] args = new Object [] {parentFile.getNameExt(), oldName, newName};
            return MessageFormat.format(NbBundle.getMessage(WebservicesXmlMoveClassRefactoring.class, "TXT_WebservicesXmlSEIMoveClass"), args);
        }
        
        /** Performs the change represented by this refactoring element.
         */
        public void performChange() {
            JavaMetamodel.getManager().registerExtChange(this);
        }
        
        public void performExternalChange() {
            if (pc != null) {
                pc.setServiceEndpointInterface(newName);
                try {
                    webservicesXmlDD.write(parentFile);
                } catch (IOException ioe) {
                    //TODO
                }
            }
        }
        
        public void undoExternalChange() {
            if (pc != null) {
                pc.setServiceEndpointInterface(oldName);
                try {
                    webservicesXmlDD.write(parentFile);
                } catch (IOException ioe) {
                    //TODO
                }
            }
        }
    }
    
    /**
     * Refactoring element for message handler.
     */
    public final class WebservicesHandlerMoveClassRefactoringElement extends AbstractMoveClassRefactoringElement implements ExternalChange {
        
        protected Webservices webservicesXmlDD;
        private PortComponentHandler handler;
        
        public WebservicesHandlerMoveClassRefactoringElement(Webservices webservicesXmlDD, String oldName, String newName, PortComponentHandler handler, FileObject parentFile) {
            this.webservicesXmlDD = webservicesXmlDD;
            this.handler = handler;
            this.oldName = oldName;
            this.newName = newName;
            this.parentFile = parentFile;
        }
        
        public String getDisplayText() {
            Object[] args = new Object [] {parentFile.getNameExt(), oldName, newName};
            return MessageFormat.format(NbBundle.getMessage(WebservicesXmlMoveClassRefactoring.class, "TXT_WebservicesXmlHandlerMoveClass"), args);
        }
        
        public void performChange() {
            JavaMetamodel.getManager().registerExtChange(this);
        }
        
        public void performExternalChange() {
            handler.setHandlerClass(newName);
            write();
        }
        
        public void undoExternalChange() {
            handler.setHandlerClass(oldName);
            write();
        }
        
        private void write(){
            try {
                webservicesXmlDD.write(parentFile);
            } catch (IOException ioe) {
                ErrorManager.getDefault().notify(ioe);
            }
        }
    }
    
    public final class WebservicesConfigXmlPackageMoveClassRefactoringElement extends AbstractMoveClassRefactoringElement implements ExternalChange {
        
        private DataObject data = null;
        
        /** Creates a new instance of WebservicesConfigXmlPackageMoveClassRefactoringElement */
        public WebservicesConfigXmlPackageMoveClassRefactoringElement(DataObject data, String oldName, String newName) {
            this.data = data;
            this.oldName = oldName;
            this.newName = newName;
        }
        
        /** Returns text describing the refactoring formatted for display (using HTML tags).
         * @return Formatted text.
         */
        public String getDisplayText() {
            Object[] args = new Object [] {data.getPrimaryFile(), oldName, newName};
            return MessageFormat.format(NbBundle.getMessage(WebservicesXmlMoveClassRefactoring.class, "TXT_WebservicesConfigXmlPackageMoveClass"), args);
        }
        
        /** Returns file that the element affects (relates to)
         * @return File
         */
        public FileObject getParentFile() {
            if (data != null) {
                return data.getPrimaryFile();
            }
            return null;
        }
        
        /** Performs the change represented by this refactoring element.
         */
        public void performChange() {
            JavaMetamodel.getManager().registerExtChange(this);
        }
        
        public void performExternalChange() {
            if (data != null) {
                FileObject wsConfigXmlFO = data.getPrimaryFile();
                Configuration wsConfigXmlDD = null;
                try {
                    wsConfigXmlDD = org.netbeans.modules.websvc.wsdl.config.api.DDProvider.getDefault().getDDRoot(wsConfigXmlFO);
                } catch (IOException ioe) {
                    //ignore
                }
                if (wsConfigXmlDD != null) /* TODO check validity */ {
                    org.netbeans.modules.websvc.wsdl.config.api.Service service = wsConfigXmlDD.getService();
                    if (service != null) {
                        service.setPackageName(newName);
                        try {
                            wsConfigXmlDD.write(wsConfigXmlFO);
                        } catch (IOException ioe) {
                            //TODO
                        }
                    }
                }
            }
        }
        
        public void undoExternalChange() {
            if (data != null) {
                FileObject wsConfigXmlFO = data.getPrimaryFile();
                Configuration wsConfigXmlDD = null;
                try {
                    wsConfigXmlDD = org.netbeans.modules.websvc.wsdl.config.api.DDProvider.getDefault().getDDRoot(wsConfigXmlFO);
                } catch (IOException ioe) {
                    //ignore
                }
                if (wsConfigXmlDD != null) /* TODO check validity */ {
                    org.netbeans.modules.websvc.wsdl.config.api.Service service = wsConfigXmlDD.getService();
                    if (service != null) {
                        service.setPackageName(oldName);
                        try {
                            wsConfigXmlDD.write(wsConfigXmlFO);
                        } catch (IOException ioe) {
                            //TODO
                        }
                    }
                }
            }
        }
    }
    
    public final class WebservicesConfigXmlMoveClassRefactoringElement extends AbstractMoveClassRefactoringElement implements ExternalChange {
        
        private DataObject data = null;
        private FileObject target = null;
        private FileObject originalFolder = null;
        private String targetPackageName;
        
        /** Creates a new instance of WebservicesConfigXmlPackageMoveClassRefactoringElement */
        public WebservicesConfigXmlMoveClassRefactoringElement(DataObject data, FileObject targetClassPathRoot, String targetPackageName) {
            this.data = data;
            this.target = targetClassPathRoot;
            this.originalFolder = data.getPrimaryFile().getParent();
            this.targetPackageName = targetPackageName;
        }
        
        /** Returns text describing the refactoring formatted for display (using HTML tags).
         * @return Formatted text.
         */
        public String getDisplayText() {
            Object[] args = new Object [] {data.getPrimaryFile().getNameExt(), target.getPath() + "/" + targetPackageName.replace('.','/')}; //NOI18N
            return MessageFormat.format(NbBundle.getMessage(WebservicesXmlMoveClassRefactoring.class, "TXT_WebservicesConfigXmlMoveClass"), args);
        }
        
        /** Returns file that the element affects (relates to)
         * @return File
         */
        public FileObject getParentFile() {
            if (data != null) {
                return data.getPrimaryFile();
            }
            return null;
        }
        
        /** Performs the change represented by this refactoring element.
         */
        public void performChange() {
            JavaMetamodel.getManager().registerExtChange(this);
        }
        
        public void performExternalChange() {
            if (data != null) {
                try {
                    DataFolder folder = DataFolder.findFolder(FileUtil.createFolder(target, targetPackageName.replace('.','/')));
                    data.move(folder);
                } catch (IOException ioe) {
                    ErrorManager.getDefault().log(ErrorManager.INFORMATIONAL, "Could not move file: " + ioe);
                }
            }
        }
        
        public void undoExternalChange() {
            if (data != null) {
                DataFolder folder = DataFolder.findFolder(originalFolder);
                try {
                    data.move(folder);
                } catch (IOException ioe) {
                    ErrorManager.getDefault().log(ErrorManager.INFORMATIONAL, "Could not undo move file: " + ioe);
                }
            }
        }
    }
    
    public final class WebservicesConfigXmlServantMoveClassRefactoringElement extends AbstractMoveClassRefactoringElement implements ExternalChange {
        
        private DataObject data = null;
        
        /** Creates a new instance of WebservicesConfigXmlServantMoveClassRefactoringElement */
        public WebservicesConfigXmlServantMoveClassRefactoringElement(DataObject data, String oldName, String newName) {
            this.oldName = oldName;
            this.newName = newName;
            this.data = data;
        }
        
        /** Returns text describing the refactoring formatted for display (using HTML tags).
         * @return Formatted text.
         */
        public String getDisplayText() {
            Object[] args = new Object [] {data.getPrimaryFile(), oldName, newName};
            return MessageFormat.format(NbBundle.getMessage(WebservicesXmlMoveClassRefactoring.class, "TXT_WebservicesConfigXmlServantMoveClass"), args);
        }
        
        /** Performs the change represented by this refactoring element.
         */
        public void performChange() {
            JavaMetamodel.getManager().registerExtChange(this);
        }
        
        /** Returns file that the element affects (relates to)
         * @return File
         */
        public FileObject getParentFile() {
            if (data != null) {
                return data.getPrimaryFile();
            }
            return null;
        }
        
        public void performExternalChange() {
            if (data != null) {
                FileObject wsConfigXmlFO = data.getPrimaryFile();
                Configuration wsConfigXmlDD = null;
                try {
                    wsConfigXmlDD = org.netbeans.modules.websvc.wsdl.config.api.DDProvider.getDefault().getDDRoot(wsConfigXmlFO);
                } catch (IOException ioe) {
                    //ignore
                }
                if (wsConfigXmlDD != null) /* TODO check validity */ {
                    err.log("perform external change: WebservicesConfigXmlServantMoveClassRefactoringElement");
                    org.netbeans.modules.websvc.wsdl.config.api.Service service = wsConfigXmlDD.getService();
                    org.netbeans.modules.websvc.wsdl.config.api.Interface[] interfaces = service.getInterface();
                    err.log("Interfaces: " + interfaces);
                    if ((interfaces != null) && (interfaces.length > 0)) {
                        for (int ii=0; ii < interfaces.length; ii++) {
                            org.netbeans.modules.websvc.wsdl.config.api.Interface iface = interfaces[ii];
                            String servant = iface.getServantName();
                            err.log("Servant: " + servant);
                            if ((servant != null) && (servant.equals(oldName))) {
                                iface.setServantName(newName);
                            }
                        }
                        try {
                            wsConfigXmlDD.write(wsConfigXmlFO);
                        } catch (IOException ioe) {
                            //TODO
                        }
                    }
                }
            }
        }
        
        public void undoExternalChange() {
            if (data != null) {
                FileObject wsConfigXmlFO = data.getPrimaryFile();
                Configuration wsConfigXmlDD = null;
                try {
                    wsConfigXmlDD = org.netbeans.modules.websvc.wsdl.config.api.DDProvider.getDefault().getDDRoot(wsConfigXmlFO);
                } catch (IOException ioe) {
                    //ignore
                }
                if (wsConfigXmlDD != null) /* TODO check validity */ {
                    err.log("undo external change: WebservicesConfigXmlServantMoveClassRefactoringElement");
                    org.netbeans.modules.websvc.wsdl.config.api.Service service = wsConfigXmlDD.getService();
                    org.netbeans.modules.websvc.wsdl.config.api.Interface[] interfaces = service.getInterface();
                    err.log("Interfaces: " + interfaces);
                    if ((interfaces != null) && (interfaces.length > 0)) {
                        for (int ii=0; ii < interfaces.length; ii++) {
                            org.netbeans.modules.websvc.wsdl.config.api.Interface iface = interfaces[ii];
                            String servant = iface.getServantName();
                            err.log("Servant: " + servant);
                            if ((servant != null) && (servant.equals(newName))) {
                                iface.setServantName(oldName);
                            }
                        }
                        try {
                            wsConfigXmlDD.write(wsConfigXmlFO);
                        } catch (IOException ioe) {
                            //TODO
                        }
                    }
                }
            }
        }
    }
    
    public final class WebservicesConfigXmlInterfaceMoveClassRefactoringElement extends AbstractMoveClassRefactoringElement implements ExternalChange {
        
        private DataObject data = null;
        
        /** Creates a new instance of WebservicesConfigXmlInterfaceMoveClassRefactoringElement */
        public WebservicesConfigXmlInterfaceMoveClassRefactoringElement(DataObject data, String oldName, String newName) {
            this.oldName = oldName;
            this.newName = newName;
            this.data = data;
        }
        
        /** Returns text describing the refactoring formatted for display (using HTML tags).
         * @return Formatted text.
         */
        public String getDisplayText() {
            Object[] args = new Object [] {data.getPrimaryFile(), oldName, newName};
            return MessageFormat.format(NbBundle.getMessage(WebservicesXmlMoveClassRefactoring.class, "TXT_WebservicesConfigXmlInterfaceMoveClass"), args);
        }
        
        /** Returns file that the element affects (relates to)
         * @return File
         */
        public FileObject getParentFile() {
            if (data != null) {
                return data.getPrimaryFile();
            }
            return null;
        }
        
        /** Performs the change represented by this refactoring element.
         */
        public void performChange() {
            JavaMetamodel.getManager().registerExtChange(this);
        }
        
        public void performExternalChange() {
            if (data != null) {
                FileObject wsConfigXmlFO = data.getPrimaryFile();
                Configuration wsConfigXmlDD = null;
                try {
                    wsConfigXmlDD = org.netbeans.modules.websvc.wsdl.config.api.DDProvider.getDefault().getDDRoot(wsConfigXmlFO);
                } catch (IOException ioe) {
                    //ignore
                }
                if (wsConfigXmlDD != null) /* TODO check validity */ {
                    err.log("perform external change: WebservicesConfigXmlInterfaceMoveClassRefactoringElement");
                    org.netbeans.modules.websvc.wsdl.config.api.Service service = wsConfigXmlDD.getService();
                    org.netbeans.modules.websvc.wsdl.config.api.Interface[] interfaces = service.getInterface();
                    err.log("Interfaces: " + interfaces);
                    if ((interfaces != null) && (interfaces.length > 0)) {
                        for (int ii=0; ii < interfaces.length; ii++) {
                            org.netbeans.modules.websvc.wsdl.config.api.Interface iface = interfaces[ii];
                            String interf = iface.getName();
                            err.log("Interface: " + interf);
                            if ((interf != null) && (interf.equals(oldName))) {
                                iface.setName(newName);
                            }
                        }
                        try {
                            wsConfigXmlDD.write(wsConfigXmlFO);
                        } catch (IOException ioe) {
                            //TODO
                        }
                    }
                }
            }
        }
        
        public void undoExternalChange() {
            if (data != null) {
                FileObject wsConfigXmlFO = data.getPrimaryFile();
                Configuration wsConfigXmlDD = null;
                try {
                    wsConfigXmlDD = org.netbeans.modules.websvc.wsdl.config.api.DDProvider.getDefault().getDDRoot(wsConfigXmlFO);
                } catch (IOException ioe) {
                    //ignore
                }
                if (wsConfigXmlDD != null) /* TODO check validity */ {
                    err.log("undo external change: WebservicesConfigXmlInterfaceMoveClassRefactoringElement");
                    org.netbeans.modules.websvc.wsdl.config.api.Service service = wsConfigXmlDD.getService();
                    org.netbeans.modules.websvc.wsdl.config.api.Interface[] interfaces = service.getInterface();
                    err.log("Interfaces: " + interfaces);
                    if ((interfaces != null) && (interfaces.length > 0)) {
                        for (int ii=0; ii < interfaces.length; ii++) {
                            org.netbeans.modules.websvc.wsdl.config.api.Interface iface = interfaces[ii];
                            String interf = iface.getName();
                            err.log("Interface: " + interf);
                            if ((interf != null) && (interf.equals(newName))) {
                                iface.setName(oldName);
                            }
                        }
                        try {
                            wsConfigXmlDD.write(wsConfigXmlFO);
                        } catch (IOException ioe) {
                            //TODO
                        }
                    }
                }
            }
        }
    }
    
    public final class WebservicesProjectMoveClassRefactoringElement extends AbstractMoveClassRefactoringElement implements ExternalChange {
        
        private DataObject data = null;
        private AntProjectHelper helper;
        private String propertyName;
        private String propertyValue;
        private String targetPackage;
        private String newValue;
        
        /** Creates a new instance of WebservicesProjectMoveClassRefactoringElement */
        public WebservicesProjectMoveClassRefactoringElement(DataObject data, AntProjectHelper helper, String propertyName, String propertyValue, String newValue, String targetPackage) {
            this.propertyName = propertyName;
            this.propertyValue = propertyValue;
            this.targetPackage = targetPackage;
            this.data = data;
            this.newValue = newValue;
            this.helper = helper;
        }
        
        /** Returns file that the element affects (relates to)
         * @return File
         */
        public FileObject getParentFile() {
            if (data != null) {
                return data.getPrimaryFile();
            }
            return null;
        }
        
        /** Returns text describing the refactoring formatted for display (using HTML tags).
         * @return Formatted text.
         */
        public String getDisplayText() {
            Object[] args = new Object [] {propertyName, propertyValue, newValue};
            return MessageFormat.format(NbBundle.getMessage(WebservicesXmlMoveClassRefactoring.class, "TXT_WebservicesProjectMoveClass"), args);
        }
        
        /** Performs the change represented by this refactoring element.
         */
        public void performChange() {
            JavaMetamodel.getManager().registerExtChange(this);
        }
        
        public void performExternalChange() {
            EditableProperties ep = helper.getProperties(AntProjectHelper.PROJECT_PROPERTIES_PATH);
            if (data != null) {
                ep.setProperty(propertyName, newValue);
            }
            helper.putProperties(AntProjectHelper.PROJECT_PROPERTIES_PATH, ep);
            Project project = null;
            try {
                project = ProjectManager.getDefault().findProject(helper.getProjectDirectory());
                ProjectManager.getDefault().saveProject(project);
            } catch (IOException ioe) { // do nothing
            }
        }
        
        public void undoExternalChange() {
            if (data != null) {
            }
        }
    }
    
}
