/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */

package org.netbeans.modules.j2ee.refactoring.safedelete;

import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.api.SafeDeleteRefactoring;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.netbeans.modules.j2ee.refactoring.Utility;
import org.netbeans.modules.j2ee.dd.api.ejb.Ejb;
import org.netbeans.modules.j2ee.dd.api.ejb.EntityAndSession;
import org.netbeans.modules.javacore.internalapi.ExternalChange;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.UnresolvedClass;
import org.netbeans.jmi.javamodel.Element;
import org.openide.util.NbBundle;

import java.util.List;
import java.util.LinkedList;

/**
 * @author pfiala
 */
public class EjbClassSafeDeleteRefactoring extends BaseRefactoring {
    private final Ejb ejb;
    private JavaClass javaClass;
    private boolean removeLocal;
    private boolean removeRemote;

    public EjbClassSafeDeleteRefactoring(EjbHelper helper, Ejb ejb, JavaClass javaClass) {
        super(helper);
        this.ejb = ejb;
        this.javaClass = javaClass;
    }

    protected Problem preCheckThis() {
        removeLocal = false;
        removeRemote = false;
        final String ejbName = ejb.getEjbName();
        if (isEqualClass(ejb.getEjbClass(), javaClass)) {
            return new Problem(false, NbBundle.getMessage(EjbClassSafeDeleteRefactoring.class,
                    "TXT_EjbJarBeanClassSafeDelete", javaClass.getName(), ejbName));  //NOI18N
        } else if (ejb instanceof EntityAndSession) {
            final EntityAndSession entityAndSession = ((EntityAndSession) ejb);
            final JavaClass localHome = Utility.resolveClass(entityAndSession.getLocalHome());
            final JavaClass local = Utility.resolveClass(entityAndSession.getLocal());
            final JavaClass home = Utility.resolveClass(entityAndSession.getHome());
            final JavaClass remote = Utility.resolveClass(entityAndSession.getRemote());
            if (javaClass.equals(localHome)) {
                return new Problem(false, NbBundle.getMessage(EjbClassSafeDeleteRefactoring.class,
                        "TXT_EjbJarInterfaceClassSafeDelete", javaClass.getName(), ejbName));  //NOI18N
                // todo: Seek how to remove multiple classes. Now it does not work properly,
                // so we do not support safe delete of bean interfaces
//                removeLocal = true;
//                addChildRefactoring(local);
            } else if (javaClass.equals(local)) {
                return new Problem(false, NbBundle.getMessage(EjbClassSafeDeleteRefactoring.class,
                        "TXT_EjbJarInterfaceClassSafeDelete", javaClass.getName(), ejbName));  //NOI18N
//                removeLocal = true;
//                addChildRefactoring(localHome);
            } else if (javaClass.equals(home)) {
                return new Problem(false, NbBundle.getMessage(EjbClassSafeDeleteRefactoring.class,
                        "TXT_EjbJarInterfaceClassSafeDelete", javaClass.getName(), ejbName));  //NOI18N
//                removeRemote = true;
//                addChildRefactoring(remote);
            } else if (javaClass.equals(remote)) {
                return new Problem(false, NbBundle.getMessage(EjbClassSafeDeleteRefactoring.class,
                        "TXT_EjbJarInterfaceClassSafeDelete", javaClass.getName(), ejbName));  //NOI18N
//                removeRemote = true;
//                addChildRefactoring(home);
            }
            if (removeLocal) {
                addChildRefactoring(getBusinessInterface(entityAndSession.getLocal()));
                String msg = NbBundle.getMessage(EjbClassSafeDeleteRefactoring.class,
                        "TXT_EjbJarLocalInterfacesSafeDelete", ejbName);
                return new Problem(false, msg);
            } else if (removeRemote) {
                addChildRefactoring(getBusinessInterface(entityAndSession.getRemote()));
                String msg = NbBundle.getMessage(EjbClassSafeDeleteRefactoring.class,
                        "TXT_EjbJarRemoteInterfacesSafeDelete", ejbName); //NOI18N
                return new Problem(false, msg);
            }
        }
        return null;
    }

    private JavaClass getBusinessInterface(String compInterfaceName) {
        JavaClass compInterface = Utility.resolveClass(compInterfaceName);
        JavaClass beanClass = Utility.resolveClass((ejb.getEjbClass()));
        if (compInterface == null || beanClass == null) {
            return null;
        }
        // get method interfaces
        List/*<JavaClass>*/ compInterfaces = new LinkedList(compInterface.getInterfaces());
        // intersection with bean interfaces
        compInterfaces.retainAll(beanClass.getInterfaces());
        return !compInterfaces.isEmpty() ? Utility.resolveClass(((JavaClass) compInterfaces.get(0)).getName()): null;
    }


    protected Problem prepareThis(RefactoringElementsBag refactoringElementsBag) {
        if (removeLocal) {
            helper.addRefactoringElement(refactoringElementsBag, new EjbJarRefactoringElement(true));
        } else if (removeRemote) {
            helper.addRefactoringElement(refactoringElementsBag, new EjbJarRefactoringElement(false));
        }
        return null;
    }

    private void addChildRefactoring(JavaClass javaClass) {
        if (javaClass!= null && !(javaClass instanceof UnresolvedClass)) {
            addChildRefactoring(new SafeDeleteRefactoring(new Element[]{javaClass}));
        }
    }

    private static boolean isEqualClass(String className, JavaClass javaClass) {
        return Utility.resolveClass(className).equals(javaClass);
    }

    public final class EjbJarRefactoringElement extends AbstractSafeDeleteRefactoringElement implements ExternalChange {
        private final boolean local;
        private EntityAndSession entityAndSession;
        private String homeInterface;
        private String componentInterface;

        public EjbJarRefactoringElement(boolean local) {
            super(helper.getFileObject());
            this.local = local;
            entityAndSession = ((EntityAndSession) ejb);
            homeInterface = local ? entityAndSession.getLocalHome() : entityAndSession.getHome();
            componentInterface = local ? entityAndSession.getLocal() : entityAndSession.getRemote();
        }

        /**
         * Returns text describing the refactoring formatted for display (using HTML tags).
         *
         * @return Formatted text.
         */
        public String getDisplayText() {
            final String resName = local ? "TXT_EjbJarLocalInterfacesSafeDeleteDisplayText" :
                    "TXT_EjbJarRemoteInterfacesSafeDeleteDisplayText";  //NOI18N
            return NbBundle.getMessage(EjbClassSafeDeleteRefactoring.class, resName);
        }

        /**
         * Performs the change represented by this refactoring element.
         */
        public void performChange() {
            JavaMetamodel.getManager().registerExtChange(this);
        }

        public void performExternalChange() {
            if (local) {
                entityAndSession.setLocalHome(null);
                entityAndSession.setLocal(null);
            } else {
                entityAndSession.setHome(null);
                entityAndSession.setRemote(null);
            }
            helper.writeDD();
        }

        public void undoExternalChange() {
            if (local) {
                entityAndSession.setLocalHome(homeInterface);
                entityAndSession.setLocal(componentInterface);
            } else {
                entityAndSession.setHome(homeInterface);
                entityAndSession.setRemote(componentInterface);
            }
            helper.writeDD();
        }
    }
}
