/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Ralph Krueger.
 */

package org.netbeans.modules.changelog.settings;

import org.openide.options.*;
import org.openide.util.*;

/** Options for changelog module
*
* @author Ralph krueger
*/
public class ChangeLogSettings extends SystemOption {

    public static final String PROP_DEFAULT_SERVER = "defaultServerInfo"; // NOI18N

    public static final String PROP_SHOW_BRANCHES = "showBranchesByDefault"; //NOI18N

    static final long serialVersionUID = -1563396366224442828L;

    public ChangeLogSettings() {
        setDefaultServerInfo("");
        setShowBranchesByDefault(false);
    }


    /** human presentable name */
    public String displayName() {
        return NbBundle.getBundle(ChangeLogSettings.class).getString("CTL_ChangeLog_settings"); // NOI18N
    }


    public HelpCtx getHelpCtx () {
        return new HelpCtx (ChangeLogSettings.class);
    }
    
    /** Getter for property defaultServerInfo.
     * @return Value of property defaultServerInfo.
     */
    public String getDefaultServerInfo() {
        return (String)getProperty(PROP_DEFAULT_SERVER);
    }
    
    /** Setter for property defaultServerInfo.
     * @param defaultServerInfo New value of property defaultServerInfo.
     */
    public void setDefaultServerInfo(String defaultServerInfo) {
        putProperty(PROP_DEFAULT_SERVER, defaultServerInfo, true);
    }
    
    /** Getter for property showBranchesByDefault.
     * @return Value of property showBranchesByDefault.
     */
    public boolean isShowBranchesByDefault() {
        return ((Boolean)getProperty(PROP_SHOW_BRANCHES)).booleanValue();
    }
    
    /** Setter for property showBranchesByDefault.
     * @param showBranchesByDefault New value of property showBranchesByDefault.
     */
    public void setShowBranchesByDefault(boolean showBranchesByDefault) {
        putProperty(PROP_SHOW_BRANCHES, showBranchesByDefault ? Boolean.TRUE : Boolean.FALSE);
    }
    
}