/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */
package org.netbeans.modules.exceptions.web.action;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import oracle.toplink.essentials.config.PessimisticLock;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionForward;
import org.netbeans.modules.exceptions.entity.Exceptions;
import org.netbeans.modules.exceptions.entity.Issue;
import org.netbeans.modules.exceptions.entity.Nbuser;
import org.netbeans.modules.exceptions.utils.PersistenceUtils;

/**
 *
 * @author Jan Horvath
 */
public class StatisticsAction extends org.apache.struts.action.Action {

    /* forward name="success" path="" */
    private static final String SUCCESS = "success";
    private static final String PERUSER = "peruser";
    private static final String BYBUILD = "bybuild";
    private static final SimpleDateFormat SDF = new SimpleDateFormat("MM/dd");

    /**
     * This is the action called from the Struts framework.
     * @param mapping The ActionMapping used to select this instance.
     * @param form The optional ActionForm bean for this request.
     * @param request The HTTP Request we are processing.
     * @param response The HTTP Response we are processing.
     * @throws java.lang.Exception
     * @return
     */
    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Calendar cal = Calendar.getInstance();

        String username = request.getParameter("username");
        String byBuild = request.getParameter("bybuild");
        
        if (byBuild != null) {
            cal.getInstance();
            cal.add(Calendar.MONTH, -1);
            int y = cal.get(Calendar.YEAR) - 2000;
            int m = cal.get(Calendar.MONTH);
            int d = cal.get(Calendar.DATE);
            int fromBuild = (y * 10000) + (m * 100) + d;
            List<Long> list = PersistenceUtils.getInstance()
                    .executeNamedQuery("Exceptions.selectBuilds", Collections.singletonMap("from", (Object) fromBuild));
            
            Hashtable data = new Hashtable();
            for (Iterator<Long> it = list.iterator(); it.hasNext();) {
                Long build = it.next();
                Long count = (Long) PersistenceUtils.getInstance()
                        .executeNamedQuerySingleResult("Exceptions.countByBuild", Collections.singletonMap("build", (Object) build));
                data.put("200" + build, count);
            }

            request.setAttribute("data", data);
            return mapping.findForward(BYBUILD);
        }
        
        Nbuser nbuser = null;
        if (username != null) {
            nbuser = (Nbuser) PersistenceUtils.getInstance().executeNamedQuerySingleResult("Nbuser.findByName", Collections.singletonMap("name", (Object) username));
        }
        if (nbuser != null) {
            Collection<Exceptions> exceptions = ((Nbuser)nbuser).getExceptionsCollection();
            TableCell tc = new TableCell();
            int all = 0;
            int nonDuplicates = 0;
            for (Exceptions exc : exceptions) {
                Integer izId = getOriginal(exc).getIssuezillaid();
                all++;
                if (exc.getDuplicateof() == null) {
                    nonDuplicates++;
                }
                if (izId != null && izId.intValue() > 0) {
                    Issue iss = PersistenceUtils.getInstance().getEntity(Issue.class, izId);
                    tc.addIssue(iss);
                }
            }
            tc.setAllReports(all);
            tc.setNonDuplicateReports(nonDuplicates);
            request.setAttribute("cell", tc);
            return mapping.findForward(PERUSER);
        }
        
        List<Exceptions> l;
        ArrayList al = new ArrayList();

        for (int i = 0; i < 12; i++) {
            TableCell tc = new TableCell();
            Date end = cal.getTime();
            cal.add(Calendar.DATE, -7);
            Date start = cal.getTime();
            tc.setStart(start);
            tc.setEnd(end);
            int all = 0;
            int nonDuplicates = 0;
            l = getExceptionsFromInterval(start, end);
            for (Exceptions exc : l) {
                Integer izId = exc.getIssuezillaid();
                all++;
                if (exc.getDuplicateof() == null) {
                    nonDuplicates++;
                }
                if (izId != null && izId.intValue() > 0) {
                    Issue iss = PersistenceUtils.getInstance().getEntity(Issue.class, izId);
                    tc.addIssue(iss);
                }
            }
            tc.setAllReports(all);
            tc.setNonDuplicateReports(nonDuplicates);
            al.add(tc);
        }

        request.setAttribute("data", al);
        return mapping.findForward(SUCCESS);
    }
    
    private Exceptions getOriginal(Exceptions exc) {
        Exceptions orig = exc.getDuplicateof();
        return orig == null ? exc : orig;
    }

    protected Integer getExceptionsCountFromInterval(Date start, Date end) {
        Hashtable params = new Hashtable();
        params.put("start", start);
        params.put("end", end);
        return (Integer) PersistenceUtils.getInstance().executeNamedQuerySingleResult("Exceptions.countByInterval", params);
    }

    protected List<Exceptions> getExceptionsFromInterval(Date start, Date end) {
        Hashtable params = new Hashtable();
        params.put("start", start);
        params.put("end", end);
        return (List<Exceptions>) PersistenceUtils.getInstance().executeNamedQuery("Exceptions.findByInterval", params);
    }

    public class TableCell {

        private Date start;
        private Date end;
        private int allReports = 0;
        private int duplicates = 0;
        private int nonDuplicates = 0;
        private Set<Issue> issues;
        private Set<Issue> fixed;
        
        public TableCell() {
            issues = new HashSet<Issue>();
            fixed = new HashSet<Issue>();
        }

        public void addIssue(Issue issue) {
            if (issue != null) {
                if ("DUPLICATE".equals(issue.getResolution())) {
                    duplicates++;
                }
                
                if ("FIXED".equals(issue.getResolution())) {
                    fixed.add(issue);
                } else {
                    issues.add(issue);
                }
            }
        }
        
        public String getIssuesURL() {
            StringBuffer sb = new StringBuffer();
            sb.append("http://www.netbeans.org/issues/buglist.cgi?issue_id=");
            for (Issue issue : issues) {
                sb.append(issue.getIssueId());
                sb.append(",");
            }
            for (Issue issue : fixed) {
                sb.append(issue.getIssueId());
                sb.append(",");
            }
            return sb.toString();
        }

        public Date getStart() {
            return start;
        }

        public void setStart(Date start) {
            this.start = start;
        }

        public Date getEnd() {
            return end;
        }

        public void setEnd(Date end) {
            this.end = end;
        }

        public int getAllReports() {
            return allReports;
        }

        public void setAllReports(int allReports) {
            this.allReports = allReports;
        }
        
        public int getNonDuplicateReports() {
            return nonDuplicates;
        }

        public void setNonDuplicateReports(int nonDuplicates) {
            this.nonDuplicates = nonDuplicates;
        }

        public int getFixed() {
            return fixed.size();
        }

        public int getDuplicates() {
            return duplicates;
        }

        public Set<Issue> getOpenIssues() {
            return issues;
        }
        
        public Set<Issue> getFixedIssues() {
            return fixed;
        }

        public int getIssuesCount() {
            return issues.size() + fixed.size();
        }
        
        public String getDateString() {
            return SDF.format(start) + " - " + SDF.format(end);
        }
    }
}