<%@include file="/WEB-INF/jspf/header.jspf" %>
<%@ taglib prefix="exc" uri="/WEB-INF/tlds/Exc"%>
<%@taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn"%> 

<script language='javascript'>
    function getComp() {
        i = document.getElementById("queryform").component.selectedIndex;
        return document.getElementById("queryform").component.options[i].value;
    }
    function getSub()
    { 
        var req = null; 
        document.getElementById("queryform").subcomponent.add(new Option("aa","aa"),null);
        if(window.XMLHttpRequest)
            req = new XMLHttpRequest(); 
        else if (window.ActiveXObject)
            req  = new ActiveXObject(Microsoft.XMLHTTP); 
        
        req.onreadystatechange = function () {
            if(req.readyState == 4)
                {
                    if(req.status == 200)
                        {
                            document.getElementById("queryform").subcomponent.length=0;
                            list = req.responseText.split(",");
                            for (i=0;i<list.length;i++) {                                        
                                document.getElementById("queryform").subcomponent.add(new Option(list[i],list[i]),null);
                            }      
                        }
                    }
                };
                var url = "subcomponents?component="+getComp();
                req.open("GET", url, true); 
                req.setRequestHeader("Content-Type", "application/x-www-form-urlencoded"); 
                req.send(null); 
            }
            
            function validate(f) {
                if(f.duplicateof.value=="${exceptions.id}") {
                    alert ("Can't create duplicate of itself.");
                    return false;
                }
                return true;
            }
            </script>
<div id="issuezilla" class="application">
    <!--BEGINNING OF H2 CLASS-->
    
    <h2>Exception ${exceptions.id}</h2>
    
    
    <div>
        <div>
            <form action="detail.do" method=GET  id="queryform" onsubmit="return validate(this);">
            <input type='hidden' name='id' value='${exceptions.id}'/>
            <table class="axial">
                <tr>
                    <th>Exception #:</th>
                    <td>${exceptions.id}</td>
                    <td>&nbsp;</td>
                    <th>VM:</th>
                    
                    <td>${exceptions.vm}</td>
                    <td>&nbsp;</td>
                    
                </tr>
                <tr>
                    <th>Component:</th>
                    
                    <td>
                        <select name="component" onchange="getSub();" style="width: 180px;">
                            <c:forEach var="component" items='${components}' varStatus="stat">
                                <option value="${component}" 
                                        <c:if test="${exceptions.component == component}">selected</c:if>
                                        >
                                        ${component}</option>
                                </c:forEach>
                        </select>
                    </td>
                    <td>&nbsp;</td>
                    <th>OS:</th>
                    <td>${exceptions.operatingsystem}</td>
                    <td>&nbsp;</td>
                    
                </tr>
                <tr>
                    <th>Subcomponent:</th>
                    <td>
                        <select name="subcomponent" style="width: 180px;">
                            <exc:subcomponents entity='Exceptions' component='${exceptions.component}' var='subcomponent'>
                                <option value="${subcomponent}" 
                                        <c:if test="${exceptions.subcomponent == subcomponent}">selected</c:if>
                                        >
                                        ${subcomponent}</option>
                                </exc:subcomponents>
                        </select>
                    </td>
                    <td>&nbsp;</td>
                    <th>Version:</th>
                    <td>${exceptions.productversion}</td>
                    
                    <td>&nbsp;</td>
                    
                </tr>
                <tr>
                    <th>Assigned to:</th>
                    <td colspan="5"></td>
                </tr>
                <tr>
                    <th>Summary:</th>
                    <td colspan="5">${exceptions.summary}</td>
                </tr>
                <tr>
                    <th>Message:</th>
                    <td colspan="5">${exceptions.stacktrace.message}</td>
                </tr>
                
                <tr>
                    <th>Class:</th>
                    <td colspan="5">${exceptions.stacktrace.class1}</td>
                </tr>
                <tr>
                    <th>Issuezilla:</th>
                    <td colspan="5"><exc:issuezilla exceptions='${exceptions}'/>
                        <input type='text' maxlength='z' name='issuezillaid'/>
                    </td>
                </tr>
                <tr>
                    <th>Duplicates:</th>
                    <td colspan="5"><exc:duplicates exceptions='${exceptions}'/>
                    </td>
                </tr>
                <tr>
                    <th>Duplicate Of:</th>
                    <td colspan="5"><a href='detail.do?id=${exceptions.duplicateof.id}'>${exceptions.duplicateof.id}</a>
                        <input type='text' maxlength='7' name='duplicateof' value='${exceptions.duplicateof.id}'/>
                    </td>
                </tr> 
            </table>
        </div>
        <div class="functnbar3">
            <input type="submit" value="Submit" />
            <input type="reset" value="Reset" />
            </form>
        </div>
        
    </div>
    <table width="100%"><tr><td class="left"><strong>Description:</strong></td>
            <td>Opened: </td>
            <td>Sort by: </td>
            
    </tr></table>
    <hr />
    
    <div id="desc1" title="stacktrace">
        <h3>Stacktrace: <a href='stacktrace.do?id=${exceptions.id}'><i>Find Similar Stacktrace</i></a></h3>
        <pre>
                <exc:stacktrace stacktrace='${exceptions.stacktrace}'/>
        </pre>
    </div>
    
    <div id="desc2" title="comments">
        <h3>Logger: <a href="loggerasxml?id=${exceptions.id}"><i>XML</i></a></h3> 
        <iframe height="200" width="90%" frameborder="0" src='detail.do?id=${exceptions.id}&logger'>
            <a href='detail.do?logger&id=${exceptions.id}'>logger</a>
        </iframe>
    </div>
    
    <div id="desc2" title="comments">
        <h3>Duplicates:</h3>
        <table width = '90%'>
            <tr>
                <th>Id</th>
                <th>Summary</th>
                <th>OS</th>
                <th>JVM</th>
                <th>Build</th>
            </tr>
            <c:forEach var="exception" items='${exceptions.duplicatesCollection}' varStatus="stat">
                <tr class="${(stat.index % 2) == 0 ? "b" : "a"}">
                    <td><a href='detail.do?id=${exception.id}'>${exception.id}</a></td>
                    <td>${fn:substring(exception.summary,0,55)}</td>
                    <td>${exception.operatingsystem}</td>
                    <td>${exception.vm}</td>
                    <td>${exc:buildNumberFormatLong(exception.build)}</td>
                </tr>
            </c:forEach>
        </table>
    </div>
    
    <div id="desc2" title="comments">
        <h3>Comments:</h3>
        <table width = '90%'>
            <tr>
                <th>Reporter</th>
                <th>Comment</th>
            </tr>
            <c:forEach var="comment" items='${exceptions.commentCollection}'>
                <tr>
                    <th>${comment.nbuserId.name}:</th>
                    <td>${comment.comment}</td>
                </tr>
            </c:forEach>
            <c:forEach var="duplicate" items='${exceptions.duplicatesCollection}'>
            <c:forEach var="comment" items='${duplicate.commentCollection}'>
                    <tr>
                        <th>${comment.nbuserId.name}:</th>
                        <td>${comment.comment}</td>
                    </tr>
                </c:forEach>
                </c:forEach>
        </table>
        <form action="detail.do" method=GET  id="commentform">
            <input type='hidden' name='id' value='${exceptions.id}'/>
            <h3>Add Comment:</h3>
            <table  width = '90%'>
                <tr>
                    <th>
                        Comment:
                    </th>
                    <td>
                        <textarea cols="80" rows="6" name='comment'></textarea><br/>
                    </td>
                </tr>
                <tr>
                    <th colspan="2">
                        <input type="submit" value="Send"/>
                    </th>
                </tr>
            </table>
        </form>
    </div>
    <hr />
    
    <!--ENDING OF CLASS H2-->
</div>
<p></p><!--ENDING OF CLASS APP-->
<%@include file="/WEB-INF/jspf/footer.jspf" %>