<%@include file="/WEB-INF/jspf/header.jspf" %>
<%--
The taglib directive below imports the JSTL library. If you uncomment it,
you must also add the JSTL library to the project. The Add Library... action
on Libraries node in Projects view can be used to add the JSTL 1.1 library.
--%>

<%@taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c"%> 
<%@taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn"%> 
<%@taglib uri="http://java.sun.com/jstl/fmt" prefix="fmt" %>
<%@taglib prefix="exc" uri="/WEB-INF/tlds/Exc"%>

<p class="tasknav">
    <a href="list.do?query">Query</a> | <a href="list.do?unmapped">Unmapped</a> | <a href="list.do?reset">All</a>
</p>
<div class="h2">
    <h2>Reporting Statistic</h2>
    <table>
        
        <c:forEach var="cell" items='${data}' varStatus="stat">
        <c:if test="${(stat.index % 4) == 0}">
        <tr>
            <td>
                <table>
                    <tr>
                        <th>
                            Date:
                        </th>
                    </tr>
                    <tr>
                        <th>
                            All Reports:
                        </th>
                    </tr>
                    <tr>
                        <th>
                            Non Duplicate Reports:
                        </th>
                    </tr>
                    <tr>
                        <th>
                            In Issuezilla:
                        </th>
                    </tr>
                    <tr>
                        <th>
                            Fixed:
                        </th>
                    </tr>
                    <tr>
                        <th>
                            Duplicates:
                        </th>
                    </tr>
                </table>
            </td>
        
        </c:if>
            <td>
                <table>
                    <tr>
                        <th>
                            ${cell.dateString}
                        </th>
                    </tr>
                    <tr>
                        <td>
                            ${cell.allReports}
                        </td>
                    </tr>
                    <tr>
                        <td>
                            ${cell.nonDuplicateReports}
                        </td>
                    </tr>
                    <tr>
                        <td>
                            <a href='${cell.issuesURL}'>${cell.issuesCount}</a>
                        </td>
                    </tr>
                    <tr>
                        <td>
                            ${cell.fixed}
                        </td>
                    </tr>
                    <tr>
                        <td>
                            ${cell.duplicates}
                        </td>
                    </tr>
                </table>
                <%--
                ${col["count"]}, <a href='http://www.netbeans.org/issues/buglist.cgi?issue_id=${col["issuelist"]}'>${col["issues"]}</a>, ${col["duplicates"]}, ${col["fixed"]}<br/>
                <c:forEach var="exc" items='${col}' varStatus="stat">
                ${exc["count"]}, ${exc["issue"]}<br/>
                </c:forEach>
                
                --%>
            </td>
        <c:if test="${(((stat.index + 1) % 4) == 0) || (stat.last)}">
        </tr>
        
        </c:if>
        </c:forEach>
    </table>
</div>
<%@include file="/WEB-INF/jspf/footer.jspf" %>