/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */

package org.netbeans.server.componentsmatch;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

/**
 * convert stacktrace to Component
 */
public final class Matcher {
    static Matcher packageMerger;
    
    static List<Package> allPackages;
    
    static Matcher defaultMatcher;
    static final String ORG_NETBEANS_MODULES = "org.netbeans.modules";
    static final String ORG_NETBEANS_LIB = "org.netbeans.lib";
    // XXX I am not sure if it is the best idea to check netbeans.org prefixes
    // it is not applicable to other product (rave, etc)
    static final String[] NB_ORG_PREFIXES = new String[] {
        "org.openide.","org.netbeans.","org.apache.tools.ant.module.","org.openidex."
    };
    
    Map<String,Package> packages = new HashMap<String,Package>();
    /** Creates a new instance of Matcher */
    Matcher(List<Package> packages) {
        for (Package pack : packages) {
            this.packages.put(pack.getName(),pack);
        }
    }
    
    Matcher() {
        
    }
    
    private Component[] matchAll(StackTraceElement[] stes){
        Component[] result = new Component[stes.length];
        for (int i=0;i<stes.length;i++) {
            result[i] = match(stes[i]);
        }
        return result;
    }
    
    
    private Component fromJar(String jarFileName){
        if (jarFileName == null) return null;
        if (jarFileName.startsWith("${java.home}")){
            return null;
        }
        if (jarFileName.startsWith("$")){
            int position = jarFileName.indexOf('}');
            String comp =jarFileName.substring(2, position);
            String subComp = jarFileName.substring(jarFileName.lastIndexOf('/')+1, jarFileName.length());
            if ("user.home".equals(comp)&& "tools.jar".equals(subComp)) return null;
            return new Component(comp, subComp, 0);
        }
        return null;
    }
    
    /** @return component or null if no component was found
     * @param stes exception stacktrace
     */
    public Component match(StackTraceElement[] stes){
        Component[] comp = Matcher.getDefault().matchAll(stes);
        for (int i=0; i<comp.length; i++){
            if (comp[i] == null){
                comp[i] = fromJar(stes[i].getFileName());
            }
        }
        for (int i=0; i<comp.length; i++){
            if (comp[i] != null) return comp[i];
        }
        return null;
    }
    
    private  Component match(StackTraceElement ste) {
        String className = ste.getClassName();
        int index = 0;
        while ((index = className.indexOf('.',index)) != -1) {
            if ( index + 1 < className.length()) {
                if (Character.isUpperCase(className.charAt(index + 1))) {
                    break;
                }
            }
            index++;
        }
        if (index != -1) {
            String packageName = className.substring(0,index);
            Package pack = getPackage(packageName);
            if (pack != null) {
                return pack.getFirstComponent();
            } else {
                // try merge other packages
                if (checkNetBeansOrgSubPackage(packageName)) {
                    pack = getPackageMerger().getPackage(packageName);
                    if (pack != null) {
                        Component comp = pack.getFirstComponent();
                        if (comp != null ) {
                            String cname = comp.getComponent();
                            // do not merge results from subpackages for core and openide components
                            if (!(cname.equals("core") || cname.equals("openide"))) {
                                return comp;
                            }
                        }
                    }
                }
                
            }
        }
        return null;
    }
    
    private  Package getPackage(String name) {
        Package pack = packages.get(name);
        if (pack == null) {
            // get subpackage
            int lastDot = name.lastIndexOf('.');
            if (lastDot != -1) {
                name = name.substring(0,lastDot);
                if (name.equals(ORG_NETBEANS_MODULES) || name.equals(ORG_NETBEANS_LIB)) {
                    return null;
                }
                pack = getPackage(name);
            }
        }
        
        return pack;
    }
    
    private static Matcher getPackageMerger() {
        if (packageMerger == null) {
            packageMerger = new Matcher();
            if (allPackages == null) {
                return packageMerger;
            }
            for (Package pack : allPackages) {
                String name = pack.getName();
                int index = -1;
                while ((index = name.lastIndexOf(name)) != -1) {
                    name = name.substring(0,index);
                    if (!checkNetBeansOrgSubPackage(name)) {
                        break;
                    }
                    packageMerger.addPackage(name,pack.getComponents());
                }
            }
        }
        return packageMerger;
    }
    
    private void addPackage(String name,Collection<Component> components ) {
        Package pack = packages.get(name);
        if (pack == null) {
            pack = new Package(name);
            packages.put(name,pack);
        }
        for (Component comp : components) {
            pack.addComponent(comp);
        }
    }
    
    private static boolean checkNetBeansOrgSubPackage(String pack) {
        for (String prefix : NB_ORG_PREFIXES) {
            if (pack.startsWith(prefix)) {
                return true;
            }
        }
        return false;
    }
    
    public static Matcher getDefault() {
        if (defaultMatcher == null) {
            defaultMatcher = new Matcher();
            if (allPackages == null) {
                return defaultMatcher;
            }
            for (Package pack : allPackages) {
                defaultMatcher.addPackage(pack.getName(),pack.getComponents());
            }
        }
        return defaultMatcher;
    }
    
    /** registers new package
     */
    public static void addGlobalPackage(Package pack) {
        if (allPackages == null) {
            allPackages = new ArrayList<Package>();
        }
        allPackages.add(pack);
    }
    
    /** read all packages from codeviation package to component
     * report
     */
    public static void read(Reader r) throws IOException {
        BufferedReader reader = new BufferedReader(r);
        String line = null;
        if (allPackages == null )allPackages = new ArrayList<Package>();
        else allPackages.clear();
        defaultMatcher = null;
        packageMerger = null;
        //org.openide.util.datatransfer;1;openide;nodes;1;
        
        
        while ((line = reader.readLine()) != null) {
            StringTokenizer tokenizer = new StringTokenizer(line,";");
            String token = tokenizer.nextToken();
            if (token != null) {
                String count = tokenizer.nextToken();
                Package pack = new Package(token);
                while(tokenizer.hasMoreTokens()) {
                    token = tokenizer.nextToken();
                    if (tokenizer.hasMoreTokens()) {
                        String subComponent  = tokenizer.nextToken();
                        if (tokenizer.hasMoreTokens()) {
                            count = tokenizer.nextToken();
                            pack.addComponent(new Component(token,subComponent,Integer.parseInt(count)));
                        }
                        
                    }
                }
                allPackages.add(pack);
            }
        }
        reader.close();
    }
    
}
