/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */

package org.netbeans.server.uihandler.statistics;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.servlet.jsp.PageContext;
import org.netbeans.modules.exceptions.entity.Exceptions;
import org.netbeans.modules.exceptions.utils.PersistenceUtils;
import org.netbeans.server.uihandler.Statistics;
import org.netbeans.server.uihandler.Utils;
import org.netbeans.server.uihandler.statistics.ExceptionReports.Data;
/**
 *
 * @author Jindrich Sedek
 */

public class ExceptionReports extends Statistics<ExceptionReports.Data>{
    private static Logger LOG = Logger.getLogger(ExceptionReports.class.getName());
    public ExceptionReports() {
        super("ExceptionReports");
    }
    
    protected Data newData() {
        return null;
    }
    
    protected Data process(LogRecord rec) {
        return null;
    }
    
    protected Data join(Data one, Data two) {
        return null;
    }
    
    protected Data finishSessionUpload(String userId, int sessionNumber, boolean initialParse, Data data) {
        return null;
    }
    
    @Override
    protected void registerPageContext(PageContext page, String name, Data data) {
        Data dat = new Data();
        Map<String, Integer> result = new TreeMap<String, Integer>();
        try {
            PersistenceUtils pUtils = Utils.getPersistenceUtils();
            dat.globalReportsNumber = pUtils.count(Exceptions.class);
            List<String> list = pUtils.getDistinct(Exceptions.class, "component");
            Iterator<String> iter = list.iterator();
            int minimumToShow = dat.globalReportsNumber / 20; // 5%
            while (iter.hasNext()){
                //List<String> list =  iter.next();
                String str = iter.next();
                int count = pUtils.count(Exceptions.class, "entity.component = '" + str+"'");
                if ((str != null)&&(count > minimumToShow)) result.put(str, count);
            }
        } catch (Exception ex) {
            // requires database and that is not present
            LOG.log(Level.WARNING, ex.getMessage(), ex);
        }
        dat.components = result;
        super.registerPageContext(page, name, dat);
    }
    
    public static final class Data{
        int globalReportsNumber;
        Map<String, Integer> components;
        
        public Data(){
            globalReportsNumber = 0;
        }
        
        public Data(int global){
            globalReportsNumber = global;
        }
        
        public int getGlobalReportsNumber(){
            return globalReportsNumber;
        }
        
        public Map<String, Integer> getComponents(){
            if (components!= null) return components;
            else return Collections.emptyMap();
        }
        
        public List<String> getSortedKeys(){
            List<String> list = new ArrayList(components.keySet());
            Collections.sort(list, new ReportsComparator());
            return list;
        }
        
        private final class ReportsComparator implements Comparator<String>{

            public int compare(String o1, String o2) {
                return components.get(o1).compareTo(components.get(o2));
            }
            
        }
    }

    protected void write(Preferences pref, Data d) throws BackingStoreException {
        // data are saved in DB for this statistics
    }

    protected Data read(Preferences pref) throws BackingStoreException {
        return null; // nothing is needed to be done
    }
}
